/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project;

import com.intellij.CommonBundle;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import org.jetbrains.annotations.NotNull;

public class PropertyBasedDoNotAskOption
implements DialogWrapper.DoNotAskOption {
    @NotNull
    private final Project myProject;
    @NotNull
    private final String myProperty;

    public PropertyBasedDoNotAskOption(@NotNull Project project, @NotNull String property) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/PropertyBasedDoNotAskOption", "<init>"));
        }
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "com/android/tools/idea/gradle/project/PropertyBasedDoNotAskOption", "<init>"));
        }
        this.myProject = project;
        this.myProperty = property;
    }

    public boolean isToBeShown() {
        return PropertiesComponent.getInstance((Project)this.myProject).getBoolean(this.myProperty, true);
    }

    public void setToBeShown(boolean toBeShown, int exitCode) {
        PropertiesComponent.getInstance((Project)this.myProject).setValue(this.myProperty, String.valueOf(toBeShown));
    }

    public boolean canBeHidden() {
        return true;
    }

    public boolean shouldSaveOptionsOnCancel() {
        return true;
    }

    @NotNull
    public String getDoNotShowMessage() {
        String string = CommonBundle.message((String)"dialog.options.do.not.show", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/PropertyBasedDoNotAskOption", "getDoNotShowMessage"));
        }
        return string;
    }
}

