/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync;

import com.android.tools.idea.IdeInfo;
import com.android.tools.idea.gradle.project.AndroidGradleNotification;
import com.android.tools.idea.gradle.project.build.invoker.GradleTasksExecutor;
import com.android.tools.idea.gradle.project.importing.NewProjectImportGradleSyncListener;
import com.android.tools.idea.gradle.project.importing.OpenMigrationToGradleUrlHyperlink;
import com.android.tools.idea.gradle.project.sync.GradleSyncListener;
import com.android.tools.idea.gradle.project.sync.GradleSyncState;
import com.android.tools.idea.gradle.project.sync.cleanup.PreSyncProjectCleanUp;
import com.android.tools.idea.gradle.project.sync.idea.IdeaGradleSync;
import com.android.tools.idea.gradle.project.sync.precheck.PreSyncCheckResult;
import com.android.tools.idea.gradle.project.sync.precheck.PreSyncChecks;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.gradle.util.Projects;
import com.android.tools.idea.project.AndroidProjectInfo;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Objects;
import com.google.common.base.Strings;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.service.execution.ProgressExecutionMode;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.TaskInfo;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.ex.StatusBarEx;
import com.intellij.openapi.wm.ex.WindowManagerEx;
import com.intellij.ui.AppUIUtil;
import com.intellij.util.ui.UIUtil;
import java.io.File;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GradleSyncInvoker {
    @NotNull
    private final FileDocumentManager myFileDocumentManager;
    @NotNull
    private final IdeInfo myIdeInfo;
    @NotNull
    private final PreSyncProjectCleanUp myPreSyncProjectCleanUp;
    @NotNull
    private final PreSyncChecks myPreSyncChecks;

    @NotNull
    public static GradleSyncInvoker getInstance() {
        GradleSyncInvoker gradleSyncInvoker = (GradleSyncInvoker)ServiceManager.getService(GradleSyncInvoker.class);
        if (gradleSyncInvoker == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/sync/GradleSyncInvoker", "getInstance"));
        }
        return gradleSyncInvoker;
    }

    public GradleSyncInvoker(@NotNull FileDocumentManager fileDocumentManager, @NotNull IdeInfo ideInfo) {
        if (fileDocumentManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileDocumentManager", "com/android/tools/idea/gradle/project/sync/GradleSyncInvoker", "<init>"));
        }
        if (ideInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ideInfo", "com/android/tools/idea/gradle/project/sync/GradleSyncInvoker", "<init>"));
        }
        this(fileDocumentManager, ideInfo, new PreSyncProjectCleanUp(), new PreSyncChecks());
    }

    @VisibleForTesting
    GradleSyncInvoker(@NotNull FileDocumentManager fileDocumentManager, @NotNull IdeInfo ideInfo, @NotNull PreSyncProjectCleanUp preSyncProjectCleanUp, @NotNull PreSyncChecks preSyncChecks) {
        if (fileDocumentManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileDocumentManager", "com/android/tools/idea/gradle/project/sync/GradleSyncInvoker", "<init>"));
        }
        if (ideInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ideInfo", "com/android/tools/idea/gradle/project/sync/GradleSyncInvoker", "<init>"));
        }
        if (preSyncProjectCleanUp == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "preSyncProjectCleanUp", "com/android/tools/idea/gradle/project/sync/GradleSyncInvoker", "<init>"));
        }
        if (preSyncChecks == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "preSyncChecks", "com/android/tools/idea/gradle/project/sync/GradleSyncInvoker", "<init>"));
        }
        this.myFileDocumentManager = fileDocumentManager;
        this.myIdeInfo = ideInfo;
        this.myPreSyncProjectCleanUp = preSyncProjectCleanUp;
        this.myPreSyncChecks = preSyncChecks;
    }

    public void requestProjectSyncAndSourceGeneration(@NotNull Project project, @Nullable GradleSyncListener listener) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/sync/GradleSyncInvoker", "requestProjectSyncAndSourceGeneration"));
        }
        this.requestProjectSync(project, Request.DEFAULT_REQUEST, listener);
    }

    public void requestProjectSync(@NotNull Project project, @NotNull Request request, @Nullable GradleSyncListener listener) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/sync/GradleSyncInvoker", "requestProjectSync"));
        }
        if (request == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/android/tools/idea/gradle/project/sync/GradleSyncInvoker", "requestProjectSync"));
        }
        if (GradleSyncState.getInstance(project).isSyncInProgress()) {
            return;
        }
        if (GradleSyncInvoker.isBuildInProgress(project)) {
            Projects.setSyncRequestedDuringBuild(project, true);
            return;
        }
        UIUtil.invokeAndWaitIfNeeded(() -> {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/sync/GradleSyncInvoker", "lambda$requestProjectSync$0"));
            }
            return ExternalSystemUtil.ensureToolWindowContentInitialized((Project)project, (ProjectSystemId)GradleUtil.GRADLE_SYSTEM_ID);
        });
        Runnable syncTask = () -> {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/sync/GradleSyncInvoker", "lambda$requestProjectSync$1"));
            }
            if (request == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/android/tools/idea/gradle/project/sync/GradleSyncInvoker", "lambda$requestProjectSync$1"));
            }
            try {
                if (this.prepareProject(project, request, listener)) {
                    this.sync(project, request, listener);
                }
            }
            catch (ConfigurationException e) {
                Messages.showErrorDialog((Project)project, (String)e.getMessage(), (String)e.getTitle());
            }
        };
        if (request.isRunInBackground()) {
            AppUIUtil.invokeLaterIfProjectAlive((Project)project, (Runnable)syncTask);
        } else {
            UIUtil.invokeAndWaitIfNeeded((Runnable)syncTask);
        }
    }

    private static boolean isBuildInProgress(@NotNull Project project) {
        StatusBarEx statusBar;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/sync/GradleSyncInvoker", "isBuildInProgress"));
        }
        IdeFrame frame = ((WindowManagerEx)WindowManager.getInstance()).findFrameFor(project);
        StatusBarEx statusBarEx = statusBar = frame == null ? null : (StatusBarEx)frame.getStatusBar();
        if (statusBar == null) {
            return false;
        }
        for (Pair backgroundProcess : statusBar.getBackgroundProcesses()) {
            ProgressIndicator second;
            TaskInfo task = (TaskInfo)backgroundProcess.getFirst();
            if (!(task instanceof GradleTasksExecutor) || !(second = (ProgressIndicator)backgroundProcess.getSecond()).isRunning()) continue;
            return true;
        }
        return false;
    }

    private boolean prepareProject(@NotNull Project project, @NotNull Request request, @Nullable GradleSyncListener listener) throws ConfigurationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/sync/GradleSyncInvoker", "prepareProject"));
        }
        if (request == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/android/tools/idea/gradle/project/sync/GradleSyncInvoker", "prepareProject"));
        }
        if (AndroidProjectInfo.getInstance(project).requiresAndroidModel() || GradleSyncInvoker.hasTopLevelGradleBuildFile(project)) {
            if (!request.isNewProject()) {
                this.myFileDocumentManager.saveAllDocuments();
            }
            return true;
        }
        AppUIUtil.invokeLaterIfProjectAlive((Project)project, () -> {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/sync/GradleSyncInvoker", "lambda$prepareProject$2"));
            }
            String msg = String.format("The project '%s' is not a Gradle-based project", project.getName());
            AndroidGradleNotification.getInstance(project).showBalloon("Project Sync", msg, NotificationType.ERROR, new OpenMigrationToGradleUrlHyperlink());
            if (listener != null) {
                listener.syncFailed(project, msg);
            }
        });
        return false;
    }

    private static boolean hasTopLevelGradleBuildFile(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/sync/GradleSyncInvoker", "hasTopLevelGradleBuildFile"));
        }
        String projectFolderPath = project.getBasePath();
        if (projectFolderPath != null) {
            File buildFile = new File(projectFolderPath, "build.gradle");
            return buildFile.isFile();
        }
        return false;
    }

    private void sync(@NotNull Project project, @NotNull Request request, @Nullable GradleSyncListener listener) {
        PreSyncCheckResult canSync;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/sync/GradleSyncInvoker", "sync"));
        }
        if (request == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/android/tools/idea/gradle/project/sync/GradleSyncInvoker", "sync"));
        }
        if (this.myIdeInfo.isAndroidStudio()) {
            GradleUtil.clearStoredGradleJvmArgs(project);
        }
        if (!(canSync = this.myPreSyncChecks.canSync(project)).isSuccess()) {
            String cause = Strings.nullToEmpty((String)canSync.getFailureCause());
            GradleSyncInvoker.handlePreSyncCheckFailure(project, cause, listener);
            return;
        }
        boolean started = request.isUseCachedGradleModels() ? GradleSyncState.getInstance(project).skippedSyncStarted(!request.isNewProject()) : GradleSyncState.getInstance(project).syncStarted(!request.isNewProject());
        if (!started) {
            return;
        }
        GradleSyncInvoker.removeAndroidModels(project);
        this.myPreSyncProjectCleanUp.cleanUp(project);
        IdeaGradleSync gradleSync = new IdeaGradleSync();
        gradleSync.sync(project, request, listener);
    }

    private static void handlePreSyncCheckFailure(@NotNull Project project, @NotNull String failureCause, @Nullable GradleSyncListener syncListener) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/sync/GradleSyncInvoker", "handlePreSyncCheckFailure"));
        }
        if (failureCause == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "failureCause", "com/android/tools/idea/gradle/project/sync/GradleSyncInvoker", "handlePreSyncCheckFailure"));
        }
        GradleSyncState syncState = GradleSyncState.getInstance(project);
        if (syncState.syncStarted(true)) {
            NewProjectImportGradleSyncListener.createTopLevelProjectAndOpen(project);
            syncState.syncFailed(failureCause);
            if (syncListener != null) {
                syncListener.syncFailed(project, failureCause);
            }
        }
    }

    private static void removeAndroidModels(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/sync/GradleSyncInvoker", "removeAndroidModels"));
        }
        ModuleManager moduleManager = ModuleManager.getInstance((Project)project);
        for (Module module : moduleManager.getModules()) {
            AndroidFacet facet = AndroidFacet.getInstance(module);
            if (facet == null) continue;
            facet.setAndroidModel(null);
        }
    }

    public static class Request {
        private static final Request DEFAULT_REQUEST = new Request();
        private boolean myRunInBackground = true;
        private boolean myGenerateSourcesOnSuccess = true;
        private boolean myCleanProject;
        private boolean myUseCachedGradleModels;
        private boolean myNewProject;

        public boolean isRunInBackground() {
            return this.myRunInBackground;
        }

        @NotNull
        public Request setRunInBackground(boolean runInBackground) {
            this.myRunInBackground = runInBackground;
            Request request = this;
            if (request == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/sync/GradleSyncInvoker$Request", "setRunInBackground"));
            }
            return request;
        }

        public boolean isGenerateSourcesOnSuccess() {
            return this.myGenerateSourcesOnSuccess;
        }

        @NotNull
        public Request setGenerateSourcesOnSuccess(boolean generateSourcesOnSuccess) {
            this.myGenerateSourcesOnSuccess = generateSourcesOnSuccess;
            Request request = this;
            if (request == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/sync/GradleSyncInvoker$Request", "setGenerateSourcesOnSuccess"));
            }
            return request;
        }

        public boolean isCleanProject() {
            return this.myCleanProject;
        }

        @NotNull
        public Request setCleanProject(boolean cleanProject) {
            this.myCleanProject = cleanProject;
            Request request = this;
            if (request == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/sync/GradleSyncInvoker$Request", "setCleanProject"));
            }
            return request;
        }

        public boolean isUseCachedGradleModels() {
            return this.myUseCachedGradleModels;
        }

        @NotNull
        public Request setUseCachedGradleModels(boolean useCachedGradleModels) {
            this.myUseCachedGradleModels = useCachedGradleModels;
            Request request = this;
            if (request == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/sync/GradleSyncInvoker$Request", "setUseCachedGradleModels"));
            }
            return request;
        }

        public boolean isNewProject() {
            return this.myNewProject;
        }

        @NotNull
        public Request setNewProject(boolean newProject) {
            this.myNewProject = newProject;
            Request request = this;
            if (request == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/sync/GradleSyncInvoker$Request", "setNewProject"));
            }
            return request;
        }

        @NotNull
        public ProgressExecutionMode getProgressExecutionMode() {
            ProgressExecutionMode progressExecutionMode = this.isRunInBackground() ? ProgressExecutionMode.IN_BACKGROUND_ASYNC : ProgressExecutionMode.MODAL_SYNC;
            if (progressExecutionMode == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/sync/GradleSyncInvoker$Request", "getProgressExecutionMode"));
            }
            return progressExecutionMode;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Request request = (Request)o;
            return this.myRunInBackground == request.myRunInBackground && this.myCleanProject == request.myCleanProject && this.myGenerateSourcesOnSuccess == request.myGenerateSourcesOnSuccess && this.myUseCachedGradleModels == request.myUseCachedGradleModels && this.myNewProject == request.myNewProject;
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.myRunInBackground, this.myCleanProject, this.myGenerateSourcesOnSuccess, this.myUseCachedGradleModels, this.myNewProject});
        }

        public String toString() {
            return "RequestSettings{myRunInBackground=" + this.myRunInBackground + ", myCleanProject=" + this.myCleanProject + ", myGenerateSourcesOnSuccess=" + this.myGenerateSourcesOnSuccess + ", myUseCachedGradleModels=" + this.myUseCachedGradleModels + ", myNewProject=" + this.myNewProject + '}';
        }
    }
}

