/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync;

import com.android.builder.model.AndroidProject;
import com.android.builder.model.NativeAndroidProject;
import com.android.tools.idea.gradle.project.sync.GradleSync;
import com.android.tools.idea.gradle.project.sync.GradleSyncInvoker;
import com.android.tools.idea.gradle.project.sync.GradleSyncListener;
import com.android.tools.idea.gradle.project.sync.GradleSyncState;
import com.android.tools.idea.gradle.project.sync.ProjectSetup;
import com.android.tools.idea.gradle.project.sync.SyncAction;
import com.android.tools.idea.gradle.project.sync.common.CommandLineArgs;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.gradle.util.Projects;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationListener;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationListenerAdapter;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskType;
import com.intellij.openapi.externalSystem.service.execution.ProgressExecutionMode;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.Function;
import com.intellij.util.ui.UIUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.gradle.tooling.BuildAction;
import org.gradle.tooling.BuildActionExecuter;
import org.gradle.tooling.CancellationTokenSource;
import org.gradle.tooling.GradleConnector;
import org.gradle.tooling.LongRunningOperation;
import org.gradle.tooling.ProjectConnection;
import org.gradle.tooling.model.gradle.GradleBuild;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.model.ModuleExtendedModel;
import org.jetbrains.plugins.gradle.service.execution.GradleExecutionHelper;
import org.jetbrains.plugins.gradle.settings.GradleExecutionSettings;

public class NewGradleSync
implements GradleSync {
    @NotNull
    private final CommandLineArgs myCommandLineArgs;
    @NotNull
    private final ProjectSetup.Factory myProjectSetupFactory;
    @NotNull
    private final GradleExecutionHelper myHelper;

    NewGradleSync() {
        this(new CommandLineArgs(true), new ProjectSetup.Factory());
    }

    @VisibleForTesting
    NewGradleSync(@NotNull CommandLineArgs commandLineArgs, @NotNull ProjectSetup.Factory projectSetupFactory) {
        if (commandLineArgs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commandLineArgs", "com/android/tools/idea/gradle/project/sync/NewGradleSync", "<init>"));
        }
        if (projectSetupFactory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectSetupFactory", "com/android/tools/idea/gradle/project/sync/NewGradleSync", "<init>"));
        }
        this.myHelper = new GradleExecutionHelper();
        this.myCommandLineArgs = commandLineArgs;
        this.myProjectSetupFactory = projectSetupFactory;
    }

    @Override
    public void sync(final @NotNull Project project, @NotNull GradleSyncInvoker.Request request, final @Nullable GradleSyncListener listener) {
        Object task;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/sync/NewGradleSync", "sync"));
        }
        if (request == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/android/tools/idea/gradle/project/sync/NewGradleSync", "sync"));
        }
        String title = String.format("Syncing project '%1$s' with Gradle", project.getName());
        ProgressExecutionMode executionMode = request.getProgressExecutionMode();
        switch (executionMode) {
            case MODAL_SYNC: {
                task = new Task.Modal(project, title, true){

                    public void run(@NotNull ProgressIndicator indicator) {
                        if (indicator == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/android/tools/idea/gradle/project/sync/NewGradleSync$1", "run"));
                        }
                        NewGradleSync.this.sync(project, indicator, listener);
                    }
                };
                break;
            }
            case IN_BACKGROUND_ASYNC: {
                task = new Task.Backgroundable(project, title, true){

                    public void run(@NotNull ProgressIndicator indicator) {
                        if (indicator == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/android/tools/idea/gradle/project/sync/NewGradleSync$2", "run"));
                        }
                        NewGradleSync.this.sync(project, indicator, listener);
                    }
                };
                break;
            }
            default: {
                throw new IllegalArgumentException(executionMode + " is not a supported execution mode");
            }
        }
        UIUtil.invokeAndWaitIfNeeded(() -> ((Task)task).queue());
    }

    private void sync(@NotNull Project project, @NotNull ProgressIndicator indicator, @Nullable GradleSyncListener syncListener) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/sync/NewGradleSync", "sync"));
        }
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/android/tools/idea/gradle/project/sync/NewGradleSync", "sync"));
        }
        Callback callback = this.sync(project);
        callback.doWhenDone(() -> {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/sync/NewGradleSync", "lambda$sync$0"));
            }
            if (indicator == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/android/tools/idea/gradle/project/sync/NewGradleSync", "lambda$sync$0"));
            }
            this.onSyncFinished(project, callback, indicator, syncListener);
        }).doWhenRejected(() -> {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/sync/NewGradleSync", "lambda$sync$1"));
            }
            NewGradleSync.onSyncFailed(project, callback, syncListener);
        });
    }

    @VisibleForTesting
    @NotNull
    Callback sync(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/sync/NewGradleSync", "sync"));
        }
        Callback callback = new Callback();
        if (project.isDisposed()) {
            callback.reject(String.format("Project '%1$s' is already disposed", project.getName()));
        }
        GradleExecutionSettings executionSettings = GradleUtil.getOrCreateGradleExecutionSettings(project, NewGradleSync.useEmbeddedGradle());
        Function syncFunction = connection -> {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/sync/NewGradleSync", "lambda$sync$2"));
            }
            ArrayList modelTypes = Lists.newArrayList((Object[])new Class[]{AndroidProject.class, NativeAndroidProject.class, GradleBuild.class, ModuleExtendedModel.class});
            BuildActionExecuter executor = connection.action((BuildAction)new SyncAction(modelTypes));
            ExternalSystemTaskNotificationListenerAdapter listener = new ExternalSystemTaskNotificationListenerAdapter(){};
            List<String> commandLineArgs = this.myCommandLineArgs.get(project);
            ExternalSystemTaskId id = NewGradleSync.createId(project);
            GradleExecutionHelper.prepare((LongRunningOperation)executor, (ExternalSystemTaskId)id, (GradleExecutionSettings)executionSettings, (ExternalSystemTaskNotificationListener)listener, Collections.emptyList(), commandLineArgs, (ProjectConnection)connection);
            CancellationTokenSource cancellationTokenSource = GradleConnector.newCancellationTokenSource();
            executor.withCancellationToken(cancellationTokenSource.token());
            try {
                SyncAction.ProjectModels models = (SyncAction.ProjectModels)executor.run();
                callback.setDone(models);
            }
            catch (RuntimeException e) {
                callback.setRejected(e);
            }
            return null;
        };
        this.myHelper.execute(Projects.getBaseDirPath(project).getPath(), executionSettings, syncFunction);
        Callback callback2 = callback;
        if (callback2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/sync/NewGradleSync", "sync"));
        }
        return callback2;
    }

    @NotNull
    private static ExternalSystemTaskId createId(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/sync/NewGradleSync", "createId"));
        }
        ExternalSystemTaskId externalSystemTaskId = ExternalSystemTaskId.create((ProjectSystemId)GradleUtil.GRADLE_SYSTEM_ID, (ExternalSystemTaskType)ExternalSystemTaskType.RESOLVE_PROJECT, (Project)project);
        if (externalSystemTaskId == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/sync/NewGradleSync", "createId"));
        }
        return externalSystemTaskId;
    }

    private static boolean useEmbeddedGradle() {
        return false;
    }

    private void onSyncFinished(@NotNull Project project, @NotNull Callback callback, @NotNull ProgressIndicator indicator, @Nullable GradleSyncListener syncListener) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/sync/NewGradleSync", "onSyncFinished"));
        }
        if (callback == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "com/android/tools/idea/gradle/project/sync/NewGradleSync", "onSyncFinished"));
        }
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/android/tools/idea/gradle/project/sync/NewGradleSync", "onSyncFinished"));
        }
        SyncAction.ProjectModels models = callback.getModels();
        if (models != null) {
            try {
                ProjectSetup projectSetup = this.myProjectSetupFactory.create(project);
                projectSetup.setUpProject(models, indicator);
                projectSetup.commit(true);
                if (syncListener != null) {
                    syncListener.syncSucceeded(project);
                }
                GradleSyncState.getInstance(project).syncEnded();
            }
            catch (Throwable e) {
                NewGradleSync.notifyAndLogSyncError(project, NewGradleSync.nullToUnknownErrorCause(NewGradleSync.getRootCauseMessage(e)), syncListener);
            }
        } else {
            NewGradleSync.notifyAndLogSyncError(project, "Gradle did not return any project models", syncListener);
        }
    }

    private static void notifyAndLogSyncError(@NotNull Project project, @NotNull String errorMessage, @Nullable GradleSyncListener syncListener) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/sync/NewGradleSync", "notifyAndLogSyncError"));
        }
        if (errorMessage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorMessage", "com/android/tools/idea/gradle/project/sync/NewGradleSync", "notifyAndLogSyncError"));
        }
        if (syncListener != null) {
            syncListener.syncFailed(project, errorMessage);
        }
        NewGradleSync.logSyncFailure(errorMessage);
    }

    private static void onSyncFailed(@NotNull Project project, @NotNull Callback callback, @Nullable GradleSyncListener syncListener) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/sync/NewGradleSync", "onSyncFailed"));
        }
        if (callback == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "com/android/tools/idea/gradle/project/sync/NewGradleSync", "onSyncFailed"));
        }
        Throwable error = callback.getSyncError();
        String errorMessage = error != null ? NewGradleSync.getRootCauseMessage(error) : callback.getError();
        errorMessage = NewGradleSync.nullToUnknownErrorCause(errorMessage);
        if (syncListener != null) {
            syncListener.syncFailed(project, errorMessage);
        }
        GradleSyncState.getInstance(project).syncFailed(errorMessage);
        if (error != null) {
            NewGradleSync.getLog().warn("Gradle sync failed", error);
        } else {
            NewGradleSync.logSyncFailure(errorMessage);
        }
    }

    @NotNull
    private static Logger getLog() {
        Logger logger = Logger.getInstance(NewGradleSync.class);
        if (logger == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/sync/NewGradleSync", "getLog"));
        }
        return logger;
    }

    @Nullable
    private static String getRootCauseMessage(@NotNull Throwable error) {
        if (error == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "error", "com/android/tools/idea/gradle/project/sync/NewGradleSync", "getRootCauseMessage"));
        }
        Throwable rootCause = ExceptionUtil.getRootCause((Throwable)error);
        String message = rootCause.getMessage();
        return StringUtil.isEmpty((String)message) ? rootCause.getClass().getName() : message;
    }

    @NotNull
    private static String nullToUnknownErrorCause(@Nullable String errorMessage) {
        String string = StringUtil.isEmpty((String)errorMessage) ? "<Unknown cause>" : errorMessage;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/sync/NewGradleSync", "nullToUnknownErrorCause"));
        }
        return string;
    }

    private static void logSyncFailure(@NotNull String errorMessage) {
        if (errorMessage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorMessage", "com/android/tools/idea/gradle/project/sync/NewGradleSync", "logSyncFailure"));
        }
        NewGradleSync.getLog().warn("Gradle sync failed: " + errorMessage);
    }

    @VisibleForTesting
    static class Callback
    extends ActionCallback {
        @Nullable
        private SyncAction.ProjectModels myModels;
        @Nullable
        private Throwable mySyncError;

        Callback() {
        }

        @Nullable
        SyncAction.ProjectModels getModels() {
            return this.myModels;
        }

        void setDone(@Nullable SyncAction.ProjectModels models) {
            this.myModels = models;
            this.setDone();
        }

        @Nullable
        Throwable getSyncError() {
            return this.mySyncError;
        }

        void setRejected(@NotNull Throwable error) {
            if (error == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "error", "com/android/tools/idea/gradle/project/sync/NewGradleSync$Callback", "setRejected"));
            }
            this.mySyncError = error;
            this.setRejected();
        }
    }
}

