/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync;

import com.android.tools.idea.IdeInfo;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.project.sync.GradleSyncState;
import com.android.tools.idea.gradle.project.sync.ModuleFactory;
import com.android.tools.idea.gradle.project.sync.SyncAction;
import com.android.tools.idea.gradle.project.sync.setup.Facets;
import com.android.tools.idea.gradle.project.sync.setup.module.ModuleDisposer;
import com.android.tools.idea.gradle.project.sync.setup.module.ModuleSetup;
import com.android.tools.idea.gradle.project.sync.validation.android.AndroidModuleValidator;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProviderImpl;
import com.intellij.openapi.externalSystem.util.DisposeAwareProjectChange;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import java.util.ArrayList;
import org.gradle.tooling.model.idea.IdeaModule;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class ProjectSetup {
    ProjectSetup() {
    }

    abstract void setUpProject(@NotNull SyncAction.ProjectModels var1, @NotNull ProgressIndicator var2);

    abstract void commit(boolean var1);

    @VisibleForTesting
    static class ProjectSetupImpl
    extends ProjectSetup {
        private static Key<SyncAction.ModuleModels> MODULE_GRADLE_MODELS_KEY = Key.create((String)"module.gradle.models");
        @NotNull
        private final Project myProject;
        @NotNull
        private final IdeModifiableModelsProvider myModelsProvider;
        @NotNull
        private final IdeInfo myIdeInfo;
        @NotNull
        private final GradleSyncState mySyncState;
        @NotNull
        private final ModuleFactory myModuleFactory;
        @NotNull
        private final ModuleSetup myModuleSetup;
        @NotNull
        private final AndroidModuleValidator.Factory myModuleValidatorFactory;
        @NotNull
        private final ModuleDisposer myModuleDisposer;

        ProjectSetupImpl(@NotNull Project project, @NotNull IdeModifiableModelsProvider modelsProvider) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/sync/ProjectSetup$ProjectSetupImpl", "<init>"));
            }
            if (modelsProvider == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modelsProvider", "com/android/tools/idea/gradle/project/sync/ProjectSetup$ProjectSetupImpl", "<init>"));
            }
            this(project, modelsProvider, IdeInfo.getInstance(), GradleSyncState.getInstance(project), new ModuleFactory(project, modelsProvider), new ModuleSetup(modelsProvider), new AndroidModuleValidator.Factory(), new ModuleDisposer());
        }

        @VisibleForTesting
        ProjectSetupImpl(@NotNull Project project, @NotNull IdeModifiableModelsProvider modelsProvider, @NotNull IdeInfo ideInfo, @NotNull GradleSyncState syncState, @NotNull ModuleFactory moduleFactory, @NotNull ModuleSetup moduleSetup, @NotNull AndroidModuleValidator.Factory moduleValidatorFactory, @NotNull ModuleDisposer moduleDisposer) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/sync/ProjectSetup$ProjectSetupImpl", "<init>"));
            }
            if (modelsProvider == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modelsProvider", "com/android/tools/idea/gradle/project/sync/ProjectSetup$ProjectSetupImpl", "<init>"));
            }
            if (ideInfo == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ideInfo", "com/android/tools/idea/gradle/project/sync/ProjectSetup$ProjectSetupImpl", "<init>"));
            }
            if (syncState == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "syncState", "com/android/tools/idea/gradle/project/sync/ProjectSetup$ProjectSetupImpl", "<init>"));
            }
            if (moduleFactory == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleFactory", "com/android/tools/idea/gradle/project/sync/ProjectSetup$ProjectSetupImpl", "<init>"));
            }
            if (moduleSetup == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleSetup", "com/android/tools/idea/gradle/project/sync/ProjectSetup$ProjectSetupImpl", "<init>"));
            }
            if (moduleValidatorFactory == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleValidatorFactory", "com/android/tools/idea/gradle/project/sync/ProjectSetup$ProjectSetupImpl", "<init>"));
            }
            if (moduleDisposer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleDisposer", "com/android/tools/idea/gradle/project/sync/ProjectSetup$ProjectSetupImpl", "<init>"));
            }
            this.myProject = project;
            this.myModelsProvider = modelsProvider;
            this.myIdeInfo = ideInfo;
            this.mySyncState = syncState;
            this.myModuleFactory = moduleFactory;
            this.myModuleSetup = moduleSetup;
            this.myModuleValidatorFactory = moduleValidatorFactory;
            this.myModuleDisposer = moduleDisposer;
        }

        @Override
        void setUpProject(@NotNull SyncAction.ProjectModels models, @NotNull ProgressIndicator indicator) {
            if (models == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "models", "com/android/tools/idea/gradle/project/sync/ProjectSetup$ProjectSetupImpl", "setUpProject"));
            }
            if (indicator == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/android/tools/idea/gradle/project/sync/ProjectSetup$ProjectSetupImpl", "setUpProject"));
            }
            this.createModules(models, indicator);
            this.setUpModules(indicator);
        }

        private void createModules(@NotNull SyncAction.ProjectModels projectModels, @NotNull ProgressIndicator indicator) {
            if (projectModels == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectModels", "com/android/tools/idea/gradle/project/sync/ProjectSetup$ProjectSetupImpl", "createModules"));
            }
            if (indicator == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/android/tools/idea/gradle/project/sync/ProjectSetup$ProjectSetupImpl", "createModules"));
            }
            indicator.setText2("Creating modules");
            for (IdeaModule ideaModule : projectModels.getProject().getModules()) {
                SyncAction.ModuleModels moduleModels = projectModels.getModels(ideaModule);
                Module module = this.myModuleFactory.createModule(ideaModule, moduleModels);
                module.putUserData(MODULE_GRADLE_MODELS_KEY, (Object)moduleModels);
            }
        }

        private void setUpModules(@NotNull ProgressIndicator indicator) {
            if (indicator == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/android/tools/idea/gradle/project/sync/ProjectSetup$ProjectSetupImpl", "setUpModules"));
            }
            ArrayList<Module> modulesToDispose = new ArrayList<Module>();
            AndroidModuleValidator moduleValidator = this.myModuleValidatorFactory.create(this.myProject);
            for (Module module : this.myModelsProvider.getModules()) {
                SyncAction.ModuleModels moduleModels = (SyncAction.ModuleModels)module.getUserData(MODULE_GRADLE_MODELS_KEY);
                if (moduleModels == null) {
                    if (!this.myIdeInfo.isAndroidStudio() && !this.mySyncState.lastSyncFailedOrHasIssues()) continue;
                    modulesToDispose.add(module);
                    continue;
                }
                this.myModuleSetup.setUpModule(module, moduleModels, indicator);
                AndroidModuleModel androidModel = this.findAndroidModel(module);
                if (androidModel != null) {
                    moduleValidator.validate(module, androidModel);
                }
                module.putUserData(MODULE_GRADLE_MODELS_KEY, null);
            }
            moduleValidator.fixAndReportFoundIssues();
            this.myModuleDisposer.disposeModulesAndMarkImlFilesForDeletion(modulesToDispose, this.myProject, this.myModelsProvider);
        }

        @Nullable
        private AndroidModuleModel findAndroidModel(@NotNull Module module) {
            if (module == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/project/sync/ProjectSetup$ProjectSetupImpl", "findAndroidModel"));
            }
            AndroidFacet facet = Facets.findFacet(module, this.myModelsProvider, AndroidFacet.ID);
            return facet != null ? AndroidModuleModel.get(facet) : null;
        }

        @Override
        public void commit(boolean synchronous) {
            try {
                ExternalSystemApiUtil.executeProjectChangeAction((boolean)synchronous, (DisposeAwareProjectChange)new DisposeAwareProjectChange((ComponentManager)this.myProject){

                    public void execute() {
                        myModelsProvider.commit();
                    }
                });
            }
            catch (Throwable e) {
                ExternalSystemApiUtil.executeProjectChangeAction((boolean)synchronous, (DisposeAwareProjectChange)new DisposeAwareProjectChange((ComponentManager)this.myProject){

                    public void execute() {
                        myModelsProvider.dispose();
                    }
                });
            }
        }
    }

    static class Factory {
        Factory() {
        }

        @NotNull
        ProjectSetup create(@NotNull Project project) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/sync/ProjectSetup$Factory", "create"));
            }
            ProjectSetupImpl projectSetupImpl = new ProjectSetupImpl(project, (IdeModifiableModelsProvider)new IdeModifiableModelsProviderImpl(project));
            if (projectSetupImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/sync/ProjectSetup$Factory", "create"));
            }
            return projectSetupImpl;
        }
    }
}

