/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.errors;

import com.android.repository.api.ProgressIndicator;
import com.android.sdklib.AndroidTargetHash;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.sdklib.repository.meta.DetailsTypes;
import com.android.tools.idea.gradle.project.sync.errors.SyncErrorHandler;
import com.android.tools.idea.gradle.project.sync.hyperlink.InstallPlatformHyperlink;
import com.android.tools.idea.gradle.project.sync.hyperlink.NotificationHyperlink;
import com.android.tools.idea.gradle.project.sync.hyperlink.OpenAndroidSdkManagerHyperlink;
import com.android.tools.idea.gradle.project.sync.messages.SyncMessages;
import com.android.tools.idea.sdk.AndroidSdks;
import com.android.tools.idea.sdk.progress.StudioLoggerProgressIndicator;
import com.google.common.annotations.VisibleForTesting;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.intellij.facet.ProjectFacetManager;
import com.intellij.openapi.externalSystem.model.ExternalSystemException;
import com.intellij.openapi.externalSystem.service.notification.NotificationData;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.sdk.AndroidSdkData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MissingPlatformErrorHandler
extends SyncErrorHandler {
    private static final Pattern[] MISSING_PLATFORM_PATTERNS = new Pattern[]{Pattern.compile("(Cause: )?(F|f)ailed to find target with hash string '(.*)' in: (.*)"), Pattern.compile("(Cause: )?(F|f)ailed to find target (.*) : (.*)"), Pattern.compile("(Cause: )?(F|f)ailed to find target (.*)")};

    @Override
    public boolean handleError(@NotNull ExternalSystemException error, @NotNull NotificationData notification, @NotNull Project project) {
        if (error == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "error", "com/android/tools/idea/gradle/project/sync/errors/MissingPlatformErrorHandler", "handleError"));
        }
        if (notification == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notification", "com/android/tools/idea/gradle/project/sync/errors/MissingPlatformErrorHandler", "handleError"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/sync/errors/MissingPlatformErrorHandler", "handleError"));
        }
        String text = this.findErrorMessage(this.getRootCause((Throwable)error));
        if (text != null) {
            this.findAndAddQuickFixes(notification, project, text);
            return true;
        }
        return false;
    }

    @Nullable
    private String findErrorMessage(@NotNull Throwable rootCause) {
        if (rootCause == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootCause", "com/android/tools/idea/gradle/project/sync/errors/MissingPlatformErrorHandler", "findErrorMessage"));
        }
        String text = rootCause.getMessage();
        if ((rootCause instanceof IllegalStateException || rootCause instanceof ExternalSystemException) && StringUtil.isNotEmpty((String)text) && this.getMissingPlatform(text) != null) {
            MissingPlatformErrorHandler.updateUsageTracker(AndroidStudioEvent.GradleSyncFailure.MISSING_ANDROID_PLATFORM);
            return text;
        }
        return null;
    }

    @VisibleForTesting
    @Nullable
    String getMissingPlatform(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/android/tools/idea/gradle/project/sync/errors/MissingPlatformErrorHandler", "getMissingPlatform"));
        }
        String firstLine = MissingPlatformErrorHandler.getFirstLineMessage(text);
        for (Pattern pattern : MISSING_PLATFORM_PATTERNS) {
            Matcher matcher = pattern.matcher(firstLine);
            if (!matcher.matches()) continue;
            return matcher.group(3);
        }
        return null;
    }

    private void findAndAddQuickFixes(@NotNull NotificationData notification, @NotNull Project project, @NotNull String text) {
        List facets;
        AndroidVersion version;
        if (notification == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notification", "com/android/tools/idea/gradle/project/sync/errors/MissingPlatformErrorHandler", "findAndAddQuickFixes"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/sync/errors/MissingPlatformErrorHandler", "findAndAddQuickFixes"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/android/tools/idea/gradle/project/sync/errors/MissingPlatformErrorHandler", "findAndAddQuickFixes"));
        }
        String missingPlatform = this.getMissingPlatform(text);
        if (missingPlatform == null) {
            return;
        }
        String loadError = null;
        ArrayList<NotificationHyperlink> hyperlinks = new ArrayList<NotificationHyperlink>();
        AndroidSdkHandler sdkHandler = null;
        AndroidSdkData androidSdkData = AndroidSdks.getInstance().tryToChooseAndroidSdk();
        if (androidSdkData != null) {
            sdkHandler = androidSdkData.getSdkHandler();
        }
        if (sdkHandler != null && (version = AndroidTargetHash.getPlatformVersion((String)missingPlatform)) != null) {
            StudioLoggerProgressIndicator logger = new StudioLoggerProgressIndicator(this.getClass());
            loadError = sdkHandler.getAndroidTargetManager((ProgressIndicator)logger).getErrorForPackage(DetailsTypes.getPlatformPath((AndroidVersion)version));
            hyperlinks.add(new InstallPlatformHyperlink(version));
        }
        if (hyperlinks.isEmpty() && !(facets = ProjectFacetManager.getInstance((Project)project).getFacets(AndroidFacet.ID)).isEmpty()) {
            hyperlinks.add(new OpenAndroidSdkManagerHyperlink());
        }
        if (StringUtil.isNotEmpty(loadError)) {
            text = text + "\nPossible cause: " + loadError;
        }
        SyncMessages.getInstance(project).updateNotification(notification, text, hyperlinks);
    }
}

