/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.errors;

import com.android.tools.idea.gradle.plugin.AndroidPluginInfo;
import com.android.tools.idea.gradle.project.sync.errors.BaseSyncErrorHandler;
import com.android.tools.idea.gradle.project.sync.hyperlink.FixAndroidGradlePluginVersionHyperlink;
import com.android.tools.idea.gradle.project.sync.hyperlink.NotificationHyperlink;
import com.android.tools.idea.gradle.project.sync.hyperlink.OpenFileHyperlink;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.intellij.openapi.externalSystem.service.notification.NotificationData;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public class OldAndroidPluginErrorHandler
extends BaseSyncErrorHandler {
    private static final Pattern PATTERN = Pattern.compile("The android gradle plugin version .+ is too old, please update to the latest version.");

    @Override
    protected String findErrorMessage(@NotNull Throwable rootCause, @NotNull NotificationData notification, @NotNull Project project) {
        if (rootCause == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootCause", "com/android/tools/idea/gradle/project/sync/errors/OldAndroidPluginErrorHandler", "findErrorMessage"));
        }
        if (notification == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notification", "com/android/tools/idea/gradle/project/sync/errors/OldAndroidPluginErrorHandler", "findErrorMessage"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/sync/errors/OldAndroidPluginErrorHandler", "findErrorMessage"));
        }
        String text = rootCause.getMessage();
        if (OldAndroidPluginErrorHandler.isMatching(text)) {
            OldAndroidPluginErrorHandler.updateUsageTracker();
            return Joiner.on((char)'\n').join((Iterable)Splitter.on((char)'\n').omitEmptyStrings().trimResults().splitToList((CharSequence)text));
        }
        return null;
    }

    @VisibleForTesting
    static boolean isMatching(String text) {
        if (StringUtil.isNotEmpty((String)text)) {
            String firstLine = OldAndroidPluginErrorHandler.getFirstLineMessage(text);
            if (firstLine.startsWith("Plugin is too old, please update to a more recent version")) {
                return true;
            }
            return PATTERN.matcher(firstLine).matches();
        }
        return false;
    }

    @Override
    @NotNull
    protected List<NotificationHyperlink> getQuickFixHyperlinks(@NotNull NotificationData notification, @NotNull Project project, @NotNull String text) {
        if (notification == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notification", "com/android/tools/idea/gradle/project/sync/errors/OldAndroidPluginErrorHandler", "getQuickFixHyperlinks"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/sync/errors/OldAndroidPluginErrorHandler", "getQuickFixHyperlinks"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/android/tools/idea/gradle/project/sync/errors/OldAndroidPluginErrorHandler", "getQuickFixHyperlinks"));
        }
        ArrayList<NotificationHyperlink> hyperlinks = new ArrayList<NotificationHyperlink>();
        hyperlinks.add(new FixAndroidGradlePluginVersionHyperlink());
        AndroidPluginInfo result = AndroidPluginInfo.searchInBuildFilesOnly(project);
        if (result != null && result.getPluginBuildFile() != null) {
            hyperlinks.add(new OpenFileHyperlink(result.getPluginBuildFile().getPath()));
        }
        ArrayList<NotificationHyperlink> arrayList = hyperlinks;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/sync/errors/OldAndroidPluginErrorHandler", "getQuickFixHyperlinks"));
        }
        return arrayList;
    }
}

