/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.errors;

import com.android.repository.Revision;
import com.android.repository.api.LocalPackage;
import com.android.repository.api.ProgressIndicator;
import com.android.repository.impl.meta.RepositoryPackages;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.sdklib.repository.meta.DetailsTypes;
import com.android.tools.idea.gradle.plugin.AndroidPluginInfo;
import com.android.tools.idea.gradle.project.sync.errors.SyncErrorHandler;
import com.android.tools.idea.gradle.project.sync.hyperlink.FixBuildToolsVersionHyperlink;
import com.android.tools.idea.gradle.project.sync.hyperlink.InstallBuildToolsHyperlink;
import com.android.tools.idea.gradle.project.sync.hyperlink.NotificationHyperlink;
import com.android.tools.idea.gradle.project.sync.hyperlink.OpenFileHyperlink;
import com.android.tools.idea.gradle.project.sync.messages.SyncMessages;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.sdk.AndroidSdks;
import com.android.tools.idea.sdk.progress.StudioLoggerProgressIndicator;
import com.intellij.openapi.externalSystem.model.ExternalSystemException;
import com.intellij.openapi.externalSystem.service.notification.NotificationData;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.android.sdk.AndroidSdkData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SdkBuildToolsTooLowErrorHandler
extends SyncErrorHandler {
    private static final Pattern SDK_BUILD_TOOLS_TOO_LOW_PATTERN = Pattern.compile("The SDK Build Tools revision \\((.*)\\) is too low for project '(.*)'. Minimum required is (.*)");

    @NotNull
    public static SdkBuildToolsTooLowErrorHandler getInstance() {
        for (SyncErrorHandler errorHandler : SyncErrorHandler.getExtensions()) {
            if (!(errorHandler instanceof SdkBuildToolsTooLowErrorHandler)) continue;
            SdkBuildToolsTooLowErrorHandler sdkBuildToolsTooLowErrorHandler = (SdkBuildToolsTooLowErrorHandler)errorHandler;
            if (sdkBuildToolsTooLowErrorHandler == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/sync/errors/SdkBuildToolsTooLowErrorHandler", "getInstance"));
            }
            return sdkBuildToolsTooLowErrorHandler;
        }
        throw new IllegalStateException("Unable to find an instance of " + SdkBuildToolsTooLowErrorHandler.class.getName());
    }

    @Override
    public boolean handleError(@NotNull ExternalSystemException error, @NotNull NotificationData notification, @NotNull Project project) {
        if (error == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "error", "com/android/tools/idea/gradle/project/sync/errors/SdkBuildToolsTooLowErrorHandler", "handleError"));
        }
        if (notification == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notification", "com/android/tools/idea/gradle/project/sync/errors/SdkBuildToolsTooLowErrorHandler", "handleError"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/sync/errors/SdkBuildToolsTooLowErrorHandler", "handleError"));
        }
        String text = this.getRootCause((Throwable)error).getMessage();
        List<NotificationHyperlink> hyperlinks = this.getQuickFixHyperlinks(project, text);
        if (!hyperlinks.isEmpty()) {
            SdkBuildToolsTooLowErrorHandler.updateUsageTracker();
            SyncMessages.getInstance(project).updateNotification(notification, text, hyperlinks);
            return true;
        }
        return false;
    }

    @NotNull
    private List<NotificationHyperlink> getQuickFixHyperlinks(@NotNull Project project, @NotNull String text) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/sync/errors/SdkBuildToolsTooLowErrorHandler", "getQuickFixHyperlinks"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/android/tools/idea/gradle/project/sync/errors/SdkBuildToolsTooLowErrorHandler", "getQuickFixHyperlinks"));
        }
        Matcher matcher = SDK_BUILD_TOOLS_TOO_LOW_PATTERN.matcher(SdkBuildToolsTooLowErrorHandler.getFirstLineMessage(text));
        if (matcher.matches()) {
            String gradlePath = matcher.group(2);
            Module module = GradleUtil.findModuleByGradlePath(project, gradlePath);
            String minimumVersion = matcher.group(3);
            List<NotificationHyperlink> list = this.getQuickFixHyperlinks(minimumVersion, project, module);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/sync/errors/SdkBuildToolsTooLowErrorHandler", "getQuickFixHyperlinks"));
            }
            return list;
        }
        List<NotificationHyperlink> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/sync/errors/SdkBuildToolsTooLowErrorHandler", "getQuickFixHyperlinks"));
        }
        return list;
    }

    @NotNull
    public List<NotificationHyperlink> getQuickFixHyperlinks(@NotNull String minimumVersion, @NotNull Project project, @Nullable Module module) {
        if (minimumVersion == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "minimumVersion", "com/android/tools/idea/gradle/project/sync/errors/SdkBuildToolsTooLowErrorHandler", "getQuickFixHyperlinks"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/sync/errors/SdkBuildToolsTooLowErrorHandler", "getQuickFixHyperlinks"));
        }
        ArrayList<NotificationHyperlink> hyperlinks = new ArrayList<NotificationHyperlink>();
        boolean buildToolInstalled = false;
        AndroidSdkHandler sdkHandler = null;
        AndroidSdkData androidSdkData = AndroidSdks.getInstance().tryToChooseAndroidSdk();
        if (androidSdkData != null) {
            sdkHandler = androidSdkData.getSdkHandler();
        }
        if (sdkHandler != null) {
            StudioLoggerProgressIndicator progress = new StudioLoggerProgressIndicator(SdkBuildToolsTooLowErrorHandler.class);
            RepositoryPackages packages = sdkHandler.getSdkManager((ProgressIndicator)progress).getPackages();
            LocalPackage buildTool = (LocalPackage)packages.getLocalPackages().get(DetailsTypes.getBuildToolsPath((Revision)Revision.parseRevision((String)minimumVersion)));
            boolean bl = buildToolInstalled = buildTool != null;
        }
        if (module != null) {
            VirtualFile buildFile = GradleUtil.getGradleBuildFile(module);
            AndroidPluginInfo androidPluginInfo = AndroidPluginInfo.find(project);
            if (!buildToolInstalled) {
                if (androidPluginInfo != null && androidPluginInfo.isExperimental()) {
                    hyperlinks.add(new InstallBuildToolsHyperlink(minimumVersion, null));
                } else {
                    hyperlinks.add(new InstallBuildToolsHyperlink(minimumVersion, buildFile));
                }
            } else if (buildFile != null && androidPluginInfo != null && !androidPluginInfo.isExperimental()) {
                hyperlinks.add(new FixBuildToolsVersionHyperlink(buildFile, minimumVersion));
            }
            if (buildFile != null) {
                hyperlinks.add(new OpenFileHyperlink(buildFile.getPath()));
            }
        }
        ArrayList<NotificationHyperlink> arrayList = hyperlinks;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/sync/errors/SdkBuildToolsTooLowErrorHandler", "getQuickFixHyperlinks"));
        }
        return arrayList;
    }
}

