/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.errors;

import com.android.tools.idea.gradle.project.sync.errors.BaseSyncErrorHandler;
import com.android.tools.idea.gradle.project.sync.hyperlink.CreateGradleWrapperHyperlink;
import com.android.tools.idea.gradle.project.sync.hyperlink.FixGradleVersionInWrapperHyperlink;
import com.android.tools.idea.gradle.project.sync.hyperlink.NotificationHyperlink;
import com.android.tools.idea.gradle.project.sync.hyperlink.OpenGradleSettingsHyperlink;
import com.android.tools.idea.gradle.util.GradleProjectSettingsFinder;
import com.android.tools.idea.gradle.util.GradleWrapper;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.intellij.openapi.externalSystem.service.notification.NotificationData;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gradle.tooling.UnsupportedVersionException;
import org.gradle.tooling.model.UnsupportedMethodException;
import org.gradle.tooling.provider.model.ToolingModelBuilderRegistry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.settings.DistributionType;
import org.jetbrains.plugins.gradle.settings.GradleProjectSettings;

public class UnsupportedGradleVersionErrorHandler
extends BaseSyncErrorHandler {
    private static final Pattern UNSUPPORTED_GRADLE_VERSION_PATTERN_1 = Pattern.compile("Minimum supported Gradle version is (.*)\\. Current version is.*?");
    private static final Pattern UNSUPPORTED_GRADLE_VERSION_PATTERN_2 = Pattern.compile("Gradle version (.*) is required.*?");

    @Override
    @Nullable
    protected String findErrorMessage(@NotNull Throwable rootCause, @NotNull NotificationData notification, @NotNull Project project) {
        String text;
        if (rootCause == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootCause", "com/android/tools/idea/gradle/project/sync/errors/UnsupportedGradleVersionErrorHandler", "findErrorMessage"));
        }
        if (notification == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notification", "com/android/tools/idea/gradle/project/sync/errors/UnsupportedGradleVersionErrorHandler", "findErrorMessage"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/sync/errors/UnsupportedGradleVersionErrorHandler", "findErrorMessage"));
        }
        String newMsg = "";
        if (UnsupportedGradleVersionErrorHandler.isOldGradleVersion(rootCause)) {
            newMsg = "The project is using an unsupported version of Gradle.\nPlease point to a supported Gradle version in the project's Gradle settings or in the project's Gradle wrapper (if applicable.)";
        }
        if ((text = rootCause.getMessage()) != null && (UNSUPPORTED_GRADLE_VERSION_PATTERN_1.matcher(text).matches() || UNSUPPORTED_GRADLE_VERSION_PATTERN_2.matcher(text).matches())) {
            int i = text.indexOf("If using the gradle wrapper");
            if (i != -1) {
                text = text.substring(0, i);
                text = text.trim();
            }
            if (!text.endsWith(".")) {
                text = text + ".";
            }
            newMsg = text + "\n\n" + "Please fix the project's Gradle settings.";
        }
        if (StringUtil.isNotEmpty((String)newMsg)) {
            UnsupportedGradleVersionErrorHandler.updateUsageTracker(AndroidStudioEvent.GradleSyncFailure.UNSUPPORTED_GRADLE_VERSION);
            return newMsg;
        }
        return null;
    }

    private static boolean isOldGradleVersion(@NotNull Throwable error) {
        if (error == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "error", "com/android/tools/idea/gradle/project/sync/errors/UnsupportedGradleVersionErrorHandler", "isOldGradleVersion"));
        }
        String msg = error.getMessage();
        if (error instanceof UnsupportedVersionException) {
            return true;
        }
        if (error instanceof UnsupportedMethodException && msg != null && msg.contains("GradleProject.getBuildScript")) {
            return true;
        }
        return error instanceof ClassNotFoundException && msg != null && msg.contains(ToolingModelBuilderRegistry.class.getName());
    }

    @Override
    @NotNull
    protected List<NotificationHyperlink> getQuickFixHyperlinks(@NotNull NotificationData notification, @NotNull Project project, @NotNull String text) {
        if (notification == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notification", "com/android/tools/idea/gradle/project/sync/errors/UnsupportedGradleVersionErrorHandler", "getQuickFixHyperlinks"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/sync/errors/UnsupportedGradleVersionErrorHandler", "getQuickFixHyperlinks"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/android/tools/idea/gradle/project/sync/errors/UnsupportedGradleVersionErrorHandler", "getQuickFixHyperlinks"));
        }
        String gradleVersion = UnsupportedGradleVersionErrorHandler.getSupportedGradleVersion(UnsupportedGradleVersionErrorHandler.getFirstLineMessage(text));
        List<NotificationHyperlink> list = UnsupportedGradleVersionErrorHandler.getQuickFixHyperlinks(project, gradleVersion);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/sync/errors/UnsupportedGradleVersionErrorHandler", "getQuickFixHyperlinks"));
        }
        return list;
    }

    @Nullable
    private static String getSupportedGradleVersion(@NotNull String message) {
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/android/tools/idea/gradle/project/sync/errors/UnsupportedGradleVersionErrorHandler", "getSupportedGradleVersion"));
        }
        return UnsupportedGradleVersionErrorHandler.getSupportedGradleVersion(message, UNSUPPORTED_GRADLE_VERSION_PATTERN_1, UNSUPPORTED_GRADLE_VERSION_PATTERN_2);
    }

    @Nullable
    private static String getSupportedGradleVersion(@NotNull String message, Pattern ... patterns) {
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/android/tools/idea/gradle/project/sync/errors/UnsupportedGradleVersionErrorHandler", "getSupportedGradleVersion"));
        }
        if (patterns == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "patterns", "com/android/tools/idea/gradle/project/sync/errors/UnsupportedGradleVersionErrorHandler", "getSupportedGradleVersion"));
        }
        for (Pattern pattern : patterns) {
            String version;
            Matcher matcher = pattern.matcher(message);
            if (!matcher.matches() || !StringUtil.isNotEmpty((String)(version = matcher.group(1)))) continue;
            return version;
        }
        return null;
    }

    @NotNull
    public static List<NotificationHyperlink> getQuickFixHyperlinks(@NotNull Project project, @Nullable String gradleVersion) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/sync/errors/UnsupportedGradleVersionErrorHandler", "getQuickFixHyperlinks"));
        }
        ArrayList<NotificationHyperlink> hyperlinks = new ArrayList<NotificationHyperlink>();
        GradleWrapper gradleWrapper = GradleWrapper.find(project);
        if (gradleWrapper != null) {
            NotificationHyperlink hyperlink = FixGradleVersionInWrapperHyperlink.createIfProjectUsesGradleWrapper(project, gradleVersion);
            if (hyperlink != null) {
                hyperlinks.add(hyperlink);
            }
        } else {
            GradleProjectSettings gradleProjectSettings = GradleProjectSettingsFinder.getInstance().findGradleProjectSettings(project);
            if (gradleProjectSettings != null && gradleProjectSettings.getDistributionType() == DistributionType.LOCAL) {
                hyperlinks.add(new CreateGradleWrapperHyperlink());
            }
        }
        hyperlinks.add(new OpenGradleSettingsHyperlink());
        ArrayList<NotificationHyperlink> arrayList = hyperlinks;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/sync/errors/UnsupportedGradleVersionErrorHandler", "getQuickFixHyperlinks"));
        }
        return arrayList;
    }
}

