/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.hyperlink;

import com.android.tools.idea.gradle.project.sync.GradleSyncInvoker;
import com.android.tools.idea.gradle.project.sync.hyperlink.NotificationHyperlink;
import com.android.tools.idea.gradle.util.GradleProjectSettingsFinder;
import com.android.tools.idea.gradle.util.GradleWrapper;
import com.android.tools.idea.gradle.util.Projects;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import java.io.File;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.settings.DistributionType;
import org.jetbrains.plugins.gradle.settings.GradleProjectSettings;

public class CreateGradleWrapperHyperlink
extends NotificationHyperlink {
    public CreateGradleWrapperHyperlink() {
        super("createGradleWrapper", "Migrate to Gradle wrapper and sync project");
    }

    @Override
    protected void execute(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/sync/hyperlink/CreateGradleWrapperHyperlink", "execute"));
        }
        File projectDirPath = Projects.getBaseDirPath(project);
        try {
            GradleWrapper.create(projectDirPath);
            GradleProjectSettings settings = GradleProjectSettingsFinder.getInstance().findGradleProjectSettings(project);
            if (settings != null) {
                settings.setDistributionType(DistributionType.DEFAULT_WRAPPED);
            }
            CreateGradleWrapperHyperlink.requestSync(project);
        }
        catch (IOException e) {
            Messages.showErrorDialog((Project)project, (String)("Failed to create Gradle wrapper: " + e.getMessage()), (String)"Quick Fix");
        }
    }

    private static void requestSync(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/sync/hyperlink/CreateGradleWrapperHyperlink", "requestSync"));
        }
        GradleSyncInvoker.getInstance().requestProjectSyncAndSourceGeneration(project, null);
    }
}

