/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.hyperlink;

import com.android.tools.idea.gradle.project.sync.GradleSyncInvoker;
import com.android.tools.idea.gradle.project.sync.hyperlink.NotificationHyperlink;
import com.android.tools.idea.gradle.util.GradleProjectSettingsFinder;
import com.android.tools.idea.gradle.util.GradleWrapper;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.externalSystem.service.notification.EditableNotificationMessageElement;
import com.intellij.openapi.project.Project;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.settings.DistributionType;
import org.jetbrains.plugins.gradle.settings.GradleProjectSettings;

public class FixGradleVersionInWrapperHyperlink
extends NotificationHyperlink {
    @NotNull
    private final GradleWrapper myGradleWrapper;
    @NotNull
    private final String myGradleVersion;

    @Nullable
    public static NotificationHyperlink createIfProjectUsesGradleWrapper(@NotNull Project project, @Nullable String gradleVersion) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/sync/hyperlink/FixGradleVersionInWrapperHyperlink", "createIfProjectUsesGradleWrapper"));
        }
        GradleWrapper gradleWrapper = GradleWrapper.find(project);
        if (gradleWrapper != null) {
            String version = gradleVersion != null ? gradleVersion : "3.3";
            return new FixGradleVersionInWrapperHyperlink(gradleWrapper, version);
        }
        return null;
    }

    private FixGradleVersionInWrapperHyperlink(@NotNull GradleWrapper gradleWrapper, @NotNull String gradleVersion) {
        if (gradleWrapper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gradleWrapper", "com/android/tools/idea/gradle/project/sync/hyperlink/FixGradleVersionInWrapperHyperlink", "<init>"));
        }
        if (gradleVersion == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gradleVersion", "com/android/tools/idea/gradle/project/sync/hyperlink/FixGradleVersionInWrapperHyperlink", "<init>"));
        }
        super("fixGradleVersionInWrapper", "Fix Gradle wrapper and re-import project");
        this.myGradleWrapper = gradleWrapper;
        this.myGradleVersion = gradleVersion;
    }

    @Override
    protected void execute(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/sync/hyperlink/FixGradleVersionInWrapperHyperlink", "execute"));
        }
        this.myGradleWrapper.updateDistributionUrlAndDisplayFailure(this.myGradleVersion);
        FixGradleVersionInWrapperHyperlink.setDistributionTypeAndSync(project);
    }

    @Override
    public boolean executeIfClicked(@NotNull Project project, @NotNull HyperlinkEvent event) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/sync/hyperlink/FixGradleVersionInWrapperHyperlink", "executeIfClicked"));
        }
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/android/tools/idea/gradle/project/sync/hyperlink/FixGradleVersionInWrapperHyperlink", "executeIfClicked"));
        }
        boolean updated = this.myGradleWrapper.updateDistributionUrlAndDisplayFailure(this.myGradleVersion);
        if (updated) {
            EditableNotificationMessageElement.disableLink((HyperlinkEvent)event);
            FixGradleVersionInWrapperHyperlink.setDistributionTypeAndSync(project);
        }
        return updated;
    }

    private static void setDistributionTypeAndSync(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/sync/hyperlink/FixGradleVersionInWrapperHyperlink", "setDistributionTypeAndSync"));
        }
        GradleProjectSettings settings = GradleProjectSettingsFinder.getInstance().findGradleProjectSettings(project);
        if (settings != null) {
            settings.setDistributionType(DistributionType.DEFAULT_WRAPPED);
        }
        FixGradleVersionInWrapperHyperlink.requestSync(project);
    }

    private static void requestSync(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/sync/hyperlink/FixGradleVersionInWrapperHyperlink", "requestSync"));
        }
        GradleSyncInvoker.getInstance().requestProjectSyncAndSourceGeneration(project, null);
    }

    @VisibleForTesting
    @NotNull
    public String getGradleVersion() {
        String string = this.myGradleVersion;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/sync/hyperlink/FixGradleVersionInWrapperHyperlink", "getGradleVersion"));
        }
        return string;
    }
}

