/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.idea.data.service;

import com.android.tools.idea.gradle.project.model.JavaModuleModel;
import com.android.tools.idea.gradle.project.sync.idea.data.service.AndroidProjectKeys;
import com.android.tools.idea.gradle.project.sync.idea.data.service.ModuleModelDataService;
import com.android.tools.idea.gradle.project.sync.setup.module.JavaModuleSetup;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import java.util.Collection;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class JavaModuleModelDataService
extends ModuleModelDataService<JavaModuleModel> {
    @NotNull
    private final JavaModuleSetup myModuleSetup;

    public JavaModuleModelDataService() {
        this(new JavaModuleSetup());
    }

    @VisibleForTesting
    JavaModuleModelDataService(@NotNull JavaModuleSetup moduleSetup) {
        if (moduleSetup == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleSetup", "com/android/tools/idea/gradle/project/sync/idea/data/service/JavaModuleModelDataService", "<init>"));
        }
        this.myModuleSetup = moduleSetup;
    }

    @NotNull
    public Key<JavaModuleModel> getTargetDataKey() {
        Key<JavaModuleModel> key = AndroidProjectKeys.JAVA_MODULE_MODEL;
        if (key == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/sync/idea/data/service/JavaModuleModelDataService", "getTargetDataKey"));
        }
        return key;
    }

    @Override
    protected void importData(@NotNull Collection<DataNode<JavaModuleModel>> toImport, @NotNull Project project, @NotNull IdeModifiableModelsProvider modelsProvider, @NotNull Map<String, JavaModuleModel> modelsByName) {
        if (toImport == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toImport", "com/android/tools/idea/gradle/project/sync/idea/data/service/JavaModuleModelDataService", "importData"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/sync/idea/data/service/JavaModuleModelDataService", "importData"));
        }
        if (modelsProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modelsProvider", "com/android/tools/idea/gradle/project/sync/idea/data/service/JavaModuleModelDataService", "importData"));
        }
        if (modelsByName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modelsByName", "com/android/tools/idea/gradle/project/sync/idea/data/service/JavaModuleModelDataService", "importData"));
        }
        for (Module module : modelsProvider.getModules()) {
            JavaModuleModel javaModuleModel = modelsByName.get(module.getName());
            if (javaModuleModel == null) continue;
            this.myModuleSetup.setUpModule(module, modelsProvider, javaModuleModel, null, null);
        }
    }
}

