/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.issues;

import com.android.builder.model.SyncIssue;
import com.android.tools.idea.gradle.project.sync.GradleSyncState;
import com.android.tools.idea.gradle.project.sync.issues.BaseSyncIssuesReporter;
import com.android.tools.idea.gradle.project.sync.issues.BuildToolsTooLowReporter;
import com.android.tools.idea.gradle.project.sync.issues.ExternalNdkBuildIssuesReporter;
import com.android.tools.idea.gradle.project.sync.issues.UnhandledIssuesReporter;
import com.android.tools.idea.gradle.project.sync.issues.UnresolvedDependenciesReporter;
import com.android.tools.idea.gradle.project.sync.issues.UnsupportedGradleReporter;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SyncIssuesReporter {
    @NotNull
    private final Map<Integer, BaseSyncIssuesReporter> myStrategies;
    @NotNull
    private final BaseSyncIssuesReporter myDefaultMessageFactory;

    @NotNull
    public static SyncIssuesReporter getInstance() {
        SyncIssuesReporter syncIssuesReporter = (SyncIssuesReporter)ServiceManager.getService(SyncIssuesReporter.class);
        if (syncIssuesReporter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/sync/issues/SyncIssuesReporter", "getInstance"));
        }
        return syncIssuesReporter;
    }

    public SyncIssuesReporter(@NotNull UnresolvedDependenciesReporter unresolvedDependenciesReporter) {
        if (unresolvedDependenciesReporter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "unresolvedDependenciesReporter", "com/android/tools/idea/gradle/project/sync/issues/SyncIssuesReporter", "<init>"));
        }
        this(unresolvedDependenciesReporter, new ExternalNdkBuildIssuesReporter(), new UnsupportedGradleReporter(), new BuildToolsTooLowReporter());
    }

    @VisibleForTesting
    SyncIssuesReporter(BaseSyncIssuesReporter ... strategies) {
        if (strategies == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "strategies", "com/android/tools/idea/gradle/project/sync/issues/SyncIssuesReporter", "<init>"));
        }
        this.myStrategies = new HashMap<Integer, BaseSyncIssuesReporter>(3);
        for (BaseSyncIssuesReporter strategy : strategies) {
            int issueType = strategy.getSupportedIssueType();
            this.myStrategies.put(issueType, strategy);
        }
        this.myDefaultMessageFactory = new UnhandledIssuesReporter();
    }

    public void report(@NotNull Collection<SyncIssue> syncIssues, @NotNull Module module) {
        if (syncIssues == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "syncIssues", "com/android/tools/idea/gradle/project/sync/issues/SyncIssuesReporter", "report"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/project/sync/issues/SyncIssuesReporter", "report"));
        }
        if (syncIssues.isEmpty()) {
            return;
        }
        boolean hasSyncErrors = false;
        VirtualFile buildFile = GradleUtil.getGradleBuildFile(module);
        for (SyncIssue syncIssue : syncIssues) {
            if (syncIssue.getSeverity() == 2) {
                hasSyncErrors = true;
            }
            this.report(syncIssue, module, buildFile);
        }
        if (hasSyncErrors) {
            Project project = module.getProject();
            GradleSyncState.getInstance(project).getSummary().setSyncErrorsFound(true);
        }
    }

    private void report(@NotNull SyncIssue syncIssue, @NotNull Module module, @Nullable VirtualFile buildFile) {
        if (syncIssue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "syncIssue", "com/android/tools/idea/gradle/project/sync/issues/SyncIssuesReporter", "report"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/project/sync/issues/SyncIssuesReporter", "report"));
        }
        int type = syncIssue.getType();
        BaseSyncIssuesReporter strategy = this.myStrategies.get(type);
        if (strategy == null) {
            strategy = this.myDefaultMessageFactory;
        }
        strategy.report(syncIssue, module, buildFile);
    }

    @VisibleForTesting
    @NotNull
    Map<Integer, BaseSyncIssuesReporter> getStrategies() {
        Map<Integer, BaseSyncIssuesReporter> map = this.myStrategies;
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/sync/issues/SyncIssuesReporter", "getStrategies"));
        }
        return map;
    }

    @VisibleForTesting
    @NotNull
    BaseSyncIssuesReporter getDefaultMessageFactory() {
        BaseSyncIssuesReporter baseSyncIssuesReporter = this.myDefaultMessageFactory;
        if (baseSyncIssuesReporter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/sync/issues/SyncIssuesReporter", "getDefaultMessageFactory"));
        }
        return baseSyncIssuesReporter;
    }
}

