/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.messages;

import com.android.ide.common.blame.Message;
import com.intellij.openapi.externalSystem.service.notification.NotificationCategory;
import javax.annotation.Nullable;
import org.jetbrains.annotations.NotNull;

public enum MessageType {
    SIMPLE(1),
    INFO(3),
    ERROR(4),
    WARNING(5);

    private final int myCategoryCode;

    private MessageType(int categoryCode) {
        this.myCategoryCode = categoryCode;
    }

    @Nullable
    public static MessageType findByName(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/gradle/project/sync/messages/MessageType", "findByName"));
        }
        for (MessageType type : MessageType.values()) {
            if (!type.name().equalsIgnoreCase(name)) continue;
            return type;
        }
        return null;
    }

    @NotNull
    public static MessageType findMatching(@NotNull Message.Kind kind) {
        if (kind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/android/tools/idea/gradle/project/sync/messages/MessageType", "findMatching"));
        }
        String name = kind.name();
        MessageType type = MessageType.findByName(name);
        MessageType messageType = type != null ? type : INFO;
        if (messageType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/sync/messages/MessageType", "findMatching"));
        }
        return messageType;
    }

    @NotNull
    public NotificationCategory convertToCategory() {
        NotificationCategory notificationCategory = NotificationCategory.convert((int)this.myCategoryCode);
        if (notificationCategory == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/sync/messages/MessageType", "convertToCategory"));
        }
        return notificationCategory;
    }
}

