/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.messages;

import com.android.tools.idea.gradle.project.sync.hyperlink.NotificationHyperlink;
import com.android.tools.idea.gradle.project.sync.messages.MessageType;
import com.android.tools.idea.gradle.util.PositionInFile;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.pom.Navigatable;
import com.intellij.pom.NonNavigatable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SyncMessage {
    public static final String DEFAULT_GROUP = "Gradle Sync Issues";
    @NotNull
    private final String myGroup;
    @NotNull
    private final MessageType myType;
    @NotNull
    private final String[] myText;
    @NotNull
    private final Navigatable myNavigatable;
    @Nullable
    private final PositionInFile myPosition;
    @NotNull
    private final List<NotificationHyperlink> myQuickFixes;

    public SyncMessage(@NotNull String group, @NotNull MessageType type, String ... text) {
        if (group == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "group", "com/android/tools/idea/gradle/project/sync/messages/SyncMessage", "<init>"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/android/tools/idea/gradle/project/sync/messages/SyncMessage", "<init>"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/android/tools/idea/gradle/project/sync/messages/SyncMessage", "<init>"));
        }
        this(group, type, NonNavigatable.INSTANCE, text);
    }

    public SyncMessage(@NotNull Project project, @NotNull String group, @NotNull MessageType type, @NotNull PositionInFile position, String ... text) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/sync/messages/SyncMessage", "<init>"));
        }
        if (group == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "group", "com/android/tools/idea/gradle/project/sync/messages/SyncMessage", "<init>"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/android/tools/idea/gradle/project/sync/messages/SyncMessage", "<init>"));
        }
        if (position == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "com/android/tools/idea/gradle/project/sync/messages/SyncMessage", "<init>"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/android/tools/idea/gradle/project/sync/messages/SyncMessage", "<init>"));
        }
        this(group, type, (Navigatable)new OpenFileDescriptor(project, position.file, position.line, position.column), text, position);
    }

    public SyncMessage(@NotNull String group, @NotNull MessageType type, @NotNull Navigatable navigatable, String ... text) {
        if (group == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "group", "com/android/tools/idea/gradle/project/sync/messages/SyncMessage", "<init>"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/android/tools/idea/gradle/project/sync/messages/SyncMessage", "<init>"));
        }
        if (navigatable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "navigatable", "com/android/tools/idea/gradle/project/sync/messages/SyncMessage", "<init>"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/android/tools/idea/gradle/project/sync/messages/SyncMessage", "<init>"));
        }
        this(group, type, navigatable, text, (PositionInFile)null);
    }

    private SyncMessage(@NotNull String group, @NotNull MessageType type, @NotNull Navigatable navigatable, @NotNull String[] text, @Nullable PositionInFile position) {
        if (group == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "group", "com/android/tools/idea/gradle/project/sync/messages/SyncMessage", "<init>"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/android/tools/idea/gradle/project/sync/messages/SyncMessage", "<init>"));
        }
        if (navigatable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "navigatable", "com/android/tools/idea/gradle/project/sync/messages/SyncMessage", "<init>"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/android/tools/idea/gradle/project/sync/messages/SyncMessage", "<init>"));
        }
        this.myQuickFixes = new ArrayList<NotificationHyperlink>();
        this.myGroup = group;
        this.myType = type;
        this.myNavigatable = navigatable;
        this.myText = text;
        this.myPosition = position;
    }

    @NotNull
    public String getGroup() {
        String string = this.myGroup;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/sync/messages/SyncMessage", "getGroup"));
        }
        return string;
    }

    @NotNull
    public MessageType getType() {
        MessageType messageType = this.myType;
        if (messageType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/sync/messages/SyncMessage", "getType"));
        }
        return messageType;
    }

    @NotNull
    public String[] getText() {
        if (this.myText == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/sync/messages/SyncMessage", "getText"));
        }
        return this.myText;
    }

    @NotNull
    public Navigatable getNavigatable() {
        Navigatable navigatable = this.myNavigatable;
        if (navigatable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/sync/messages/SyncMessage", "getNavigatable"));
        }
        return navigatable;
    }

    @Nullable
    public PositionInFile getPosition() {
        return this.myPosition;
    }

    public void add(@NotNull Collection<NotificationHyperlink> quickFixes) {
        if (quickFixes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "quickFixes", "com/android/tools/idea/gradle/project/sync/messages/SyncMessage", "add"));
        }
        this.myQuickFixes.addAll(quickFixes);
    }

    public void add(@NotNull NotificationHyperlink quickFix) {
        if (quickFix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "quickFix", "com/android/tools/idea/gradle/project/sync/messages/SyncMessage", "add"));
        }
        this.myQuickFixes.add(quickFix);
    }

    @NotNull
    public List<NotificationHyperlink> getQuickFixes() {
        ImmutableList immutableList = ImmutableList.copyOf(this.myQuickFixes);
        if (immutableList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/sync/messages/SyncMessage", "getQuickFixes"));
        }
        return immutableList;
    }

    @NotNull
    public String toString() {
        String string = Joiner.on((char)'\n').join((Object[])this.myText);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/sync/messages/SyncMessage", "toString"));
        }
        return string;
    }
}

