/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.setup.module;

import com.android.ide.common.repository.GradleVersion;
import com.android.tools.idea.gradle.project.facet.gradle.GradleFacet;
import com.android.tools.idea.gradle.project.facet.gradle.GradleFacetType;
import com.android.tools.idea.gradle.project.model.GradleModuleModel;
import com.android.tools.idea.gradle.project.sync.GradleSyncState;
import com.android.tools.idea.gradle.project.sync.GradleSyncSummary;
import com.android.tools.idea.gradle.project.sync.SyncAction;
import com.android.tools.idea.gradle.project.sync.setup.Facets;
import com.intellij.facet.Facet;
import com.intellij.facet.ModifiableFacetModel;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import org.gradle.tooling.model.GradleProject;
import org.gradle.tooling.model.gradle.GradleScript;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.model.BuildScriptClasspathModel;

public class GradleModuleSetup {
    public void setUpModule(@NotNull Module module, @NotNull IdeModifiableModelsProvider ideModelsProvider, @NotNull SyncAction.ModuleModels models) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/project/sync/setup/module/GradleModuleSetup", "setUpModule"));
        }
        if (ideModelsProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ideModelsProvider", "com/android/tools/idea/gradle/project/sync/setup/module/GradleModuleSetup", "setUpModule"));
        }
        if (models == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "models", "com/android/tools/idea/gradle/project/sync/setup/module/GradleModuleSetup", "setUpModule"));
        }
        GradleModuleModel gradleModuleModel = GradleModuleSetup.createGradleModel(module, models);
        this.setUpModule(module, ideModelsProvider, gradleModuleModel);
    }

    @NotNull
    private static GradleModuleModel createGradleModel(@NotNull Module module, @NotNull SyncAction.ModuleModels models) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/project/sync/setup/module/GradleModuleSetup", "createGradleModel"));
        }
        if (models == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "models", "com/android/tools/idea/gradle/project/sync/setup/module/GradleModuleSetup", "createGradleModel"));
        }
        GradleProject gradleProject = models.getModule().getGradleProject();
        GradleScript buildScript = null;
        try {
            buildScript = gradleProject.getBuildScript();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        File buildFilePath = buildScript != null ? buildScript.getSourceFile() : null;
        BuildScriptClasspathModel classpathModel = models.findModel(BuildScriptClasspathModel.class);
        String gradleVersion = classpathModel != null ? classpathModel.getGradleVersion() : null;
        GradleModuleModel gradleModuleModel = new GradleModuleModel(module.getName(), gradleProject, buildFilePath, gradleVersion);
        if (gradleModuleModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/sync/setup/module/GradleModuleSetup", "createGradleModel"));
        }
        return gradleModuleModel;
    }

    public void setUpModule(@NotNull Module module, @NotNull IdeModifiableModelsProvider ideModelsProvider, @NotNull GradleModuleModel model) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/project/sync/setup/module/GradleModuleSetup", "setUpModule"));
        }
        if (ideModelsProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ideModelsProvider", "com/android/tools/idea/gradle/project/sync/setup/module/GradleModuleSetup", "setUpModule"));
        }
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/android/tools/idea/gradle/project/sync/setup/module/GradleModuleSetup", "setUpModule"));
        }
        GradleFacet facet = Facets.findFacet(module, ideModelsProvider, GradleFacet.getFacetTypeId());
        if (facet == null) {
            ModifiableFacetModel facetModel = ideModelsProvider.getModifiableFacetModel(module);
            GradleFacetType facetType = GradleFacet.getFacetType();
            facet = facetType.createFacet(module, GradleFacet.getFacetName(), facetType.createDefaultConfiguration(), (Facet)null);
            facetModel.addFacet((Facet)facet);
        }
        facet.setGradleModuleModel(model);
        String gradleVersion = model.getGradleVersion();
        GradleSyncSummary syncReport = GradleSyncState.getInstance(module.getProject()).getSummary();
        if (StringUtil.isNotEmpty((String)gradleVersion) && syncReport.getGradleVersion() == null) {
            syncReport.setGradleVersion(GradleVersion.parse((String)gradleVersion));
        }
    }
}

