/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.setup.module.android;

import com.android.builder.model.SourceProvider;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.project.sync.SyncAction;
import com.android.tools.idea.gradle.project.sync.setup.Facets;
import com.android.tools.idea.gradle.project.sync.setup.module.AndroidModuleSetupStep;
import com.intellij.facet.Facet;
import com.intellij.facet.ModifiableFacetModel;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.Collection;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidFacetType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.android.model.impl.JpsAndroidModuleProperties;

public class AndroidFacetModuleSetupStep
extends AndroidModuleSetupStep {
    private static final String SEPARATOR = "/";

    @Override
    protected void gradleModelNotFound(@NotNull Module module, @NotNull IdeModifiableModelsProvider ideModelsProvider) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/project/sync/setup/module/android/AndroidFacetModuleSetupStep", "gradleModelNotFound"));
        }
        if (ideModelsProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ideModelsProvider", "com/android/tools/idea/gradle/project/sync/setup/module/android/AndroidFacetModuleSetupStep", "gradleModelNotFound"));
        }
        ModifiableFacetModel facetModel = ideModelsProvider.getModifiableFacetModel(module);
        Facets.removeAllFacets(facetModel, AndroidFacet.ID);
    }

    @Override
    protected void doSetUpModule(@NotNull Module module, @NotNull IdeModifiableModelsProvider ideModelsProvider, @NotNull AndroidModuleModel androidModel, @Nullable SyncAction.ModuleModels gradleModels, @Nullable ProgressIndicator indicator) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/project/sync/setup/module/android/AndroidFacetModuleSetupStep", "doSetUpModule"));
        }
        if (ideModelsProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ideModelsProvider", "com/android/tools/idea/gradle/project/sync/setup/module/android/AndroidFacetModuleSetupStep", "doSetUpModule"));
        }
        if (androidModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "androidModel", "com/android/tools/idea/gradle/project/sync/setup/module/android/AndroidFacetModuleSetupStep", "doSetUpModule"));
        }
        AndroidFacet facet = AndroidFacet.getInstance(module, ideModelsProvider);
        if (facet == null) {
            facet = AndroidFacetModuleSetupStep.createAndAddFacet(module, ideModelsProvider);
        }
        AndroidFacetModuleSetupStep.configureFacet(facet, androidModel);
    }

    @Override
    @NotNull
    public String getDescription() {
        if ("Android Facet setup" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/sync/setup/module/android/AndroidFacetModuleSetupStep", "getDescription"));
        }
        return "Android Facet setup";
    }

    @NotNull
    private static AndroidFacet createAndAddFacet(@NotNull Module module, @NotNull IdeModifiableModelsProvider ideModelsProvider) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/project/sync/setup/module/android/AndroidFacetModuleSetupStep", "createAndAddFacet"));
        }
        if (ideModelsProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ideModelsProvider", "com/android/tools/idea/gradle/project/sync/setup/module/android/AndroidFacetModuleSetupStep", "createAndAddFacet"));
        }
        ModifiableFacetModel model = ideModelsProvider.getModifiableFacetModel(module);
        AndroidFacetType facetType = AndroidFacet.getFacetType();
        AndroidFacet facet = facetType.createFacet(module, "Android", facetType.createDefaultConfiguration(), (Facet)null);
        model.addFacet((Facet)facet);
        AndroidFacet androidFacet = facet;
        if (androidFacet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/sync/setup/module/android/AndroidFacetModuleSetupStep", "createAndAddFacet"));
        }
        return androidFacet;
    }

    private static void configureFacet(@NotNull AndroidFacet facet, @NotNull AndroidModuleModel androidModel) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/android/tools/idea/gradle/project/sync/setup/module/android/AndroidFacetModuleSetupStep", "configureFacet"));
        }
        if (androidModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "androidModel", "com/android/tools/idea/gradle/project/sync/setup/module/android/AndroidFacetModuleSetupStep", "configureFacet"));
        }
        JpsAndroidModuleProperties facetProperties = facet.getProperties();
        facetProperties.ALLOW_USER_CONFIGURATION = false;
        facetProperties.PROJECT_TYPE = androidModel.getProjectType();
        File modulePath = androidModel.getRootDirPath();
        SourceProvider sourceProvider = androidModel.getDefaultSourceProvider();
        facetProperties.MANIFEST_FILE_RELATIVE_PATH = AndroidFacetModuleSetupStep.relativePath(modulePath, sourceProvider.getManifestFile());
        facetProperties.RES_FOLDER_RELATIVE_PATH = AndroidFacetModuleSetupStep.relativePath(modulePath, sourceProvider.getResDirectories());
        facetProperties.ASSETS_FOLDER_RELATIVE_PATH = AndroidFacetModuleSetupStep.relativePath(modulePath, sourceProvider.getAssetsDirectories());
        AndroidFacetModuleSetupStep.syncSelectedVariant(facetProperties, androidModel);
        facet.setAndroidModel(androidModel);
        androidModel.syncSelectedVariantAndTestArtifact(facet);
    }

    private static void syncSelectedVariant(@NotNull JpsAndroidModuleProperties facetProperties, @NotNull AndroidModuleModel androidModel) {
        if (facetProperties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facetProperties", "com/android/tools/idea/gradle/project/sync/setup/module/android/AndroidFacetModuleSetupStep", "syncSelectedVariant"));
        }
        if (androidModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "androidModel", "com/android/tools/idea/gradle/project/sync/setup/module/android/AndroidFacetModuleSetupStep", "syncSelectedVariant"));
        }
        String variantStoredInFacet = facetProperties.SELECTED_BUILD_VARIANT;
        if (StringUtil.isNotEmpty((String)variantStoredInFacet) && androidModel.getVariantNames().contains(variantStoredInFacet)) {
            androidModel.setSelectedVariantName(variantStoredInFacet);
        }
    }

    @NotNull
    private static String relativePath(@NotNull File basePath, @NotNull Collection<File> dirs) {
        if (basePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "basePath", "com/android/tools/idea/gradle/project/sync/setup/module/android/AndroidFacetModuleSetupStep", "relativePath"));
        }
        if (dirs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dirs", "com/android/tools/idea/gradle/project/sync/setup/module/android/AndroidFacetModuleSetupStep", "relativePath"));
        }
        String string = AndroidFacetModuleSetupStep.relativePath(basePath, (File)ContainerUtil.getFirstItem(dirs));
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/sync/setup/module/android/AndroidFacetModuleSetupStep", "relativePath"));
        }
        return string;
    }

    @NotNull
    private static String relativePath(@NotNull File basePath, @Nullable File file) {
        if (basePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "basePath", "com/android/tools/idea/gradle/project/sync/setup/module/android/AndroidFacetModuleSetupStep", "relativePath"));
        }
        String relativePath = null;
        if (file != null) {
            relativePath = FileUtilRt.getRelativePath((File)basePath, (File)file);
        }
        if (relativePath != null && !relativePath.startsWith(SEPARATOR)) {
            String string = SEPARATOR + FileUtilRt.toSystemIndependentName((String)relativePath);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/sync/setup/module/android/AndroidFacetModuleSetupStep", "relativePath"));
            }
            return string;
        }
        if ("" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/sync/setup/module/android/AndroidFacetModuleSetupStep", "relativePath"));
        }
        return "";
    }
}

