/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.setup.module.common;

import com.android.tools.idea.gradle.util.FilePaths;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.Library;
import java.io.File;
import org.jetbrains.annotations.NotNull;

public abstract class ModuleDependenciesSetup {
    protected void updateLibraryRootTypePaths(@NotNull Library library, @NotNull OrderRootType pathType, @NotNull IdeModifiableModelsProvider modelsProvider, File ... paths) {
        if (library == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "library", "com/android/tools/idea/gradle/project/sync/setup/module/common/ModuleDependenciesSetup", "updateLibraryRootTypePaths"));
        }
        if (pathType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pathType", "com/android/tools/idea/gradle/project/sync/setup/module/common/ModuleDependenciesSetup", "updateLibraryRootTypePaths"));
        }
        if (modelsProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modelsProvider", "com/android/tools/idea/gradle/project/sync/setup/module/common/ModuleDependenciesSetup", "updateLibraryRootTypePaths"));
        }
        if (paths == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "paths", "com/android/tools/idea/gradle/project/sync/setup/module/common/ModuleDependenciesSetup", "updateLibraryRootTypePaths"));
        }
        if (paths.length == 0) {
            return;
        }
        Library.ModifiableModel libraryModel = modelsProvider.getModifiableLibraryModel(library);
        for (File path : paths) {
            libraryModel.addRoot(FilePaths.pathToIdeaUrl(path), pathType);
        }
    }

    protected void addLibraryAsDependency(@NotNull Library library, @NotNull String libraryName, @NotNull DependencyScope scope, @NotNull Module module, @NotNull IdeModifiableModelsProvider modelsProvider) {
        if (library == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "library", "com/android/tools/idea/gradle/project/sync/setup/module/common/ModuleDependenciesSetup", "addLibraryAsDependency"));
        }
        if (libraryName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "libraryName", "com/android/tools/idea/gradle/project/sync/setup/module/common/ModuleDependenciesSetup", "addLibraryAsDependency"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/android/tools/idea/gradle/project/sync/setup/module/common/ModuleDependenciesSetup", "addLibraryAsDependency"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/project/sync/setup/module/common/ModuleDependenciesSetup", "addLibraryAsDependency"));
        }
        if (modelsProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modelsProvider", "com/android/tools/idea/gradle/project/sync/setup/module/common/ModuleDependenciesSetup", "addLibraryAsDependency"));
        }
        for (OrderEntry orderEntry : modelsProvider.getModifiableRootModel(module).getOrderEntries()) {
            Library entryLibrary;
            if (!(orderEntry instanceof LibraryOrderEntry) || (entryLibrary = ((LibraryOrderEntry)orderEntry).getLibrary()) == null || !libraryName.equals(entryLibrary.getName())) continue;
            return;
        }
        LibraryOrderEntry orderEntry = modelsProvider.getModifiableRootModel(module).addLibraryEntry(library);
        orderEntry.setScope(scope);
        orderEntry.setExported(true);
    }
}

