/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.setup.module.java;

import com.android.tools.idea.gradle.model.java.JavaModuleContentRoot;
import com.android.tools.idea.gradle.project.model.JavaModuleModel;
import com.android.tools.idea.gradle.project.sync.setup.module.common.ContentEntriesSetup;
import com.android.tools.idea.gradle.util.FilePaths;
import com.android.tools.idea.gradle.util.Projects;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.model.java.JavaResourceRootType;
import org.jetbrains.jps.model.java.JavaSourceRootType;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

class JavaContentEntriesSetup
extends ContentEntriesSetup {
    @NotNull
    private final JavaModuleModel myJavaModuleModel;

    JavaContentEntriesSetup(@NotNull JavaModuleModel javaModuleModel, @NotNull ModifiableRootModel moduleModel) {
        if (javaModuleModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "javaModuleModel", "com/android/tools/idea/gradle/project/sync/setup/module/java/JavaContentEntriesSetup", "<init>"));
        }
        if (moduleModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleModel", "com/android/tools/idea/gradle/project/sync/setup/module/java/JavaContentEntriesSetup", "<init>"));
        }
        super(moduleModel);
        this.myJavaModuleModel = javaModuleModel;
    }

    @Override
    public void execute(@NotNull List<ContentEntry> contentEntries) {
        if (contentEntries == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contentEntries", "com/android/tools/idea/gradle/project/sync/setup/module/java/JavaContentEntriesSetup", "execute"));
        }
        boolean isTopLevelJavaModule = Projects.isGradleProjectModule(this.getModule());
        File buildFolderPath = this.myJavaModuleModel.getBuildFolderPath();
        boolean buildFolderExcluded = buildFolderPath != null;
        for (JavaModuleContentRoot contentRoot : this.myJavaModuleModel.getContentRoots()) {
            if (contentRoot == null) continue;
            this.addSourceFolders(contentRoot.getSourceDirPaths(), contentEntries, (JpsModuleSourceRootType)JavaSourceRootType.SOURCE, false);
            this.addSourceFolders(contentRoot.getGenSourceDirPaths(), contentEntries, (JpsModuleSourceRootType)JavaSourceRootType.SOURCE, true);
            this.addSourceFolders(contentRoot.getResourceDirPaths(), contentEntries, (JpsModuleSourceRootType)JavaResourceRootType.RESOURCE, false);
            this.addSourceFolders(contentRoot.getTestDirPaths(), contentEntries, (JpsModuleSourceRootType)JavaSourceRootType.TEST_SOURCE, false);
            this.addSourceFolders(contentRoot.getGenTestDirPaths(), contentEntries, (JpsModuleSourceRootType)JavaSourceRootType.TEST_SOURCE, true);
            this.addSourceFolders(contentRoot.getTestResourceDirPaths(), contentEntries, (JpsModuleSourceRootType)JavaResourceRootType.TEST_RESOURCE, false);
            for (File excluded : contentRoot.getExcludeDirPaths()) {
                ContentEntry contentEntry = FilePaths.findParentContentEntry(excluded, contentEntries);
                if (contentEntry == null) continue;
                if (isTopLevelJavaModule && buildFolderExcluded && FileUtil.filesEqual((File)excluded, (File)buildFolderPath)) {
                    buildFolderExcluded = true;
                    continue;
                }
                this.addExcludedFolder(contentEntry, excluded);
            }
        }
        this.addOrphans();
    }

    private void addSourceFolders(@NotNull Collection<File> folderPaths, @NotNull Collection<ContentEntry> contentEntries, @NotNull JpsModuleSourceRootType type, boolean generated) {
        if (folderPaths == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "folderPaths", "com/android/tools/idea/gradle/project/sync/setup/module/java/JavaContentEntriesSetup", "addSourceFolders"));
        }
        if (contentEntries == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contentEntries", "com/android/tools/idea/gradle/project/sync/setup/module/java/JavaContentEntriesSetup", "addSourceFolders"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/android/tools/idea/gradle/project/sync/setup/module/java/JavaContentEntriesSetup", "addSourceFolders"));
        }
        for (File path : folderPaths) {
            this.addSourceFolder(path, contentEntries, type, generated);
        }
    }
}

