/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.setup.post;

import com.android.ide.common.repository.GradleVersion;
import com.android.tools.idea.IdeInfo;
import com.android.tools.idea.gradle.project.AndroidGradleProjectComponent;
import com.android.tools.idea.gradle.project.GradleProjectSyncData;
import com.android.tools.idea.gradle.project.build.GradleProjectBuilder;
import com.android.tools.idea.gradle.project.sync.GradleSyncInvoker;
import com.android.tools.idea.gradle.project.sync.GradleSyncState;
import com.android.tools.idea.gradle.project.sync.compatibility.VersionCompatibilityChecker;
import com.android.tools.idea.gradle.project.sync.messages.SyncMessages;
import com.android.tools.idea.gradle.project.sync.setup.module.common.DependencySetupErrors;
import com.android.tools.idea.gradle.project.sync.setup.post.ModuleSetup;
import com.android.tools.idea.gradle.project.sync.setup.post.PluginVersionUpgrade;
import com.android.tools.idea.gradle.project.sync.setup.post.ProjectSetup;
import com.android.tools.idea.gradle.project.sync.setup.post.ProjectStructureUsageTracker;
import com.android.tools.idea.gradle.project.sync.setup.post.project.DisposedModules;
import com.android.tools.idea.gradle.project.sync.validation.common.CommonModuleValidator;
import com.android.tools.idea.gradle.util.Projects;
import com.android.tools.idea.gradle.variant.conflict.Conflict;
import com.android.tools.idea.gradle.variant.conflict.ConflictResolution;
import com.android.tools.idea.gradle.variant.conflict.ConflictSet;
import com.android.tools.idea.gradle.variant.profiles.ProjectProfileSelectionDialog;
import com.android.tools.idea.sdk.AndroidSdks;
import com.android.tools.idea.templates.TemplateManager;
import com.android.tools.idea.testartifacts.junit.AndroidJUnitConfigurationType;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.compiler.options.CompileStepBeforeRun;
import com.intellij.execution.BeforeRunTask;
import com.intellij.execution.BeforeRunTaskProvider;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.impl.RunManagerImpl;
import com.intellij.execution.impl.RunnerAndConfigurationSettingsImpl;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ex.ProjectRootManagerEx;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.util.SystemProperties;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PostSyncProjectSetup {
    @NotNull
    private final Project myProject;
    @NotNull
    private final IdeInfo myIdeInfo;
    @NotNull
    private final GradleSyncInvoker mySyncInvoker;
    @NotNull
    private final GradleSyncState mySyncState;
    @NotNull
    private final DependencySetupErrors myDependencySetupErrors;
    @NotNull
    private final ProjectSetup myProjectSetup;
    @NotNull
    private final ModuleSetup myModuleSetup;
    @NotNull
    private final PluginVersionUpgrade myPluginVersionUpgrade;
    @NotNull
    private final VersionCompatibilityChecker myVersionCompatibilityChecker;
    @NotNull
    private final GradleProjectBuilder myProjectBuilder;
    @NotNull
    private final CommonModuleValidator.Factory myModuleValidatorFactory;

    @NotNull
    public static PostSyncProjectSetup getInstance(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/sync/setup/post/PostSyncProjectSetup", "getInstance"));
        }
        PostSyncProjectSetup postSyncProjectSetup = (PostSyncProjectSetup)ServiceManager.getService((Project)project, PostSyncProjectSetup.class);
        if (postSyncProjectSetup == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/sync/setup/post/PostSyncProjectSetup", "getInstance"));
        }
        return postSyncProjectSetup;
    }

    public PostSyncProjectSetup(@NotNull Project project, @NotNull IdeInfo ideInfo, @NotNull AndroidSdks androidSdks, @NotNull GradleSyncInvoker syncInvoker, @NotNull GradleSyncState syncState, @NotNull SyncMessages syncMessages, @NotNull DependencySetupErrors dependencySetupErrors, @NotNull VersionCompatibilityChecker versionCompatibilityChecker, @NotNull GradleProjectBuilder projectBuilder) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/sync/setup/post/PostSyncProjectSetup", "<init>"));
        }
        if (ideInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ideInfo", "com/android/tools/idea/gradle/project/sync/setup/post/PostSyncProjectSetup", "<init>"));
        }
        if (androidSdks == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "androidSdks", "com/android/tools/idea/gradle/project/sync/setup/post/PostSyncProjectSetup", "<init>"));
        }
        if (syncInvoker == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "syncInvoker", "com/android/tools/idea/gradle/project/sync/setup/post/PostSyncProjectSetup", "<init>"));
        }
        if (syncState == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "syncState", "com/android/tools/idea/gradle/project/sync/setup/post/PostSyncProjectSetup", "<init>"));
        }
        if (syncMessages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "syncMessages", "com/android/tools/idea/gradle/project/sync/setup/post/PostSyncProjectSetup", "<init>"));
        }
        if (dependencySetupErrors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dependencySetupErrors", "com/android/tools/idea/gradle/project/sync/setup/post/PostSyncProjectSetup", "<init>"));
        }
        if (versionCompatibilityChecker == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "versionCompatibilityChecker", "com/android/tools/idea/gradle/project/sync/setup/post/PostSyncProjectSetup", "<init>"));
        }
        if (projectBuilder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectBuilder", "com/android/tools/idea/gradle/project/sync/setup/post/PostSyncProjectSetup", "<init>"));
        }
        this(project, ideInfo, syncInvoker, syncState, dependencySetupErrors, new ProjectSetup(project), new ModuleSetup(project), new PluginVersionUpgrade(project), versionCompatibilityChecker, projectBuilder, new CommonModuleValidator.Factory());
    }

    @VisibleForTesting
    PostSyncProjectSetup(@NotNull Project project, @NotNull IdeInfo ideInfo, @NotNull GradleSyncInvoker syncInvoker, @NotNull GradleSyncState syncState, @NotNull DependencySetupErrors dependencySetupErrors, @NotNull ProjectSetup projectSetup, @NotNull ModuleSetup moduleSetup, @NotNull PluginVersionUpgrade pluginVersionUpgrade, @NotNull VersionCompatibilityChecker versionCompatibilityChecker, @NotNull GradleProjectBuilder projectBuilder, @NotNull CommonModuleValidator.Factory moduleValidatorFactory) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/sync/setup/post/PostSyncProjectSetup", "<init>"));
        }
        if (ideInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ideInfo", "com/android/tools/idea/gradle/project/sync/setup/post/PostSyncProjectSetup", "<init>"));
        }
        if (syncInvoker == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "syncInvoker", "com/android/tools/idea/gradle/project/sync/setup/post/PostSyncProjectSetup", "<init>"));
        }
        if (syncState == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "syncState", "com/android/tools/idea/gradle/project/sync/setup/post/PostSyncProjectSetup", "<init>"));
        }
        if (dependencySetupErrors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dependencySetupErrors", "com/android/tools/idea/gradle/project/sync/setup/post/PostSyncProjectSetup", "<init>"));
        }
        if (projectSetup == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectSetup", "com/android/tools/idea/gradle/project/sync/setup/post/PostSyncProjectSetup", "<init>"));
        }
        if (moduleSetup == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleSetup", "com/android/tools/idea/gradle/project/sync/setup/post/PostSyncProjectSetup", "<init>"));
        }
        if (pluginVersionUpgrade == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pluginVersionUpgrade", "com/android/tools/idea/gradle/project/sync/setup/post/PostSyncProjectSetup", "<init>"));
        }
        if (versionCompatibilityChecker == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "versionCompatibilityChecker", "com/android/tools/idea/gradle/project/sync/setup/post/PostSyncProjectSetup", "<init>"));
        }
        if (projectBuilder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectBuilder", "com/android/tools/idea/gradle/project/sync/setup/post/PostSyncProjectSetup", "<init>"));
        }
        if (moduleValidatorFactory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleValidatorFactory", "com/android/tools/idea/gradle/project/sync/setup/post/PostSyncProjectSetup", "<init>"));
        }
        this.myProject = project;
        this.myIdeInfo = ideInfo;
        this.mySyncInvoker = syncInvoker;
        this.mySyncState = syncState;
        this.myDependencySetupErrors = dependencySetupErrors;
        this.myProjectSetup = projectSetup;
        this.myModuleSetup = moduleSetup;
        this.myPluginVersionUpgrade = pluginVersionUpgrade;
        this.myVersionCompatibilityChecker = versionCompatibilityChecker;
        this.myProjectBuilder = projectBuilder;
        this.myModuleValidatorFactory = moduleValidatorFactory;
    }

    public void setUpProject(@NotNull Request request, @Nullable ProgressIndicator progressIndicator) {
        if (request == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/android/tools/idea/gradle/project/sync/setup/post/PostSyncProjectSetup", "setUpProject"));
        }
        ApplicationManager.getApplication().runWriteAction(() -> ProjectRootManagerEx.getInstanceEx((Project)this.myProject).makeRootsChange(EmptyRunnable.INSTANCE, false, true));
        boolean syncFailed = this.mySyncState.lastSyncFailedOrHasIssues();
        if (syncFailed && request.isUsingCachedGradleModels()) {
            this.onCachedModelsSetupFailure(request);
            return;
        }
        this.myDependencySetupErrors.reportErrors();
        this.myVersionCompatibilityChecker.checkAndReportComponentIncompatibilities(this.myProject);
        CommonModuleValidator moduleValidator = this.myModuleValidatorFactory.create(this.myProject);
        ModuleManager moduleManager = ModuleManager.getInstance((Project)this.myProject);
        for (Module module : moduleManager.getModules()) {
            moduleValidator.validate(module);
        }
        moduleValidator.fixAndReportFoundIssues();
        if (syncFailed) {
            this.myProjectSetup.setUpProject(progressIndicator, true);
            this.mySyncState.syncEnded();
            return;
        }
        if (this.myPluginVersionUpgrade.checkAndPerformUpgrade()) {
            return;
        }
        new ProjectStructureUsageTracker(this.myProject).trackProjectStructure();
        DisposedModules.getInstance(this.myProject).deleteImlFilesForDisposedModules();
        Projects.removeAllModuleCompiledArtifacts(this.myProject);
        AndroidGradleProjectComponent.getInstance(this.myProject).checkForSupportedModules();
        this.findAndShowVariantConflicts();
        this.myProjectSetup.setUpProject(progressIndicator, false);
        boolean androidStudio = this.myIdeInfo.isAndroidStudio();
        String taskName = androidStudio ? "Gradle-aware Make" : ExecutionBundle.message((String)"before.launch.compile.step", (Object[])new Object[0]);
        this.setMakeStepInJunitRunConfigurations(taskName);
        this.notifySyncFinished(request);
        this.attemptToGenerateSources(request);
        TemplateManager.getInstance().refreshDynamicTemplateMenu(this.myProject);
        this.myModuleSetup.setUpModules(null);
    }

    private void onCachedModelsSetupFailure(@NotNull Request request) {
        if (request == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/android/tools/idea/gradle/project/sync/setup/post/PostSyncProjectSetup", "onCachedModelsSetupFailure"));
        }
        long syncTimestamp = request.getLastSyncTimestamp();
        if (syncTimestamp < 0L) {
            syncTimestamp = System.currentTimeMillis();
        }
        this.mySyncState.syncSkipped(syncTimestamp);
        this.mySyncInvoker.requestProjectSyncAndSourceGeneration(this.myProject, null);
    }

    private void notifySyncFinished(@NotNull Request request) {
        if (request == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/android/tools/idea/gradle/project/sync/setup/post/PostSyncProjectSetup", "notifySyncFinished"));
        }
        if (request.isUsingCachedGradleModels()) {
            this.mySyncState.syncSkipped(System.currentTimeMillis());
        } else {
            this.mySyncState.syncEnded();
            GradleProjectSyncData.save(this.myProject);
        }
    }

    private void findAndShowVariantConflicts() {
        boolean atLeastOneSolved;
        List<Conflict> selectionConflicts;
        ConflictSet conflicts = ConflictSet.findConflicts(this.myProject);
        List<Conflict> structureConflicts = conflicts.getStructureConflicts();
        if (!structureConflicts.isEmpty() && SystemProperties.getBooleanProperty((String)"enable.project.profiles", (boolean)false)) {
            ProjectProfileSelectionDialog dialog = new ProjectProfileSelectionDialog(this.myProject, structureConflicts);
            dialog.show();
        }
        if (!(selectionConflicts = conflicts.getSelectionConflicts()).isEmpty() && (atLeastOneSolved = ConflictResolution.solveSelectionConflicts(selectionConflicts))) {
            conflicts = ConflictSet.findConflicts(this.myProject);
        }
        conflicts.showSelectionConflicts();
    }

    private void setMakeStepInJunitRunConfigurations(@NotNull String makeTaskName) {
        if (makeTaskName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "makeTaskName", "com/android/tools/idea/gradle/project/sync/setup/post/PostSyncProjectSetup", "setMakeStepInJunitRunConfigurations"));
        }
        AndroidJUnitConfigurationType junitConfigurationType = AndroidJUnitConfigurationType.getInstance();
        BeforeRunTaskProvider[] taskProviders = (BeforeRunTaskProvider[])Extensions.getExtensions((ExtensionPointName)BeforeRunTaskProvider.EXTENSION_POINT_NAME, (AreaInstance)this.myProject);
        BeforeRunTaskProvider targetProvider = null;
        for (BeforeRunTaskProvider provider : taskProviders) {
            if (!makeTaskName.equals(provider.getName())) continue;
            targetProvider = provider;
            break;
        }
        if (targetProvider != null) {
            RunManagerImpl runManager = RunManagerImpl.getInstanceImpl((Project)this.myProject);
            for (ConfigurationFactory configurationFactory : junitConfigurationType.getConfigurationFactories()) {
                RunnerAndConfigurationSettingsImpl template = runManager.getConfigurationTemplate(configurationFactory);
                RunConfiguration runConfiguration = template.getConfiguration();
                this.setMakeStepInJUnitConfiguration(targetProvider, runConfiguration);
            }
            for (RunConfiguration runConfiguration : runManager.getConfigurationsList((ConfigurationType)junitConfigurationType)) {
                this.setMakeStepInJUnitConfiguration(targetProvider, runConfiguration);
            }
        }
    }

    private void setMakeStepInJUnitConfiguration(@NotNull BeforeRunTaskProvider targetProvider, @NotNull RunConfiguration runConfiguration) {
        if (targetProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetProvider", "com/android/tools/idea/gradle/project/sync/setup/post/PostSyncProjectSetup", "setMakeStepInJUnitConfiguration"));
        }
        if (runConfiguration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runConfiguration", "com/android/tools/idea/gradle/project/sync/setup/post/PostSyncProjectSetup", "setMakeStepInJUnitConfiguration"));
        }
        LinkedList<BeforeRunTask> newBeforeRunTasks = new LinkedList<BeforeRunTask>();
        RunManagerImpl runManager = RunManagerImpl.getInstanceImpl((Project)this.myProject);
        for (BeforeRunTask beforeRunTask : runManager.getBeforeRunTasks(runConfiguration)) {
            if (beforeRunTask.getProviderId().equals((Object)CompileStepBeforeRun.ID)) {
                BeforeRunTask task = targetProvider.createTask(runConfiguration);
                if (task == null) continue;
                task.setEnabled(true);
                newBeforeRunTasks.add(task);
                continue;
            }
            newBeforeRunTasks.add(beforeRunTask);
        }
        runManager.setBeforeRunTasks(runConfiguration, newBeforeRunTasks, false);
    }

    private void attemptToGenerateSources(@NotNull Request request) {
        if (request == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/android/tools/idea/gradle/project/sync/setup/post/PostSyncProjectSetup", "attemptToGenerateSources"));
        }
        if (!request.isGenerateSourcesAfterSync()) {
            return;
        }
        boolean cleanProjectAfterSync = request.isCleanProjectAfterSync();
        if (!cleanProjectAfterSync) {
            Map<String, GradleVersion> previousPluginVersionsPerModule = Projects.getPluginVersionsPerModule(this.myProject);
            Projects.storePluginVersionsPerModule(this.myProject);
            if (previousPluginVersionsPerModule != null && !previousPluginVersionsPerModule.isEmpty()) {
                Map<String, GradleVersion> currentPluginVersionsPerModule = Projects.getPluginVersionsPerModule(this.myProject);
                assert (currentPluginVersionsPerModule != null);
                for (Map.Entry<String, GradleVersion> entry : currentPluginVersionsPerModule.entrySet()) {
                    String modulePath = entry.getKey();
                    GradleVersion previous = previousPluginVersionsPerModule.get(modulePath);
                    if (previous != null && entry.getValue().compareTo(previous) == 0) continue;
                    cleanProjectAfterSync = true;
                    break;
                }
            }
        }
        this.myProjectBuilder.generateSourcesOnly(cleanProjectAfterSync);
    }

    public static class Request {
        @NotNull
        public static final Request DEFAULT_REQUEST = new Request(){

            @Override
            @NotNull
            public Request setCleanProjectAfterSync(boolean cleanProjectAfterSync) {
                throw new UnsupportedOperationException();
            }

            @Override
            @NotNull
            public Request setGenerateSourcesAfterSync(boolean generateSourcesAfterSync) {
                throw new UnsupportedOperationException();
            }

            @Override
            @NotNull
            public Request setLastSyncTimestamp(long lastSyncTimestamp) {
                throw new UnsupportedOperationException();
            }

            @Override
            @NotNull
            public Request setUsingCachedGradleModels(boolean usingCachedGradleModels) {
                throw new UnsupportedOperationException();
            }
        };
        private boolean myUsingCachedGradleModels;
        private boolean myCleanProjectAfterSync;
        private boolean myGenerateSourcesAfterSync = true;
        private long myLastSyncTimestamp = -1L;

        boolean isUsingCachedGradleModels() {
            return this.myUsingCachedGradleModels;
        }

        @NotNull
        public Request setUsingCachedGradleModels(boolean usingCachedGradleModels) {
            this.myUsingCachedGradleModels = usingCachedGradleModels;
            Request request = this;
            if (request == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/sync/setup/post/PostSyncProjectSetup$Request", "setUsingCachedGradleModels"));
            }
            return request;
        }

        boolean isCleanProjectAfterSync() {
            return this.myCleanProjectAfterSync;
        }

        @NotNull
        public Request setCleanProjectAfterSync(boolean cleanProjectAfterSync) {
            this.myCleanProjectAfterSync = cleanProjectAfterSync;
            Request request = this;
            if (request == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/sync/setup/post/PostSyncProjectSetup$Request", "setCleanProjectAfterSync"));
            }
            return request;
        }

        boolean isGenerateSourcesAfterSync() {
            return this.myGenerateSourcesAfterSync;
        }

        @NotNull
        public Request setGenerateSourcesAfterSync(boolean generateSourcesAfterSync) {
            this.myGenerateSourcesAfterSync = generateSourcesAfterSync;
            Request request = this;
            if (request == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/sync/setup/post/PostSyncProjectSetup$Request", "setGenerateSourcesAfterSync"));
            }
            return request;
        }

        long getLastSyncTimestamp() {
            return this.myLastSyncTimestamp;
        }

        @NotNull
        public Request setLastSyncTimestamp(long lastSyncTimestamp) {
            this.myLastSyncTimestamp = lastSyncTimestamp;
            Request request = this;
            if (request == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/sync/setup/post/PostSyncProjectSetup$Request", "setLastSyncTimestamp"));
            }
            return request;
        }
    }
}

