/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.setup.post;

import com.android.tools.idea.gradle.project.sync.setup.post.ProjectSetupStep;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProjectSetup {
    @NotNull
    private final Project myProject;
    @NotNull
    private final ProjectSetupStep[] mySetupSteps;

    public ProjectSetup(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/sync/setup/post/ProjectSetup", "<init>"));
        }
        this(project, ProjectSetupStep.getExtensions());
    }

    @VisibleForTesting
    ProjectSetup(@NotNull Project project, ProjectSetupStep ... setupSteps) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/sync/setup/post/ProjectSetup", "<init>"));
        }
        if (setupSteps == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "setupSteps", "com/android/tools/idea/gradle/project/sync/setup/post/ProjectSetup", "<init>"));
        }
        this.myProject = project;
        this.mySetupSteps = setupSteps;
    }

    public void setUpProject(@Nullable ProgressIndicator progressIndicator, boolean syncFailed) {
        Runnable invokeProjectSetupStepsTask = () -> {
            for (ProjectSetupStep step : this.mySetupSteps) {
                if (syncFailed && !step.invokeOnFailedSync()) continue;
                step.setUpProject(this.myProject, progressIndicator);
            }
        };
        if (ApplicationManager.getApplication().isWriteAccessAllowed()) {
            invokeProjectSetupStepsTask.run();
            return;
        }
        ApplicationManager.getApplication().runWriteAction(invokeProjectSetupStepsTask);
    }
}

