/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.setup.post.upgrade;

import com.android.ide.common.repository.GradleVersion;
import com.android.tools.idea.gradle.plugin.AndroidPluginGeneration;
import com.android.tools.idea.gradle.plugin.AndroidPluginInfo;
import com.android.tools.idea.gradle.plugin.AndroidPluginVersionUpdater;
import com.android.tools.idea.gradle.project.sync.GradleSyncState;
import com.android.tools.idea.gradle.project.sync.hyperlink.SearchInBuildFilesHyperlink;
import com.android.tools.idea.gradle.project.sync.messages.MessageType;
import com.android.tools.idea.gradle.project.sync.messages.SyncMessage;
import com.android.tools.idea.gradle.project.sync.messages.SyncMessages;
import com.android.tools.idea.gradle.project.sync.setup.post.PluginVersionUpgradeStep;
import com.android.tools.idea.gradle.project.sync.setup.post.upgrade.ForcedPluginPreviewVersionUpgradeDialog;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ForcedPluginPreviewVersionUpgradeStep
extends PluginVersionUpgradeStep {
    @Override
    public boolean checkAndPerformUpgrade(@NotNull Project project, @NotNull AndroidPluginInfo pluginInfo) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/sync/setup/post/upgrade/ForcedPluginPreviewVersionUpgradeStep", "checkAndPerformUpgrade"));
        }
        if (pluginInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pluginInfo", "com/android/tools/idea/gradle/project/sync/setup/post/upgrade/ForcedPluginPreviewVersionUpgradeStep", "checkAndPerformUpgrade"));
        }
        AndroidPluginGeneration pluginGeneration = pluginInfo.getPluginGeneration();
        GradleVersion recommended = GradleVersion.parse((String)pluginGeneration.getLatestKnownVersion());
        if (!ForcedPluginPreviewVersionUpgradeStep.shouldPreviewBeForcedToUpgradePluginVersion(recommended.toString(), pluginInfo.getPluginVersion())) {
            return false;
        }
        GradleSyncState syncState = GradleSyncState.getInstance(project);
        syncState.syncEnded();
        boolean userAcceptsForcedUpgrade = new ForcedPluginPreviewVersionUpgradeDialog(project, pluginInfo).showAndGet();
        if (userAcceptsForcedUpgrade) {
            AndroidPluginVersionUpdater versionUpdater = AndroidPluginVersionUpdater.getInstance(project);
            versionUpdater.updatePluginVersionAndSync(recommended, GradleVersion.parse((String)"3.3"), true);
        } else {
            String[] text = new String[]{"The project is using an incompatible version of the " + pluginGeneration.getDescription() + ".", "Please update your project to use version " + pluginGeneration.getLatestKnownVersion() + "."};
            SyncMessage msg = new SyncMessage("Gradle Sync Issues", MessageType.ERROR, text);
            String pluginName = AndroidPluginGeneration.getGroupId() + ":" + pluginGeneration.getArtifactId();
            SearchInBuildFilesHyperlink quickFix = new SearchInBuildFilesHyperlink(pluginName);
            msg.add(quickFix);
            SyncMessages.getInstance(project).report(msg);
            syncState.invalidateLastSync("Force plugin upgrade declined");
        }
        return true;
    }

    @VisibleForTesting
    static boolean shouldPreviewBeForcedToUpgradePluginVersion(@NotNull String recommended, @Nullable GradleVersion current) {
        if (recommended == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "recommended", "com/android/tools/idea/gradle/project/sync/setup/post/upgrade/ForcedPluginPreviewVersionUpgradeStep", "shouldPreviewBeForcedToUpgradePluginVersion"));
        }
        if (current != null && current.getPreviewType() != null) {
            return current.compareTo(recommended) < 0;
        }
        return false;
    }
}

