/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.util;

import com.android.SdkConstants;
import com.android.tools.idea.gradle.util.PropertiesFiles;
import com.android.tools.idea.templates.TemplateManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GradleWrapper {
    @NonNls
    public static final String GRADLEW_PROPERTIES_PATH = FileUtil.join((String[])new String[]{SdkConstants.FD_GRADLE_WRAPPER, "gradle-wrapper.properties"});
    private static final Pattern GRADLE_DISTRIBUTION_URL_PATTERN = Pattern.compile(".*/gradle-([^-]+)(-[^\\/\\\\]+)?-(bin|all).zip");
    @NotNull
    private final File myPropertiesFilePath;
    @Nullable
    private final Project myProject;

    @Nullable
    public static GradleWrapper find(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/util/GradleWrapper", "find"));
        }
        String basePath = project.getBasePath();
        if (basePath == null) {
            return null;
        }
        File baseDir = new File(basePath);
        File propertiesFilePath = GradleWrapper.getDefaultPropertiesFilePath(baseDir);
        return propertiesFilePath.isFile() ? new GradleWrapper(propertiesFilePath, project) : null;
    }

    @NotNull
    public static GradleWrapper get(@NotNull File propertiesFilePath) {
        if (propertiesFilePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertiesFilePath", "com/android/tools/idea/gradle/util/GradleWrapper", "get"));
        }
        GradleWrapper gradleWrapper = new GradleWrapper(propertiesFilePath, null);
        if (gradleWrapper == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/util/GradleWrapper", "get"));
        }
        return gradleWrapper;
    }

    public static GradleWrapper create(@NotNull File projectPath) throws IOException {
        if (projectPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectPath", "com/android/tools/idea/gradle/util/GradleWrapper", "create"));
        }
        return GradleWrapper.create(projectPath, "3.3");
    }

    public static GradleWrapper create(@NotNull File projectPath, @NotNull String gradleVersion) throws IOException {
        if (projectPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectPath", "com/android/tools/idea/gradle/util/GradleWrapper", "create"));
        }
        if (gradleVersion == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gradleVersion", "com/android/tools/idea/gradle/util/GradleWrapper", "create"));
        }
        File wrapperFolderPath = new File(projectPath, SdkConstants.FD_GRADLE_WRAPPER);
        if (!wrapperFolderPath.isDirectory()) {
            File srcFolderPath = new File(TemplateManager.getTemplateRootFolder(), SdkConstants.FD_GRADLE_WRAPPER);
            if (!srcFolderPath.exists()) {
                File root;
                Iterator<File> iterator = TemplateManager.getExtraTemplateRootFolders().iterator();
                while (iterator.hasNext() && !(srcFolderPath = new File(root = iterator.next(), SdkConstants.FD_GRADLE_WRAPPER)).exists()) {
                    srcFolderPath = null;
                }
            }
            if (srcFolderPath == null) {
                return null;
            }
            FileUtil.copyDirContent((File)srcFolderPath, (File)projectPath);
        }
        File propertiesFilePath = GradleWrapper.getDefaultPropertiesFilePath(projectPath);
        GradleWrapper gradleWrapper = GradleWrapper.get(propertiesFilePath);
        gradleWrapper.updateDistributionUrl(gradleVersion);
        return gradleWrapper;
    }

    private GradleWrapper(@NotNull File propertiesFilePath, @Nullable Project project) {
        if (propertiesFilePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertiesFilePath", "com/android/tools/idea/gradle/util/GradleWrapper", "<init>"));
        }
        this.myProject = project;
        this.myPropertiesFilePath = propertiesFilePath;
    }

    @NotNull
    public File getPropertiesFilePath() {
        File file = this.myPropertiesFilePath;
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/util/GradleWrapper", "getPropertiesFilePath"));
        }
        return file;
    }

    @Nullable
    public VirtualFile getPropertiesFile() {
        return VfsUtil.findFileByIoFile((File)this.myPropertiesFilePath, (boolean)true);
    }

    @NotNull
    public static File getDefaultPropertiesFilePath(@NotNull File projectPath) {
        if (projectPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectPath", "com/android/tools/idea/gradle/util/GradleWrapper", "getDefaultPropertiesFilePath"));
        }
        File file = new File(projectPath, GRADLEW_PROPERTIES_PATH);
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/util/GradleWrapper", "getDefaultPropertiesFilePath"));
        }
        return file;
    }

    public boolean updateDistributionUrlAndDisplayFailure(@NotNull String gradleVersion) {
        if (gradleVersion == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gradleVersion", "com/android/tools/idea/gradle/util/GradleWrapper", "updateDistributionUrlAndDisplayFailure"));
        }
        try {
            boolean updated = this.updateDistributionUrl(gradleVersion);
            if (updated) {
                VirtualFile virtualFile = VfsUtil.findFileByIoFile((File)this.myPropertiesFilePath, (boolean)true);
                if (virtualFile != null) {
                    virtualFile.refresh(false, false);
                }
                return true;
            }
        }
        catch (IOException e) {
            String msg = String.format("Unable to update Gradle wrapper to use Gradle %1$s\n", gradleVersion);
            msg = msg + e.getMessage();
            Messages.showErrorDialog((Project)this.myProject, (String)msg, (String)"Unexpected Error");
        }
        return false;
    }

    public boolean updateDistributionUrl(@NotNull String gradleVersion) throws IOException {
        if (gradleVersion == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gradleVersion", "com/android/tools/idea/gradle/util/GradleWrapper", "updateDistributionUrl"));
        }
        Properties properties = this.getProperties();
        String distributionUrl = GradleWrapper.getDistributionUrl(gradleVersion, false);
        String property = properties.getProperty("distributionUrl");
        if (property != null && (property.equals(distributionUrl) || property.equals(GradleWrapper.getDistributionUrl(gradleVersion, true)))) {
            return false;
        }
        properties.setProperty("distributionUrl", distributionUrl);
        PropertiesFiles.savePropertiesToFile(properties, this.myPropertiesFilePath, null);
        return true;
    }

    public void updateDistributionUrl(@NotNull File gradleDistribution) throws IOException {
        if (gradleDistribution == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gradleDistribution", "com/android/tools/idea/gradle/util/GradleWrapper", "updateDistributionUrl"));
        }
        String path = gradleDistribution.getPath();
        if (!FileUtilRt.extensionEquals((String)path, (String)"zip")) {
            throw new IllegalArgumentException("'" + path + "' should be a zip file");
        }
        Properties properties = this.getProperties();
        properties.setProperty("distributionUrl", gradleDistribution.toURI().toURL().toString());
        PropertiesFiles.savePropertiesToFile(properties, this.myPropertiesFilePath, null);
    }

    @NotNull
    public Properties getProperties() throws IOException {
        Properties properties = PropertiesFiles.getProperties(this.myPropertiesFilePath);
        if (properties == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/util/GradleWrapper", "getProperties"));
        }
        return properties;
    }

    @Nullable
    public String getGradleVersion() throws IOException {
        Matcher m;
        String url = this.getProperties().getProperty("distributionUrl");
        if (url != null && (m = GRADLE_DISTRIBUTION_URL_PATTERN.matcher(url)).matches()) {
            return m.group(1);
        }
        return null;
    }

    @NotNull
    private static String getDistributionUrl(@NotNull String gradleVersion, boolean binOnly) {
        if (gradleVersion == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gradleVersion", "com/android/tools/idea/gradle/util/GradleWrapper", "getDistributionUrl"));
        }
        String suffix = binOnly ? "bin" : "all";
        String string = String.format("https://services.gradle.org/distributions/gradle-%1$s-" + suffix + ".zip", gradleVersion);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/util/GradleWrapper", "getDistributionUrl"));
        }
        return string;
    }
}

