/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.lang.databinding;

import com.android.tools.idea.lang.databinding.DbFile;
import com.android.tools.idea.lang.databinding.DbLanguage;
import com.android.tools.idea.lang.databinding._DbLexer;
import com.android.tools.idea.lang.databinding.parser.DbParser;
import com.android.tools.idea.lang.databinding.psi.DbTokenTypes;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.PsiParser;
import com.intellij.lexer.FlexAdapter;
import com.intellij.lexer.FlexLexer;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.project.Project;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.TokenType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.IFileElementType;
import com.intellij.psi.tree.TokenSet;
import org.jetbrains.annotations.NotNull;

public class DbParserDefinition
implements ParserDefinition {
    private static final IFileElementType FILE_ELEMENT_TYPE = new IFileElementType((Language)DbLanguage.INSTANCE);
    private static final TokenSet WHITE_SPACES = TokenSet.create((IElementType[])new IElementType[]{TokenType.WHITE_SPACE});

    @NotNull
    public Lexer createLexer(Project project) {
        FlexAdapter flexAdapter = new FlexAdapter((FlexLexer)new _DbLexer(null));
        if (flexAdapter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/lang/databinding/DbParserDefinition", "createLexer"));
        }
        return flexAdapter;
    }

    public PsiParser createParser(Project project) {
        return new DbParser();
    }

    public IFileElementType getFileNodeType() {
        return FILE_ELEMENT_TYPE;
    }

    @NotNull
    public TokenSet getWhitespaceTokens() {
        TokenSet tokenSet = WHITE_SPACES;
        if (tokenSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/lang/databinding/DbParserDefinition", "getWhitespaceTokens"));
        }
        return tokenSet;
    }

    @NotNull
    public TokenSet getCommentTokens() {
        TokenSet tokenSet = TokenSet.EMPTY;
        if (tokenSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/lang/databinding/DbParserDefinition", "getCommentTokens"));
        }
        return tokenSet;
    }

    @NotNull
    public TokenSet getStringLiteralElements() {
        TokenSet tokenSet = TokenSet.create((IElementType[])new IElementType[]{DbTokenTypes.STRING_LITERAL});
        if (tokenSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/lang/databinding/DbParserDefinition", "getStringLiteralElements"));
        }
        return tokenSet;
    }

    @NotNull
    public PsiElement createElement(ASTNode node) {
        PsiElement psiElement = DbTokenTypes.Factory.createElement(node);
        if (psiElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/lang/databinding/DbParserDefinition", "createElement"));
        }
        return psiElement;
    }

    public PsiFile createFile(FileViewProvider viewProvider) {
        return new DbFile(viewProvider);
    }

    public ParserDefinition.SpaceRequirements spaceExistanceTypeBetweenTokens(ASTNode left, ASTNode right) {
        return ParserDefinition.SpaceRequirements.MAY;
    }
}

