/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.lint;

import com.android.tools.idea.lint.DefaultLintQuickFix;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlTag;
import org.jetbrains.android.inspections.lint.AndroidQuickfixContexts;
import org.jetbrains.annotations.NotNull;

class RenameXmlTagQuickFix
extends DefaultLintQuickFix {
    private final String myNewName;

    RenameXmlTagQuickFix(@NotNull String newName) {
        if (newName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newName", "com/android/tools/idea/lint/RenameXmlTagQuickFix", "<init>"));
        }
        super("Use " + newName);
        this.myNewName = newName;
    }

    @Override
    public void apply(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.Context context) {
        if (startElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startElement", "com/android/tools/idea/lint/RenameXmlTagQuickFix", "apply"));
        }
        if (endElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "endElement", "com/android/tools/idea/lint/RenameXmlTagQuickFix", "apply"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/android/tools/idea/lint/RenameXmlTagQuickFix", "apply"));
        }
        XmlTag currentTag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)startElement, XmlTag.class, (boolean)false);
        if (currentTag == null) {
            return;
        }
        XmlTag parentTag = currentTag.getParentTag();
        if (parentTag == null) {
            return;
        }
        XmlTag newTag = parentTag.createChildTag(this.myNewName, null, currentTag.isEmpty() ? null : currentTag.getValue().getText(), true);
        for (XmlAttribute attr : currentTag.getAttributes()) {
            newTag.setAttribute(attr.getLocalName(), attr.getNamespace(), attr.getValue());
        }
        currentTag.replace((PsiElement)newTag);
    }

    @Override
    public boolean isApplicable(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.ContextType contextType) {
        if (startElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startElement", "com/android/tools/idea/lint/RenameXmlTagQuickFix", "isApplicable"));
        }
        if (endElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "endElement", "com/android/tools/idea/lint/RenameXmlTagQuickFix", "isApplicable"));
        }
        if (contextType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contextType", "com/android/tools/idea/lint/RenameXmlTagQuickFix", "isApplicable"));
        }
        return startElement.isValid() && endElement.isValid() && PsiTreeUtil.getParentOfType((PsiElement)startElement, XmlTag.class) != null;
    }
}

