/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.monitor.ui.network.model;

import com.android.tools.datastore.DataAdapter;
import com.android.tools.datastore.DataAdapterImpl;
import com.android.tools.datastore.LongDataAdapter;
import com.android.tools.datastore.Poller;
import com.android.tools.datastore.SeriesDataStore;
import com.android.tools.datastore.SeriesDataType;
import com.android.tools.idea.monitor.ui.network.model.SpeedData;
import com.android.tools.idea.monitor.ui.network.view.NetworkRadioSegment;
import com.android.tools.profiler.proto.NetworkProfiler;
import com.android.tools.profiler.proto.NetworkServiceGrpc;
import gnu.trove.TLongArrayList;
import io.grpc.StatusRuntimeException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

public class NetworkDataPoller
extends Poller {
    private final SpeedData mySpeedData;
    private final TLongArrayList myConnectionsTimeData;
    private final TLongArrayList myConnectionsData;
    private final TLongArrayList myRadioTimeData;
    private final TLongArrayList myNetworkTypeTimeData;
    private final List<NetworkRadioSegment.RadioState> myRadioData;
    private final List<NetworkRadioSegment.NetworkType> myNetworkTypeData;
    private NetworkServiceGrpc.NetworkServiceBlockingStub myNetworkService;
    private int myPid;
    private long myLatestTimestampNs;

    public NetworkDataPoller(@NotNull SeriesDataStore dataStore, int pid) {
        if (dataStore == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataStore", "com/android/tools/idea/monitor/ui/network/model/NetworkDataPoller", "<init>"));
        }
        super(dataStore, POLLING_DELAY_NS);
        this.mySpeedData = new SpeedData();
        this.myConnectionsTimeData = new TLongArrayList();
        this.myConnectionsData = new TLongArrayList();
        this.myRadioTimeData = new TLongArrayList();
        this.myNetworkTypeTimeData = new TLongArrayList();
        this.myRadioData = new ArrayList<NetworkRadioSegment.RadioState>();
        this.myNetworkTypeData = new ArrayList<NetworkRadioSegment.NetworkType>();
        this.myLatestTimestampNs = Long.MIN_VALUE;
        this.myPid = pid;
        this.registerAdapters();
    }

    private void registerAdapters() {
        this.myDataStore.registerAdapter(SeriesDataType.NETWORK_RECEIVED, (DataAdapter)new LongDataAdapter(this.mySpeedData.getTimeData(), this.mySpeedData.getReceived()));
        this.myDataStore.registerAdapter(SeriesDataType.NETWORK_SENT, (DataAdapter)new LongDataAdapter(this.mySpeedData.getTimeData(), this.mySpeedData.getSent()));
        this.myDataStore.registerAdapter(SeriesDataType.NETWORK_CONNECTIONS, (DataAdapter)new LongDataAdapter(this.myConnectionsTimeData, this.myConnectionsData));
        this.myDataStore.registerAdapter(SeriesDataType.NETWORK_RADIO, (DataAdapter)new DataAdapterImpl(this.myRadioTimeData, this.myRadioData));
        this.myDataStore.registerAdapter(SeriesDataType.NETWORK_TYPE, (DataAdapter)new DataAdapterImpl(this.myNetworkTypeTimeData, this.myNetworkTypeData));
    }

    protected void asyncInit() throws StatusRuntimeException {
        this.myNetworkService = this.myService.getNetworkService();
        NetworkProfiler.NetworkStartRequest.Builder requestBuilder = NetworkProfiler.NetworkStartRequest.newBuilder().setAppId(this.myPid);
        this.myNetworkService.startMonitoringApp(requestBuilder.build());
    }

    protected void asyncShutdown() throws StatusRuntimeException {
        this.myNetworkService.stopMonitoringApp(NetworkProfiler.NetworkStopRequest.newBuilder().setAppId(this.myPid).build());
    }

    protected void poll() throws StatusRuntimeException {
        NetworkProfiler.NetworkDataRequest request = NetworkProfiler.NetworkDataRequest.newBuilder().setAppId(this.myPid).setType(NetworkProfiler.NetworkDataRequest.Type.ALL).setStartTimestamp(this.myLatestTimestampNs).setEndTimestamp(Long.MAX_VALUE).build();
        NetworkProfiler.NetworkDataResponse response = this.myNetworkService.getData(request);
        for (NetworkProfiler.NetworkProfilerData data : response.getDataList()) {
            long timestampNs = data.getBasicInfo().getEndTimestamp();
            long timestampUs = TimeUnit.NANOSECONDS.toMicros(timestampNs);
            if (data.getDataCase() == NetworkProfiler.NetworkProfilerData.DataCase.SPEED_DATA) {
                this.mySpeedData.add(data.getSpeedData().getSent(), data.getSpeedData().getReceived(), timestampUs);
            } else if (data.getDataCase() == NetworkProfiler.NetworkProfilerData.DataCase.CONNECTION_DATA) {
                this.myConnectionsTimeData.add(timestampUs);
                this.myConnectionsData.add((long)data.getConnectionData().getConnectionNumber());
            } else if (data.getDataCase() == NetworkProfiler.NetworkProfilerData.DataCase.CONNECTIVITY_DATA) {
                Enum type;
                switch (data.getConnectivityData().getRadioState()) {
                    case ACTIVE: {
                        type = NetworkRadioSegment.RadioState.ACTIVE;
                        break;
                    }
                    case IDLE: {
                        type = NetworkRadioSegment.RadioState.IDLE;
                        break;
                    }
                    case SLEEPING: {
                        type = NetworkRadioSegment.RadioState.SLEEPING;
                        break;
                    }
                    default: {
                        type = NetworkRadioSegment.RadioState.NONE;
                    }
                }
                if (this.myRadioData.size() == 0 || this.myRadioData.get(this.myRadioData.size() - 1) != type) {
                    this.myRadioData.add((NetworkRadioSegment.RadioState)type);
                    this.myRadioTimeData.add(timestampUs);
                }
                switch (data.getConnectivityData().getDefaultNetworkType()) {
                    case MOBILE: {
                        type = NetworkRadioSegment.NetworkType.MOBILE;
                        break;
                    }
                    case WIFI: {
                        type = NetworkRadioSegment.NetworkType.WIFI;
                        break;
                    }
                    default: {
                        type = NetworkRadioSegment.NetworkType.NONE;
                    }
                }
                if (this.myNetworkTypeData.size() == 0 || this.myNetworkTypeData.get(this.myNetworkTypeData.size() - 1) != type) {
                    this.myNetworkTypeData.add((NetworkRadioSegment.NetworkType)type);
                    this.myNetworkTypeTimeData.add(timestampUs);
                }
            }
            this.myLatestTimestampNs = Math.max(this.myLatestTimestampNs, timestampNs + 1L);
        }
    }
}

