/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.monitor.ui.network.view;

import com.android.tools.adtui.Animatable;
import com.android.tools.adtui.LegendComponent;
import com.android.tools.adtui.LegendRenderData;
import com.android.tools.adtui.chart.StateChart;
import com.android.tools.adtui.common.AdtUiUtils;
import com.android.tools.adtui.model.DataSeries;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.RangedSeries;
import com.android.tools.datastore.DataStoreSeries;
import com.android.tools.datastore.SeriesDataStore;
import com.android.tools.datastore.SeriesDataType;
import com.android.tools.idea.monitor.tool.ProfilerEventListener;
import com.android.tools.idea.monitor.ui.BaseSegment;
import com.intellij.ui.JBColor;
import com.intellij.util.EventDispatcher;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class NetworkRadioSegment
extends BaseSegment {
    private static final String SEGMENT_NAME = "Radio";
    private LegendComponent mLegendComponent;
    private StateChart<RadioState> mRadioChart;
    private StateChart<NetworkType> mNetworkTypeChart;
    private SeriesDataStore mDataStore;

    public NetworkRadioSegment(@NotNull Range timeCurrentRangeUs, @NotNull SeriesDataStore dataStore, @NotNull EventDispatcher<ProfilerEventListener> dispatcher) {
        if (timeCurrentRangeUs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "timeCurrentRangeUs", "com/android/tools/idea/monitor/ui/network/view/NetworkRadioSegment", "<init>"));
        }
        if (dataStore == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataStore", "com/android/tools/idea/monitor/ui/network/view/NetworkRadioSegment", "<init>"));
        }
        if (dispatcher == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dispatcher", "com/android/tools/idea/monitor/ui/network/view/NetworkRadioSegment", "<init>"));
        }
        super(SEGMENT_NAME, timeCurrentRangeUs, dispatcher);
        this.mDataStore = dataStore;
    }

    private static EnumMap<RadioState, Color> getRadioStateColor() {
        EnumMap<RadioState, Color> colors = new EnumMap<RadioState, Color>(RadioState.class);
        colors.put(RadioState.NONE, AdtUiUtils.DEFAULT_BACKGROUND_COLOR);
        colors.put(RadioState.ACTIVE, JBColor.BLUE.darker());
        colors.put(RadioState.SLEEPING, (Color)JBColor.BLUE);
        colors.put(RadioState.IDLE, JBColor.BLUE.brighter());
        return colors;
    }

    private static EnumMap<RadioState, String> getRadioStateLabel() {
        EnumMap<RadioState, String> labels = new EnumMap<RadioState, String>(RadioState.class);
        labels.put(RadioState.NONE, "Radio None");
        labels.put(RadioState.ACTIVE, "Radio Full");
        labels.put(RadioState.SLEEPING, "Radio Low");
        labels.put(RadioState.IDLE, "Radio Idle");
        return labels;
    }

    private static EnumMap<NetworkType, Color> getNetworkTypeColor() {
        EnumMap<NetworkType, Color> colors = new EnumMap<NetworkType, Color>(NetworkType.class);
        colors.put(NetworkType.NONE, (Color)JBColor.BLACK);
        colors.put(NetworkType.MOBILE, (Color)JBColor.BLACK);
        colors.put(NetworkType.WIFI, (Color)JBColor.BLACK);
        return colors;
    }

    @Override
    public void createComponentsList(@NotNull List<Animatable> animatables) {
        if (animatables == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "animatables", "com/android/tools/idea/monitor/ui/network/view/NetworkRadioSegment", "createComponentsList"));
        }
        EnumMap<RadioState, Color> colorsMap = NetworkRadioSegment.getRadioStateColor();
        EnumMap<RadioState, String> labelsMap = NetworkRadioSegment.getRadioStateLabel();
        this.mRadioChart = new StateChart(colorsMap);
        this.mRadioChart.addSeries(new RangedSeries(this.myTimeCurrentRangeUs, (DataSeries)new DataStoreSeries(this.mDataStore, SeriesDataType.NETWORK_RADIO)));
        this.mNetworkTypeChart = new StateChart(NetworkRadioSegment.getNetworkTypeColor());
        this.mNetworkTypeChart.setRenderMode(StateChart.RenderMode.TEXT);
        this.mNetworkTypeChart.addSeries(new RangedSeries(this.myTimeCurrentRangeUs, (DataSeries)new DataStoreSeries(this.mDataStore, SeriesDataType.NETWORK_TYPE)));
        ArrayList<LegendRenderData> legendRenderDataList = new ArrayList<LegendRenderData>();
        for (RadioState state : RadioState.values()) {
            LegendRenderData renderData = new LegendRenderData(LegendRenderData.IconType.LINE, colorsMap.get((Object)state), labelsMap.get((Object)state));
            legendRenderDataList.add(renderData);
        }
        this.mLegendComponent = new LegendComponent(LegendComponent.Orientation.HORIZONTAL, 100);
        this.mLegendComponent.setLegendData(legendRenderDataList);
        animatables.add((Animatable)this.mNetworkTypeChart);
        animatables.add((Animatable)this.mRadioChart);
        animatables.add((Animatable)this.mLegendComponent);
    }

    @Override
    protected void setTopCenterContent(@NotNull JPanel panel) {
        if (panel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "panel", "com/android/tools/idea/monitor/ui/network/view/NetworkRadioSegment", "setTopCenterContent"));
        }
        panel.add((Component)this.mLegendComponent, "East");
    }

    @Override
    protected void setCenterContent(@NotNull JPanel panel) {
        if (panel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "panel", "com/android/tools/idea/monitor/ui/network/view/NetworkRadioSegment", "setCenterContent"));
        }
        panel.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.gridx = 0;
        gbc.gridy = 0;
        panel.add((Component)this.mNetworkTypeChart, gbc);
        gbc.gridy = 1;
        panel.add((Component)this.mRadioChart, gbc);
    }

    public static enum NetworkType {
        NONE,
        WIFI,
        MOBILE;

    }

    public static enum RadioState {
        NONE,
        ACTIVE,
        IDLE,
        SLEEPING;

    }
}

