/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.navigator.nodes;

import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.project.model.NdkModuleModel;
import com.android.tools.idea.navigator.AndroidProjectViewPane;
import com.android.tools.idea.navigator.nodes.AndroidJniFolderNode;
import com.android.tools.idea.navigator.nodes.AndroidManifestsGroupNode;
import com.android.tools.idea.navigator.nodes.AndroidResFolderNode;
import com.android.tools.idea.navigator.nodes.AndroidSourceTypeNode;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.intellij.codeInsight.dataflow.SetUtil;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.nodes.ProjectViewModuleNode;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Queryable;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidSourceType;
import org.jetbrains.android.facet.IdeaSourceProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidModuleNode
extends ProjectViewModuleNode {
    private final AndroidProjectViewPane myProjectViewPane;

    public AndroidModuleNode(@NotNull Project project, @NotNull Module module, ViewSettings settings, @NotNull AndroidProjectViewPane projectViewPane) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/navigator/nodes/AndroidModuleNode", "<init>"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/navigator/nodes/AndroidModuleNode", "<init>"));
        }
        if (projectViewPane == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectViewPane", "com/android/tools/idea/navigator/nodes/AndroidModuleNode", "<init>"));
        }
        super(project, module, settings);
        this.myProjectViewPane = projectViewPane;
    }

    @NotNull
    private Module getModule() {
        Module module = (Module)this.getValue();
        assert (module != null);
        Module module2 = module;
        if (module2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/navigator/nodes/AndroidModuleNode", "getModule"));
        }
        return module2;
    }

    @NotNull
    public Collection<AbstractTreeNode> getChildren() {
        AndroidFacet facet = AndroidFacet.getInstance(this.getModule());
        if (facet == null || facet.getAndroidModel() == null) {
            Collection collection = super.getChildren();
            if (collection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/navigator/nodes/AndroidModuleNode", "getChildren"));
            }
            return collection;
        }
        Collection<AbstractTreeNode> collection = AndroidModuleNode.getChildren(facet, this.getSettings(), this.myProjectViewPane, AndroidProjectViewPane.getSourceProviders(facet));
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/navigator/nodes/AndroidModuleNode", "getChildren"));
        }
        return collection;
    }

    @NotNull
    public static Collection<AbstractTreeNode> getChildren(@NotNull AndroidFacet facet, @NotNull ViewSettings settings, @NotNull AndroidProjectViewPane pane, @NotNull List<IdeaSourceProvider> providers) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/android/tools/idea/navigator/nodes/AndroidModuleNode", "getChildren"));
        }
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/android/tools/idea/navigator/nodes/AndroidModuleNode", "getChildren"));
        }
        if (pane == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pane", "com/android/tools/idea/navigator/nodes/AndroidModuleNode", "getChildren"));
        }
        if (providers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "providers", "com/android/tools/idea/navigator/nodes/AndroidModuleNode", "getChildren"));
        }
        Project project = facet.getModule().getProject();
        ArrayList result = Lists.newArrayList();
        AndroidModuleModel androidModuleModel = AndroidModuleModel.get(facet);
        HashMultimap<AndroidSourceType, VirtualFile> sourcesByType = AndroidModuleNode.getSourcesBySourceType(providers, androidModuleModel);
        NdkModuleModel ndkModuleModel = NdkModuleModel.get(facet.getModule());
        for (AndroidSourceType sourceType : sourcesByType.keySet()) {
            if (sourceType == AndroidSourceType.CPP && ndkModuleModel != null) continue;
            if (sourceType == AndroidSourceType.MANIFEST) {
                result.add(new AndroidManifestsGroupNode(project, facet, settings, sourcesByType.get((Object)sourceType)));
                continue;
            }
            if (sourceType == AndroidSourceType.RES) {
                result.add(new AndroidResFolderNode(project, facet, settings, sourcesByType.get((Object)sourceType), pane));
                continue;
            }
            if (sourceType == AndroidSourceType.SHADERS && (androidModuleModel == null || !androidModuleModel.getFeatures().isShadersSupported())) continue;
            result.add(new AndroidSourceTypeNode(project, facet, settings, sourceType, sourcesByType.get((Object)sourceType), pane));
        }
        if (ndkModuleModel != null) {
            result.add(new AndroidJniFolderNode(project, ndkModuleModel, settings));
        }
        ArrayList arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/navigator/nodes/AndroidModuleNode", "getChildren"));
        }
        return arrayList;
    }

    @NotNull
    private static HashMultimap<AndroidSourceType, VirtualFile> getSourcesBySourceType(@NotNull List<IdeaSourceProvider> providers, @Nullable AndroidModuleModel androidModuleModel) {
        if (providers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "providers", "com/android/tools/idea/navigator/nodes/AndroidModuleNode", "getSourcesBySourceType"));
        }
        HashMultimap sourcesByType = HashMultimap.create();
        HashSet allSources = Sets.newHashSet();
        for (AndroidSourceType sourceType : AndroidSourceType.values()) {
            Set<VirtualFile> sources;
            if (sourceType == AndroidSourceType.SHADERS && (androidModuleModel == null || !androidModuleModel.getFeatures().isShadersSupported()) || (sources = AndroidModuleNode.getSources(sourceType, providers)).isEmpty()) continue;
            if (SetUtil.intersect((Set)allSources, sources).isEmpty()) {
                sourcesByType.putAll((Object)sourceType, sources);
            } else if (!allSources.containsAll(sources)) {
                sources.removeAll(allSources);
                sourcesByType.putAll((Object)sourceType, sources);
            }
            allSources.addAll(sources);
        }
        HashMultimap hashMultimap = sourcesByType;
        if (hashMultimap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/navigator/nodes/AndroidModuleNode", "getSourcesBySourceType"));
        }
        return hashMultimap;
    }

    @NotNull
    private static Set<VirtualFile> getSources(AndroidSourceType sourceType, Iterable<IdeaSourceProvider> providers) {
        HashSet sources = Sets.newHashSet();
        for (IdeaSourceProvider provider : providers) {
            sources.addAll(sourceType.getSources(provider));
        }
        HashSet hashSet = sources;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/navigator/nodes/AndroidModuleNode", "getSources"));
        }
        return hashSet;
    }

    @Nullable
    public Comparable getSortKey() {
        return this.getModule().getName();
    }

    @Nullable
    public Comparable getTypeSortKey() {
        return this.getSortKey();
    }

    @Nullable
    public String toTestString(@Nullable Queryable.PrintInfo printInfo) {
        return String.format("%1$s (Android)", this.getModule().getName());
    }

    public boolean equals(Object o) {
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        return super.equals(o);
    }
}

