/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.importing;

import com.android.tools.idea.npw.importing.CreateModuleFromArchiveAction;
import com.android.tools.idea.npw.project.AndroidGradleModuleUtils;
import com.android.tools.idea.ui.properties.ObservableValue;
import com.android.tools.idea.ui.properties.core.BoolProperty;
import com.android.tools.idea.ui.properties.core.BoolValueProperty;
import com.android.tools.idea.ui.properties.core.StringProperty;
import com.android.tools.idea.ui.properties.core.StringValueProperty;
import com.android.tools.idea.ui.properties.expressions.bool.BooleanExpression;
import com.android.tools.idea.wizard.model.WizardModel;
import com.intellij.openapi.project.Project;
import java.io.File;
import org.jetbrains.annotations.NotNull;

public final class ArchiveToGradleModuleModel
extends WizardModel {
    private final Project myProject;
    private final StringProperty myArchive;
    private final StringProperty myGradlePath;
    private final BoolProperty myMoveArchive;

    public ArchiveToGradleModuleModel(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/npw/importing/ArchiveToGradleModuleModel", "<init>"));
        }
        this.myArchive = new StringValueProperty();
        this.myGradlePath = new StringValueProperty();
        this.myMoveArchive = new BoolValueProperty();
        this.myProject = project;
        this.myArchive.addConstraint(String::trim);
        this.myGradlePath.addConstraint(String::trim);
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/importing/ArchiveToGradleModuleModel", "getProject"));
        }
        return project;
    }

    @NotNull
    public StringProperty archive() {
        StringProperty stringProperty = this.myArchive;
        if (stringProperty == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/importing/ArchiveToGradleModuleModel", "archive"));
        }
        return stringProperty;
    }

    @NotNull
    public StringProperty gradlePath() {
        StringProperty stringProperty = this.myGradlePath;
        if (stringProperty == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/importing/ArchiveToGradleModuleModel", "gradlePath"));
        }
        return stringProperty;
    }

    @NotNull
    public BoolProperty moveArchive() {
        BoolProperty boolProperty = this.myMoveArchive;
        if (boolProperty == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/importing/ArchiveToGradleModuleModel", "moveArchive"));
        }
        return boolProperty;
    }

    @NotNull
    public BooleanExpression inModule() {
        BooleanExpression booleanExpression = new BooleanExpression(new ObservableValue[]{this.myArchive}){

            @Override
            @NotNull
            public Boolean get() {
                Boolean bl = AndroidGradleModuleUtils.getContainingModule(new File((String)ArchiveToGradleModuleModel.this.myArchive.get()), ArchiveToGradleModuleModel.this.myProject) != null;
                if (bl == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/importing/ArchiveToGradleModuleModel$1", "get"));
                }
                return bl;
            }
        };
        if (booleanExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/importing/ArchiveToGradleModuleModel", "inModule"));
        }
        return booleanExpression;
    }

    @Override
    protected void handleFinished() {
        String path = (String)this.myGradlePath.get();
        new CreateModuleFromArchiveAction(this.myProject, path.startsWith(":") ? path : ":" + path, (String)this.myArchive.get(), (Boolean)this.myMoveArchive.get(), AndroidGradleModuleUtils.getContainingModule(new File((String)this.myArchive.get()), this.myProject)).execute();
    }
}

