/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.importing;

import com.android.tools.idea.gradle.project.ModuleImporter;
import com.android.tools.idea.ui.properties.core.BoolProperty;
import com.android.tools.idea.ui.properties.core.BoolValueProperty;
import com.android.tools.idea.ui.properties.core.ObservableBool;
import com.android.tools.idea.wizard.model.ModelWizardStep;
import com.android.tools.idea.wizard.model.WizardModel;
import com.intellij.ide.util.projectWizard.ModuleWizardStep;
import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.ide.wizard.CommitStepException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.ConfigurationException;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ModuleWizardStepAdapter
extends ModelWizardStep<AdapterModel> {
    @Nullable
    private static Logger ourLog;
    private final ModuleWizardStep myWrappedStep;
    private final WizardContext myContext;
    private final BoolProperty myCanGoForward;

    @NotNull
    private static Logger getLog() {
        if (ourLog == null) {
            ourLog = Logger.getInstance(ModuleWizardStepAdapter.class);
        }
        Logger logger = ourLog;
        if (logger == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/importing/ModuleWizardStepAdapter", "getLog"));
        }
        return logger;
    }

    static void setLog(Logger testLogger) {
        ourLog = testLogger;
    }

    public ModuleWizardStepAdapter(@NotNull WizardContext context, @NotNull ModuleWizardStep toWrap) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/android/tools/idea/npw/importing/ModuleWizardStepAdapter", "<init>"));
        }
        if (toWrap == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toWrap", "com/android/tools/idea/npw/importing/ModuleWizardStepAdapter", "<init>"));
        }
        super(new AdapterModel(toWrap), toWrap.getName());
        this.myCanGoForward = new BoolValueProperty();
        this.myContext = context;
        this.myWrappedStep = toWrap;
        this.myWrappedStep.registerStepListener(this::updateCanGoForward);
    }

    private void updateCanGoForward() {
        try {
            this.myCanGoForward.set(this.myWrappedStep.validate());
        }
        catch (ConfigurationException e) {
            this.myCanGoForward.set(false);
        }
    }

    @Override
    public void dispose() {
        this.myWrappedStep.disposeUIResources();
        super.dispose();
    }

    @Override
    @NotNull
    protected JComponent getComponent() {
        JComponent jComponent = this.myWrappedStep.getComponent();
        if (jComponent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/importing/ModuleWizardStepAdapter", "getComponent"));
        }
        return jComponent;
    }

    @Override
    protected boolean shouldShow() {
        if (ModuleImporter.getImporter(this.myContext).isStepVisible(this.myWrappedStep)) {
            return this.myWrappedStep.isStepVisible();
        }
        return false;
    }

    @Override
    protected void onEntering() {
        this.updateCanGoForward();
    }

    @Override
    protected void onProceeding() {
        this.myWrappedStep.updateDataModel();
        this.myWrappedStep.onStepLeaving();
    }

    @Override
    @NotNull
    protected ObservableBool canGoForward() {
        BoolProperty boolProperty = this.myCanGoForward;
        if (boolProperty == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/importing/ModuleWizardStepAdapter", "canGoForward"));
        }
        return boolProperty;
    }

    static class AdapterModel
    extends WizardModel {
        private final ModuleWizardStep myStep;

        public AdapterModel(@NotNull ModuleWizardStep step) {
            if (step == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "step", "com/android/tools/idea/npw/importing/ModuleWizardStepAdapter$AdapterModel", "<init>"));
            }
            this.myStep = step;
        }

        @Override
        protected void handleFinished() {
            try {
                this.myStep.onWizardFinished();
            }
            catch (CommitStepException e) {
                ModuleWizardStepAdapter.getLog().error(e.getMessage());
            }
        }
    }
}

