/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.platform;

import com.android.repository.api.Downloader;
import com.android.repository.api.ProgressIndicator;
import com.android.repository.api.ProgressRunner;
import com.android.repository.api.RemotePackage;
import com.android.repository.api.RepoManager;
import com.android.repository.api.RepoPackage;
import com.android.repository.impl.meta.TypeDetails;
import com.android.sdklib.AndroidTargetHash;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.SdkVersionInfo;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.sdklib.repository.IdDisplay;
import com.android.sdklib.repository.meta.DetailsTypes;
import com.android.sdklib.repository.targets.AndroidTargetManager;
import com.android.sdklib.repository.targets.SystemImage;
import com.android.tools.idea.npw.FormFactor;
import com.android.tools.idea.sdk.AndroidSdks;
import com.android.tools.idea.sdk.StudioDownloader;
import com.android.tools.idea.sdk.StudioSettingsController;
import com.android.tools.idea.sdk.progress.StudioLoggerProgressIndicator;
import com.android.tools.idea.sdk.progress.StudioProgressRunner;
import com.android.tools.idea.templates.TemplateMetadata;
import com.android.tools.idea.templates.TemplateUtils;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.android.sdk.AndroidSdkUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidVersionsInfo {
    private static final ProgressIndicator REPO_LOG = new StudioLoggerProgressIndicator(AndroidVersionsInfo.class);
    private static final IdDisplay NO_MATCH = IdDisplay.create((String)"no_match", (String)"No Match");
    private final List<VersionItem> myTargetVersions = Lists.newArrayList();
    private final Set<AndroidVersion> myInstalledVersions = Sets.newHashSet();
    private IAndroidTarget myHighestInstalledApiTarget;

    public void load() {
        this.loadTargetVersions();
        this.loadInstalledVersions();
    }

    public void loadInstalledVersions() {
        this.myInstalledVersions.clear();
        IAndroidTarget highestInstalledTarget = null;
        for (IAndroidTarget target : AndroidVersionsInfo.getCompilationTargets()) {
            if (target.isPlatform() && target.getVersion().getFeatureLevel() >= 22 && (highestInstalledTarget == null || target.getVersion().getFeatureLevel() > highestInstalledTarget.getVersion().getFeatureLevel() && !target.getVersion().isPreview())) {
                highestInstalledTarget = target;
            }
            if (!target.getVersion().isPreview() && target.getAdditionalLibraries().isEmpty()) continue;
            this.myInstalledVersions.add(target.getVersion());
        }
        this.myHighestInstalledApiTarget = highestInstalledTarget;
    }

    @Nullable(value="If we don't know (yet) the highest installed version")
    AndroidVersion getHighestInstalledVersion() {
        return this.myHighestInstalledApiTarget == null ? null : this.myHighestInstalledApiTarget.getVersion();
    }

    @NotNull
    public Collection<String> getInstallRequestPaths(VersionItem ... versionItems) {
        if (versionItems == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "versionItems", "com/android/tools/idea/npw/platform/AndroidVersionsInfo", "getInstallRequestPaths"));
        }
        HashSet res = Sets.newHashSet();
        for (VersionItem versionItem : versionItems) {
            AndroidVersion androidVersion = versionItem.myAndroidVersion;
            String platformPath = DetailsTypes.getPlatformPath((AndroidVersion)androidVersion);
            if (versionItem.myAddon != null) {
                res.add(versionItem.myAddon.getPath());
                AndroidTargetManager targetManager = AndroidSdks.getInstance().tryToChooseSdkHandler().getAndroidTargetManager(REPO_LOG);
                if (targetManager.getTargetFromHashString(AndroidTargetHash.getPlatformHashString((AndroidVersion)androidVersion), REPO_LOG) != null) continue;
                res.add(platformPath);
                continue;
            }
            if (this.myHighestInstalledApiTarget != null && (androidVersion.getApiLevel() <= this.myHighestInstalledApiTarget.getVersion().getApiLevel() || this.myInstalledVersions.contains(androidVersion))) continue;
            res.add(DetailsTypes.getPlatformPath((AndroidVersion)new AndroidVersion(25, null)));
        }
        HashSet hashSet = res;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/platform/AndroidVersionsInfo", "getInstallRequestPaths"));
        }
        return hashSet;
    }

    public void loadTargetVersions(@NotNull FormFactor formFactor, int minSdkLevel, ItemsLoaded itemsLoadedCallback) {
        if (formFactor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "formFactor", "com/android/tools/idea/npw/platform/AndroidVersionsInfo", "loadTargetVersions"));
        }
        ArrayList<VersionItem> versionItemList = new ArrayList<VersionItem>();
        for (VersionItem target : this.myTargetVersions) {
            if (!AndroidVersionsInfo.isFormFactorAvailable(formFactor, minSdkLevel, target.getApiLevel()) && (target.getAndroidTarget() == null || !target.getAndroidTarget().getVersion().isPreview())) continue;
            versionItemList.add(target);
        }
        this.loadRemoteTargets(formFactor, minSdkLevel, versionItemList, itemsLoadedCallback);
    }

    private void loadTargetVersions() {
        this.myTargetVersions.clear();
        if (AndroidSdkUtils.isAndroidSdkAvailable()) {
            String[] knownVersions = TemplateUtils.getKnownVersions();
            for (int i = 0; i < knownVersions.length; ++i) {
                this.myTargetVersions.add(new VersionItem(this, knownVersions[i], i + 1));
            }
        }
        for (IAndroidTarget target : AndroidVersionsInfo.getCompilationTargets()) {
            if (!target.getVersion().isPreview() && target.getAdditionalLibraries().isEmpty()) continue;
            this.myTargetVersions.add(new VersionItem(this, target));
        }
    }

    @NotNull
    private static IAndroidTarget[] getCompilationTargets() {
        AndroidTargetManager targetManager = AndroidSdks.getInstance().tryToChooseSdkHandler().getAndroidTargetManager(REPO_LOG);
        ArrayList result = Lists.newArrayList();
        for (IAndroidTarget target : targetManager.getTargets(REPO_LOG)) {
            if (!target.isPlatform()) continue;
            result.add(target);
        }
        IAndroidTarget[] iAndroidTargetArray = result.toArray(new IAndroidTarget[result.size()]);
        if (iAndroidTargetArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/platform/AndroidVersionsInfo", "getCompilationTargets"));
        }
        return iAndroidTargetArray;
    }

    private void loadRemoteTargets(@NotNull FormFactor myFormFactor, int minSdkLevel, @NotNull List<VersionItem> versionItemList, ItemsLoaded completedCallback) {
        if (myFormFactor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "myFormFactor", "com/android/tools/idea/npw/platform/AndroidVersionsInfo", "loadRemoteTargets"));
        }
        if (versionItemList == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "versionItemList", "com/android/tools/idea/npw/platform/AndroidVersionsInfo", "loadRemoteTargets"));
        }
        AndroidSdkHandler sdkHandler = AndroidSdks.getInstance().tryToChooseSdkHandler();
        Runnable runCallbacks = () -> {
            if (versionItemList == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "versionItemList", "com/android/tools/idea/npw/platform/AndroidVersionsInfo", "lambda$loadRemoteTargets$0"));
            }
            if (completedCallback != null) {
                completedCallback.onDataLoadedFinished(versionItemList);
            }
        };
        RepoManager.RepoLoadedCallback onComplete = packages -> {
            if (myFormFactor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "myFormFactor", "com/android/tools/idea/npw/platform/AndroidVersionsInfo", "lambda$loadRemoteTargets$1"));
            }
            if (versionItemList == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "versionItemList", "com/android/tools/idea/npw/platform/AndroidVersionsInfo", "lambda$loadRemoteTargets$1"));
            }
            this.addPackages(myFormFactor, versionItemList, packages.getNewPkgs(), minSdkLevel);
            this.addOfflineLevels(myFormFactor, versionItemList);
            runCallbacks.run();
        };
        RepoManager.RepoLoadedCallback onLocalComplete = packages -> {
            if (myFormFactor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "myFormFactor", "com/android/tools/idea/npw/platform/AndroidVersionsInfo", "lambda$loadRemoteTargets$2"));
            }
            if (versionItemList == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "versionItemList", "com/android/tools/idea/npw/platform/AndroidVersionsInfo", "lambda$loadRemoteTargets$2"));
            }
            this.addPackages(myFormFactor, versionItemList, packages.getLocalPackages().values(), minSdkLevel);
        };
        Runnable onError = () -> {
            if (myFormFactor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "myFormFactor", "com/android/tools/idea/npw/platform/AndroidVersionsInfo", "lambda$loadRemoteTargets$4"));
            }
            if (versionItemList == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "versionItemList", "com/android/tools/idea/npw/platform/AndroidVersionsInfo", "lambda$loadRemoteTargets$4"));
            }
            ApplicationManager.getApplication().invokeLater(() -> {
                if (myFormFactor == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "myFormFactor", "com/android/tools/idea/npw/platform/AndroidVersionsInfo", "lambda$null$3"));
                }
                if (versionItemList == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "versionItemList", "com/android/tools/idea/npw/platform/AndroidVersionsInfo", "lambda$null$3"));
                }
                this.addOfflineLevels(myFormFactor, versionItemList);
                runCallbacks.run();
            }, ModalityState.any());
        };
        StudioProgressRunner runner = new StudioProgressRunner(false, false, "Refreshing Targets", true, null);
        sdkHandler.getSdkManager(REPO_LOG).load(RepoManager.DEFAULT_EXPIRATION_PERIOD_MS, (List)ImmutableList.of((Object)onLocalComplete), (List)ImmutableList.of((Object)onComplete), (List)ImmutableList.of((Object)onError), (ProgressRunner)runner, (Downloader)new StudioDownloader(), StudioSettingsController.getInstance(), false);
    }

    private static boolean filterPkgDesc(@NotNull RepoPackage p, @NotNull FormFactor formFactor, int minSdkLevel) {
        if (p == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "p", "com/android/tools/idea/npw/platform/AndroidVersionsInfo", "filterPkgDesc"));
        }
        if (formFactor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "formFactor", "com/android/tools/idea/npw/platform/AndroidVersionsInfo", "filterPkgDesc"));
        }
        return AndroidVersionsInfo.isApiType(p) && AndroidVersionsInfo.doFilter(formFactor, minSdkLevel, AndroidVersionsInfo.getTag(p), AndroidVersionsInfo.getFeatureLevel(p));
    }

    private static boolean doFilter(@NotNull FormFactor formFactor, int minSdkLevel, @Nullable IdDisplay tag, int targetSdkLevel) {
        if (formFactor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "formFactor", "com/android/tools/idea/npw/platform/AndroidVersionsInfo", "doFilter"));
        }
        return formFactor.isSupported(tag, targetSdkLevel) && targetSdkLevel >= minSdkLevel;
    }

    private static boolean isApiType(@NotNull RepoPackage repoPackage) {
        if (repoPackage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repoPackage", "com/android/tools/idea/npw/platform/AndroidVersionsInfo", "isApiType"));
        }
        return repoPackage.getTypeDetails() instanceof DetailsTypes.ApiDetailsType;
    }

    private static int getFeatureLevel(@NotNull RepoPackage repoPackage) {
        if (repoPackage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repoPackage", "com/android/tools/idea/npw/platform/AndroidVersionsInfo", "getFeatureLevel"));
        }
        return AndroidVersionsInfo.getAndroidVersion(repoPackage).getFeatureLevel();
    }

    private static boolean isFormFactorAvailable(@NotNull FormFactor formFactor, int minSdkLevel, int targetSdkLevel) {
        if (formFactor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "formFactor", "com/android/tools/idea/npw/platform/AndroidVersionsInfo", "isFormFactorAvailable"));
        }
        return AndroidVersionsInfo.doFilter(formFactor, minSdkLevel, SystemImage.DEFAULT_TAG, targetSdkLevel);
    }

    @NotNull
    private static AndroidVersion getAndroidVersion(@NotNull RepoPackage repoPackage) {
        if (repoPackage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repoPackage", "com/android/tools/idea/npw/platform/AndroidVersionsInfo", "getAndroidVersion"));
        }
        TypeDetails details = repoPackage.getTypeDetails();
        if (details instanceof DetailsTypes.ApiDetailsType) {
            AndroidVersion androidVersion = ((DetailsTypes.ApiDetailsType)details).getAndroidVersion();
            if (androidVersion == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/platform/AndroidVersionsInfo", "getAndroidVersion"));
            }
            return androidVersion;
        }
        throw new RuntimeException("Could not determine version");
    }

    @Nullable
    private static IdDisplay getTag(@NotNull RepoPackage repoPackage) {
        DetailsTypes.SysImgDetailsType imgDetailsType;
        if (repoPackage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repoPackage", "com/android/tools/idea/npw/platform/AndroidVersionsInfo", "getTag"));
        }
        TypeDetails details = repoPackage.getTypeDetails();
        IdDisplay tag = NO_MATCH;
        if (details instanceof DetailsTypes.AddonDetailsType) {
            tag = ((DetailsTypes.AddonDetailsType)details).getTag();
        }
        if (details instanceof DetailsTypes.SysImgDetailsType && (imgDetailsType = (DetailsTypes.SysImgDetailsType)details).getAbi().equals("x86")) {
            tag = imgDetailsType.getTag();
        }
        return tag;
    }

    private void addPackages(@NotNull FormFactor myFormFactor, @NotNull List<VersionItem> versionItemList, @NotNull Collection<? extends RepoPackage> packages, int minSdkLevel) {
        if (myFormFactor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "myFormFactor", "com/android/tools/idea/npw/platform/AndroidVersionsInfo", "addPackages"));
        }
        if (versionItemList == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "versionItemList", "com/android/tools/idea/npw/platform/AndroidVersionsInfo", "addPackages"));
        }
        if (packages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packages", "com/android/tools/idea/npw/platform/AndroidVersionsInfo", "addPackages"));
        }
        List sorted = packages.stream().filter(repoPackage -> {
            if (myFormFactor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "myFormFactor", "com/android/tools/idea/npw/platform/AndroidVersionsInfo", "lambda$addPackages$5"));
            }
            return repoPackage != null && AndroidVersionsInfo.filterPkgDesc(repoPackage, myFormFactor, minSdkLevel);
        }).collect(Collectors.toList());
        Collections.sort(sorted, (repoPackage, other) -> AndroidVersionsInfo.getAndroidVersion(repoPackage).compareTo(AndroidVersionsInfo.getAndroidVersion(other)));
        int existingApiLevel = -1;
        int prevInsertedApiLevel = -1;
        int index = -1;
        for (RepoPackage info : sorted) {
            int apiLevel = AndroidVersionsInfo.getFeatureLevel(info);
            while (apiLevel > existingApiLevel) {
                existingApiLevel = ++index < versionItemList.size() ? versionItemList.get(index).myApiLevel : Integer.MAX_VALUE;
            }
            if (apiLevel == existingApiLevel || apiLevel == prevInsertedApiLevel) continue;
            versionItemList.add(index++, new VersionItem(this, info));
            prevInsertedApiLevel = apiLevel;
        }
    }

    private void addOfflineLevels(@NotNull FormFactor myFormFactor, @NotNull List<VersionItem> versionItemList) {
        if (myFormFactor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "myFormFactor", "com/android/tools/idea/npw/platform/AndroidVersionsInfo", "addOfflineLevels"));
        }
        if (versionItemList == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "versionItemList", "com/android/tools/idea/npw/platform/AndroidVersionsInfo", "addOfflineLevels"));
        }
        int existingApiLevel = -1;
        int prevInsertedApiLevel = -1;
        int index = -1;
        for (int apiLevel = myFormFactor.getMinOfflineApiLevel(); apiLevel <= myFormFactor.getMaxOfflineApiLevel(); ++apiLevel) {
            if (myFormFactor.isSupported(null, apiLevel) || apiLevel <= 0) continue;
            while (apiLevel > existingApiLevel) {
                existingApiLevel = ++index < versionItemList.size() ? versionItemList.get(index).myApiLevel : Integer.MAX_VALUE;
            }
            if (apiLevel == existingApiLevel || apiLevel == prevInsertedApiLevel) continue;
            versionItemList.add(index++, new VersionItem(this, apiLevel));
            prevInsertedApiLevel = apiLevel;
        }
    }

    public class VersionItem {
        private final AndroidVersion myAndroidVersion;
        private final String myLabel;
        private final int myApiLevel;
        private final String myApiLevelStr;
        private IAndroidTarget myAndroidTarget;
        private RemotePackage myAddon;
        final /* synthetic */ AndroidVersionsInfo this$0;

        VersionItem(@NotNull AndroidVersionsInfo this$0, @NotNull AndroidVersion androidVersion, IdDisplay tag) {
            if (androidVersion == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "androidVersion", "com/android/tools/idea/npw/platform/AndroidVersionsInfo$VersionItem", "<init>"));
            }
            if (tag == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tag", "com/android/tools/idea/npw/platform/AndroidVersionsInfo$VersionItem", "<init>"));
            }
            this.this$0 = this$0;
            this.myAndroidVersion = androidVersion;
            this.myLabel = this.getLabel(androidVersion, tag);
            this.myApiLevel = androidVersion.getFeatureLevel();
            this.myApiLevelStr = androidVersion.getApiString();
        }

        VersionItem(@NotNull AndroidVersionsInfo this$0, String label, int apiLevel) {
            if (label == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "label", "com/android/tools/idea/npw/platform/AndroidVersionsInfo$VersionItem", "<init>"));
            }
            this.this$0 = this$0;
            this.myAndroidVersion = new AndroidVersion(apiLevel, null);
            this.myLabel = label;
            this.myApiLevel = apiLevel;
            this.myApiLevelStr = Integer.toString(apiLevel);
        }

        VersionItem(AndroidVersionsInfo this$0, int apiLevel) {
            this(this$0, new AndroidVersion(apiLevel, null), SystemImage.DEFAULT_TAG);
        }

        VersionItem(@NotNull AndroidVersionsInfo this$0, IAndroidTarget target) {
            if (target == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "com/android/tools/idea/npw/platform/AndroidVersionsInfo$VersionItem", "<init>"));
            }
            this(this$0, target.getVersion(), SystemImage.DEFAULT_TAG);
            this.myAndroidTarget = target;
        }

        VersionItem(@NotNull AndroidVersionsInfo this$0, RepoPackage info) {
            if (info == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/android/tools/idea/npw/platform/AndroidVersionsInfo$VersionItem", "<init>"));
            }
            this(this$0, AndroidVersionsInfo.getAndroidVersion(info), AndroidVersionsInfo.getTag(info));
            if (info instanceof RemotePackage && SystemImage.GLASS_TAG.equals((Object)AndroidVersionsInfo.getTag(info))) {
                this.myAddon = (RemotePackage)info;
            }
        }

        @Nullable(value="null except for preview releases")
        public IAndroidTarget getAndroidTarget() {
            return this.myAndroidTarget;
        }

        @Nullable(value="null except when an addon needs to be installed (eg Google Glass)")
        public RemotePackage getAddon() {
            return this.myAddon;
        }

        public int getApiLevel() {
            return this.myApiLevel;
        }

        @NotNull
        public String getApiLevelStr() {
            String string = this.myApiLevelStr;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/platform/AndroidVersionsInfo$VersionItem", "getApiLevelStr"));
            }
            return string;
        }

        public int getBuildApiLevel() {
            int apiLevel = this.myAddon != null ? this.myApiLevel : (this.myAndroidTarget == null ? 25 : (this.myAndroidTarget.getVersion().isPreview() || !this.myAndroidTarget.isPlatform() ? this.myApiLevel : (this.this$0.getHighestInstalledVersion() == null ? 0 : this.this$0.getHighestInstalledVersion().getFeatureLevel())));
            return apiLevel;
        }

        @NotNull
        public String getBuildApiLevelStr() {
            if (this.myAndroidTarget == null) {
                String string = Integer.toString(this.getBuildApiLevel());
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/platform/AndroidVersionsInfo$VersionItem", "getBuildApiLevelStr"));
                }
                return string;
            }
            if (this.myAndroidTarget.isPlatform()) {
                String string = TemplateMetadata.getBuildApiString(this.myAndroidTarget.getVersion());
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/platform/AndroidVersionsInfo$VersionItem", "getBuildApiLevelStr"));
                }
                return string;
            }
            String string = AndroidTargetHash.getTargetHashString((IAndroidTarget)this.myAndroidTarget);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/platform/AndroidVersionsInfo$VersionItem", "getBuildApiLevelStr"));
            }
            return string;
        }

        public int getTargetApiLevel() {
            int buildApiLevel = this.getBuildApiLevel();
            if (buildApiLevel >= 25 || this.myAndroidTarget != null && this.myAndroidTarget.getVersion().isPreview()) {
                return buildApiLevel;
            }
            return this.this$0.getHighestInstalledVersion() == null ? 0 : this.this$0.getHighestInstalledVersion().getApiLevel();
        }

        @NotNull
        public String getTargetApiLevelStr() {
            int buildApiLevel = this.getBuildApiLevel();
            if (buildApiLevel >= 25 || this.myAndroidTarget != null && this.myAndroidTarget.getVersion().isPreview()) {
                String string = this.myAndroidTarget == null ? Integer.toString(buildApiLevel) : this.myAndroidTarget.getVersion().getApiString();
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/platform/AndroidVersionsInfo$VersionItem", "getTargetApiLevelStr"));
                }
                return string;
            }
            String string = this.this$0.getHighestInstalledVersion() == null ? "" : this.this$0.getHighestInstalledVersion().getApiString();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/platform/AndroidVersionsInfo$VersionItem", "getTargetApiLevelStr"));
            }
            return string;
        }

        @NotNull
        public String getLabel() {
            String string = this.myLabel;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/platform/AndroidVersionsInfo$VersionItem", "getLabel"));
            }
            return string;
        }

        @NotNull
        private String getLabel(@NotNull AndroidVersion version, @Nullable IdDisplay tag) {
            if (version == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "version", "com/android/tools/idea/npw/platform/AndroidVersionsInfo$VersionItem", "getLabel"));
            }
            int featureLevel = version.getFeatureLevel();
            if (SystemImage.GLASS_TAG.equals((Object)tag)) {
                String string = String.format("Glass Development Kit Preview (API %1$d)", featureLevel);
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/platform/AndroidVersionsInfo$VersionItem", "getLabel"));
                }
                return string;
            }
            if (featureLevel <= 25) {
                if (version.isPreview()) {
                    String string = String.format("API %1$s: Android %2$s (%3$s preview)", SdkVersionInfo.getCodeName((int)featureLevel), SdkVersionInfo.getVersionString((int)featureLevel), SdkVersionInfo.getCodeName((int)featureLevel));
                    if (string == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/platform/AndroidVersionsInfo$VersionItem", "getLabel"));
                    }
                    return string;
                }
                String string = SdkVersionInfo.getAndroidName((int)featureLevel);
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/platform/AndroidVersionsInfo$VersionItem", "getLabel"));
                }
                return string;
            }
            if (version.isPreview()) {
                String string = String.format("API %1$d: Android (%2$s)", featureLevel, version.getCodename());
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/platform/AndroidVersionsInfo$VersionItem", "getLabel"));
                }
                return string;
            }
            String string = String.format("API %1$d: Android", featureLevel);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/platform/AndroidVersionsInfo$VersionItem", "getLabel"));
            }
            return string;
        }

        public String toString() {
            return this.myLabel;
        }
    }

    public static interface ItemsLoaded {
        public void onDataLoadedFinished(List<VersionItem> var1);
    }
}

