/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.project;

import com.android.tools.adtui.LabelWithEditLink;
import com.android.tools.idea.npw.project.DomainToPackageExpression;
import com.android.tools.idea.npw.project.NewProjectModel;
import com.android.tools.idea.ui.properties.BindingsManager;
import com.android.tools.idea.ui.properties.ListenerManager;
import com.android.tools.idea.ui.properties.core.BoolValueProperty;
import com.android.tools.idea.ui.properties.core.ObservableBool;
import com.android.tools.idea.ui.properties.core.OptionalValueProperty;
import com.android.tools.idea.ui.properties.expressions.Expression;
import com.android.tools.idea.ui.properties.swing.SelectedProperty;
import com.android.tools.idea.ui.properties.swing.TextProperty;
import com.android.tools.idea.ui.validation.Validator;
import com.android.tools.idea.ui.validation.ValidatorPanel;
import com.android.tools.idea.ui.validation.validators.PathValidator;
import com.android.tools.idea.ui.wizard.StudioWizardStepPanel;
import com.android.tools.idea.ui.wizard.WizardUtils;
import com.android.tools.idea.wizard.model.ModelWizardStep;
import com.android.tools.swing.util.FormScalingUtil;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.File;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConfigureAndroidProjectStep
extends ModelWizardStep<NewProjectModel> {
    private final StudioWizardStepPanel myRootPanel;
    private final ValidatorPanel myValidatorPanel;
    private final BindingsManager myBindings;
    private final ListenerManager myListeners;
    private TextFieldWithBrowseButton myProjectLocation;
    private JTextField myAppName;
    private JPanel myPanel;
    private JTextField myCompanyDomain;
    private LabelWithEditLink myPackageName;
    private JCheckBox myCppSupportCheck;

    public ConfigureAndroidProjectStep(NewProjectModel model) {
        super(model, "Create Android Project");
        this.$$$setupUI$$$();
        this.myBindings = new BindingsManager();
        this.myListeners = new ListenerManager();
        TextProperty packageNameText = new TextProperty(this.myPackageName);
        DomainToPackageExpression computedPackageName = new DomainToPackageExpression(model.companyDomain(), model.applicationName());
        BoolValueProperty isPackageSynced = new BoolValueProperty(true);
        this.myBindings.bind(packageNameText, computedPackageName, isPackageSynced);
        this.myBindings.bind(model.packageName(), packageNameText);
        this.myListeners.receive(packageNameText, value -> isPackageSynced.set(value.equals(computedPackageName.get())));
        Expression<String> computedLocation = model.applicationName().transform(ConfigureAndroidProjectStep::findProjectLocation);
        TextProperty locationText = new TextProperty((JTextComponent)this.myProjectLocation.getChildComponent());
        BoolValueProperty isLocationSynced = new BoolValueProperty(true);
        this.myBindings.bind(locationText, computedLocation, isLocationSynced);
        this.myBindings.bind(model.projectLocation(), locationText);
        this.myListeners.receive(locationText, value -> isLocationSynced.set(value.equals(computedLocation.get())));
        this.myBindings.bindTwoWay(new TextProperty(this.myAppName), model.applicationName());
        this.myBindings.bindTwoWay(new TextProperty(this.myCompanyDomain), model.companyDomain());
        this.myBindings.bindTwoWay(new SelectedProperty(this.myCppSupportCheck), model.enableCppSupport());
        this.myProjectLocation.addActionListener(event -> {
            String finalPath = ConfigureAndroidProjectStep.browseForFile(locationText.get());
            if (finalPath != null) {
                locationText.set(finalPath);
            }
        });
        this.myValidatorPanel = new ValidatorPanel(this, this.myPanel);
        this.myValidatorPanel.registerValidator(model.applicationName(), value -> {
            if (value.isEmpty()) {
                return new Validator.Result(Validator.Severity.ERROR, "Please enter an application name");
            }
            if (!Character.isUpperCase(value.charAt(0))) {
                return new Validator.Result(Validator.Severity.INFO, "The application name for most apps begins with an uppercase letter");
            }
            return Validator.Result.OK;
        });
        Expression<File> locationFile = model.projectLocation().transform(File::new);
        this.myValidatorPanel.registerValidator(locationFile, PathValidator.createDefault("project location"));
        this.myValidatorPanel.registerValidator(model.packageName(), value -> Validator.Result.fromNullableMessage(WizardUtils.validatePackageName(value)));
        this.myRootPanel = new StudioWizardStepPanel(this.myValidatorPanel, "Configure your new project");
        FormScalingUtil.scaleComponentTree(this.getClass(), this.myRootPanel);
    }

    @Override
    public void dispose() {
        this.myBindings.releaseAll();
        this.myListeners.releaseAll();
    }

    @Override
    @NotNull
    protected JComponent getComponent() {
        StudioWizardStepPanel studioWizardStepPanel = this.myRootPanel;
        if (studioWizardStepPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/project/ConfigureAndroidProjectStep", "getComponent"));
        }
        return studioWizardStepPanel;
    }

    @Override
    @NotNull
    protected ObservableBool canGoForward() {
        ObservableBool observableBool = this.myValidatorPanel.hasErrors().not();
        if (observableBool == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/project/ConfigureAndroidProjectStep", "canGoForward"));
        }
        return observableBool;
    }

    @NotNull
    private static String findProjectLocation(@NotNull String applicationName) {
        if (applicationName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "applicationName", "com/android/tools/idea/npw/project/ConfigureAndroidProjectStep", "findProjectLocation"));
        }
        applicationName = NewProjectModel.sanitizeApplicationName(applicationName);
        File baseDirectory = WizardUtils.getProjectLocationParent();
        File projectDirectory = new File(baseDirectory, applicationName);
        int counter = 2;
        while (projectDirectory.exists()) {
            projectDirectory = new File(baseDirectory, String.format("%s%d", applicationName, counter++));
        }
        String string = projectDirectory.getPath();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/project/ConfigureAndroidProjectStep", "findProjectLocation"));
        }
        return string;
    }

    @Nullable
    private static String browseForFile(@NotNull String initialPath) {
        if (initialPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "initialPath", "com/android/tools/idea/npw/project/ConfigureAndroidProjectStep", "browseForFile"));
        }
        FileChooserDescriptor fileSaverDescriptor = FileChooserDescriptorFactory.createSingleFolderDescriptor();
        File currentPath = new File(initialPath);
        File parentPath = currentPath.getParentFile();
        if (parentPath == null) {
            String homePath = System.getProperty("user.home");
            parentPath = new File(homePath == null ? File.separator : homePath);
        }
        VirtualFile parent = LocalFileSystem.getInstance().findFileByIoFile(parentPath);
        OptionalValueProperty finalPath = new OptionalValueProperty();
        FileChooser.chooseFiles((FileChooserDescriptor)fileSaverDescriptor, null, (VirtualFile)parent, virtualFiles -> {
            String result;
            if (virtualFiles.size() == 1 && (result = ((VirtualFile)virtualFiles.iterator().next()).getCanonicalPath()) != null) {
                finalPath.setValue(result);
            }
        });
        return (String)finalPath.getValueOrNull();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        LabelWithEditLink labelWithEditLink;
        JTextField jTextField;
        JTextField jTextField2;
        JPanel jPanel;
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(7, 2, new Insets(0, 5, 0, 0), -1, -1, false, false));
        JLabel jLabel = new JLabel();
        jLabel.setText("Application name:");
        jLabel.setDisplayedMnemonic('A');
        jLabel.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myAppName = jTextField2 = new JTextField();
        jTextField2.setToolTipText("The name that will be shown in the Android launcher for this application");
        jPanel.add((Component)jTextField2, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JLabel jLabel2 = new JLabel();
        jLabel2.setText("Company domain:");
        jLabel2.setDisplayedMnemonic('C');
        jLabel2.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jLabel2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myCompanyDomain = jTextField = new JTextField();
        jPanel.add((Component)jTextField, new GridConstraints(1, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JLabel jLabel3 = new JLabel();
        jLabel3.setText("Package name:");
        jPanel.add((Component)jLabel3, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myPackageName = labelWithEditLink = new LabelWithEditLink();
        jPanel.add((Component)labelWithEditLink, new GridConstraints(2, 1, 1, 1, 0, 1, 3, 3, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(4, 1, 1, 1, 0, 2, 1, 6, null, null, null));
        JLabel jLabel4 = new JLabel();
        jLabel4.setText("Project location:");
        jPanel.add((Component)jLabel4, new GridConstraints(5, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myProjectLocation = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel.add((Component)textFieldWithBrowseButton, new GridConstraints(5, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        Spacer spacer2 = new Spacer();
        jPanel.add((Component)spacer2, new GridConstraints(6, 1, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myCppSupportCheck = jCheckBox = new JCheckBox();
        jCheckBox.setText("Include C++ support");
        jPanel.add((Component)jCheckBox, new GridConstraints(3, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        jLabel.setLabelFor(jTextField2);
        jLabel2.setLabelFor(jTextField);
        jLabel3.setLabelFor((Component)labelWithEditLink);
        jLabel4.setLabelFor((Component)textFieldWithBrowseButton);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }
}

