/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.project;

import com.android.tools.idea.ui.properties.core.BoolProperty;
import com.android.tools.idea.ui.properties.core.BoolValueProperty;
import com.android.tools.idea.ui.properties.core.StringProperty;
import com.android.tools.idea.ui.properties.core.StringValueProperty;
import com.android.tools.idea.wizard.model.WizardModel;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Locale;
import java.util.regex.Pattern;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.annotations.NotNull;

public class NewProjectModel
extends WizardModel {
    private static final String PROPERTIES_DOMAIN_KEY = "SAVED_COMPANY_DOMAIN";
    private static final String EXAMPLE_DOMAIN = "example.com";
    private static final Pattern DISALLOWED_IN_DOMAIN = Pattern.compile("[^a-zA-Z0-9_]");
    private final StringProperty myApplicationName = new StringValueProperty("My Application");
    private final StringProperty myCompanyDomain = new StringValueProperty(NewProjectModel.getInitialDomain(true));
    private final StringProperty myPackageName = new StringValueProperty();
    private final StringProperty myProjectLocation = new StringValueProperty();
    private final BoolProperty myEnableCppSupport = new BoolValueProperty(false);

    public NewProjectModel() {
        this.myCompanyDomain.addListener(sender -> {
            String domain = (String)this.myCompanyDomain.get();
            if (AndroidUtils.isValidAndroidPackageName(domain)) {
                PropertiesComponent.getInstance().setValue(PROPERTIES_DOMAIN_KEY, domain);
            }
        });
    }

    public StringProperty packageName() {
        return this.myPackageName;
    }

    public StringProperty applicationName() {
        return this.myApplicationName;
    }

    public StringProperty companyDomain() {
        return this.myCompanyDomain;
    }

    public StringProperty projectLocation() {
        return this.myProjectLocation;
    }

    public BoolProperty enableCppSupport() {
        return this.myEnableCppSupport;
    }

    @NotNull
    public static String getInitialDomain(boolean includeUserName) {
        String domain = PropertiesComponent.getInstance().getValue(PROPERTIES_DOMAIN_KEY);
        if (domain != null) {
            String string = domain;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/project/NewProjectModel", "getInitialDomain"));
            }
            return string;
        }
        String userName = includeUserName ? System.getProperty("user.name") : null;
        String string = userName == null ? EXAMPLE_DOMAIN : NewProjectModel.toPackagePart(userName) + '.' + EXAMPLE_DOMAIN;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/project/NewProjectModel", "getInitialDomain"));
        }
        return string;
    }

    @NotNull
    public static String toPackagePart(@NotNull String s) {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/android/tools/idea/npw/project/NewProjectModel", "toPackagePart"));
        }
        String name = DISALLOWED_IN_DOMAIN.matcher(s = s.replace('-', '_')).replaceAll("").toLowerCase(Locale.US);
        if (!name.isEmpty() && AndroidUtils.isReservedKeyword(name) != null) {
            name = StringUtil.fixVariableNameDerivedFromPropertyName((String)name).toLowerCase(Locale.US);
        }
        String string = name;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/project/NewProjectModel", "toPackagePart"));
        }
        return string;
    }

    @NotNull
    public static String sanitizeApplicationName(@NotNull String s) {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/android/tools/idea/npw/project/NewProjectModel", "sanitizeApplicationName"));
        }
        String string = DISALLOWED_IN_DOMAIN.matcher(s).replaceAll("");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/project/NewProjectModel", "sanitizeApplicationName"));
        }
        return string;
    }

    @Override
    protected void handleFinished() {
    }
}

