/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.activity;

import com.android.ddmlib.IDevice;
import com.android.tools.idea.model.MergedManifest;
import com.android.tools.idea.run.activity.ActivityLocator;
import com.android.tools.idea.run.activity.ActivityLocatorUtils;
import com.google.common.collect.Lists;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.android.dom.AndroidAttributeValue;
import org.jetbrains.android.dom.AndroidDomUtil;
import org.jetbrains.android.dom.manifest.Activity;
import org.jetbrains.android.dom.manifest.ActivityAlias;
import org.jetbrains.android.dom.manifest.Application;
import org.jetbrains.android.dom.manifest.IntentFilter;
import org.jetbrains.android.dom.manifest.Manifest;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DefaultActivityLocator
extends ActivityLocator {
    @NotNull
    private final AndroidFacet myFacet;

    public DefaultActivityLocator(@NotNull AndroidFacet facet) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/android/tools/idea/run/activity/DefaultActivityLocator", "<init>"));
        }
        this.myFacet = facet;
    }

    @Override
    @NotNull
    public String getQualifiedActivityName(@NotNull IDevice device) throws ActivityLocator.ActivityLocatorException {
        if (device == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "device", "com/android/tools/idea/run/activity/DefaultActivityLocator", "getQualifiedActivityName"));
        }
        String activity = DefaultActivityLocator.computeDefaultActivity(this.myFacet, device);
        if (activity == null) {
            throw new ActivityLocator.ActivityLocatorException(AndroidBundle.message("default.activity.not.found.error", new Object[0]));
        }
        String string = activity;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/run/activity/DefaultActivityLocator", "getQualifiedActivityName"));
        }
        return string;
    }

    @Override
    public void validate() throws ActivityLocator.ActivityLocatorException {
        String activity = DefaultActivityLocator.computeDefaultActivity(this.myFacet, null);
        if (activity == null) {
            throw new ActivityLocator.ActivityLocatorException(AndroidBundle.message("default.activity.not.found.error", new Object[0]));
        }
    }

    @Nullable
    static String computeDefaultActivity(@NotNull AndroidFacet facet, @Nullable IDevice device) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/android/tools/idea/run/activity/DefaultActivityLocator", "computeDefaultActivity"));
        }
        assert (!facet.getProperties().USE_CUSTOM_COMPILER_MANIFEST);
        MergedManifest mergedManifest = MergedManifest.get(facet);
        return (String)DumbService.getInstance((Project)facet.getModule().getProject()).runReadActionInSmartMode(() -> DefaultActivityLocator.computeDefaultActivity(ActivityWrapper.get(mergedManifest.getActivities(), mergedManifest.getActivityAliases()), device));
    }

    @Nullable
    public static String getDefaultLauncherActivityName(@NotNull Project project, @NotNull Manifest manifest) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/run/activity/DefaultActivityLocator", "getDefaultLauncherActivityName"));
        }
        if (manifest == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manifest", "com/android/tools/idea/run/activity/DefaultActivityLocator", "getDefaultLauncherActivityName"));
        }
        if (!ApplicationManager.getApplication().isReadAccessAllowed()) {
            return (String)DumbService.getInstance((Project)project).runReadActionInSmartMode(() -> {
                if (project == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/run/activity/DefaultActivityLocator", "lambda$getDefaultLauncherActivityName$1"));
                }
                if (manifest == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manifest", "com/android/tools/idea/run/activity/DefaultActivityLocator", "lambda$getDefaultLauncherActivityName$1"));
                }
                return DefaultActivityLocator.getDefaultLauncherActivityName(project, manifest);
            });
        }
        Application application = manifest.getApplication();
        if (application == null) {
            return null;
        }
        if (!ApplicationManager.getApplication().isUnitTestMode() && DumbService.isDumb((Project)project)) {
            Logger.getInstance(DefaultActivityLocator.class).warn("Cannot locate default activity when indices are not available");
            return null;
        }
        return DefaultActivityLocator.computeDefaultActivity(DefaultActivityLocator.merge(application.getActivities(), application.getActivityAliases()), null);
    }

    @Nullable
    private static String computeDefaultActivity(@NotNull List<ActivityWrapper> activities, @Nullable IDevice device) {
        ActivityWrapper activity;
        if (activities == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "activities", "com/android/tools/idea/run/activity/DefaultActivityLocator", "computeDefaultActivity"));
        }
        List<ActivityWrapper> launchableActivities = DefaultActivityLocator.getLaunchableActivities(activities);
        if (launchableActivities.isEmpty()) {
            return null;
        }
        if (launchableActivities.size() == 1) {
            return launchableActivities.get(0).getQualifiedName();
        }
        if (device != null && (activity = DefaultActivityLocator.findLauncherActivityForDevice(launchableActivities, device)) != null) {
            return activity.getQualifiedName();
        }
        ActivityWrapper defaultLauncher = DefaultActivityLocator.findDefaultLauncher(launchableActivities);
        if (defaultLauncher != null) {
            return defaultLauncher.getQualifiedName();
        }
        return launchableActivities.isEmpty() ? null : launchableActivities.get(0).getQualifiedName();
    }

    @Nullable
    private static ActivityWrapper findLauncherActivityForDevice(@NotNull List<ActivityWrapper> launchableActivities, @NotNull IDevice device) {
        if (launchableActivities == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "launchableActivities", "com/android/tools/idea/run/activity/DefaultActivityLocator", "findLauncherActivityForDevice"));
        }
        if (device == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "device", "com/android/tools/idea/run/activity/DefaultActivityLocator", "findLauncherActivityForDevice"));
        }
        if (device.supportsFeature(IDevice.HardwareFeature.TV)) {
            return DefaultActivityLocator.findLeanbackLauncher(launchableActivities);
        }
        return null;
    }

    @Nullable
    private static ActivityWrapper findLeanbackLauncher(@NotNull List<ActivityWrapper> launcherActivities) {
        if (launcherActivities == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "launcherActivities", "com/android/tools/idea/run/activity/DefaultActivityLocator", "findLeanbackLauncher"));
        }
        for (ActivityWrapper activity : launcherActivities) {
            if (!activity.hasCategory("android.intent.category.LEANBACK_LAUNCHER")) continue;
            return activity;
        }
        return null;
    }

    @Nullable
    private static ActivityWrapper findDefaultLauncher(@NotNull List<ActivityWrapper> launcherActivities) {
        if (launcherActivities == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "launcherActivities", "com/android/tools/idea/run/activity/DefaultActivityLocator", "findDefaultLauncher"));
        }
        for (ActivityWrapper activity : launcherActivities) {
            if (!activity.hasCategory("android.intent.category.DEFAULT")) continue;
            return activity;
        }
        return null;
    }

    @NotNull
    private static List<ActivityWrapper> getLaunchableActivities(@NotNull List<ActivityWrapper> allActivities) {
        if (allActivities == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "allActivities", "com/android/tools/idea/run/activity/DefaultActivityLocator", "getLaunchableActivities"));
        }
        List<ActivityWrapper> list = allActivities.stream().filter(activity -> ActivityLocatorUtils.containsLauncherIntent(activity) && activity.isEnabled()).collect(Collectors.toList());
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/run/activity/DefaultActivityLocator", "getLaunchableActivities"));
        }
        return list;
    }

    private static List<ActivityWrapper> merge(List<Activity> activities, List<ActivityAlias> activityAliases) {
        ArrayList activityWrappers = Lists.newArrayListWithExpectedSize((int)(activities.size() + activityAliases.size()));
        for (Activity activity : activities) {
            activityWrappers.add(ActivityWrapper.get(activity));
        }
        for (ActivityAlias activityAlias : activityAliases) {
            activityWrappers.add(ActivityWrapper.get(activityAlias));
        }
        return activityWrappers;
    }

    private static class ElementActivityWrapper
    extends ActivityWrapper {
        private final Element myActivity;

        public ElementActivityWrapper(Element activity) {
            this.myActivity = activity;
        }

        @Override
        public boolean hasCategory(@NotNull String name) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/run/activity/DefaultActivityLocator$ElementActivityWrapper", "hasCategory"));
            }
            for (Node node = this.myActivity.getFirstChild(); node != null; node = node.getNextSibling()) {
                Element filter;
                if (node.getNodeType() != 1 || !"intent-filter".equals(node.getNodeName()) || !ActivityLocatorUtils.containsCategory(filter = (Element)node, name)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean hasAction(@NotNull String name) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/run/activity/DefaultActivityLocator$ElementActivityWrapper", "hasAction"));
            }
            for (Node node = this.myActivity.getFirstChild(); node != null; node = node.getNextSibling()) {
                Element filter;
                if (node.getNodeType() != 1 || !"intent-filter".equals(node.getNodeName()) || !ActivityLocatorUtils.containsAction(filter = (Element)node, name)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean isEnabled() {
            String enabledAttr = this.myActivity.getAttributeNS("http://schemas.android.com/apk/res/android", "enabled");
            return StringUtil.isEmpty((String)enabledAttr) || Boolean.valueOf(enabledAttr) != false || enabledAttr.startsWith("@");
        }

        @Override
        @Nullable
        public Boolean getExported() {
            String exportedAttr = this.myActivity.getAttributeNS("http://schemas.android.com/apk/res/android", "exported");
            return StringUtil.isEmpty((String)exportedAttr) ? null : Boolean.valueOf(exportedAttr);
        }

        @Override
        public boolean hasIntentFilter() {
            for (Node node = this.myActivity.getFirstChild(); node != null; node = node.getNextSibling()) {
                if (node.getNodeType() != 1 || !"intent-filter".equals(node.getNodeName())) continue;
                return true;
            }
            return false;
        }

        @Override
        @Nullable
        public String getQualifiedName() {
            return ActivityLocatorUtils.getQualifiedName(this.myActivity);
        }
    }

    private static class ActivityAliasWrapper
    extends ActivityWrapper {
        private final ActivityAlias myAlias;

        public ActivityAliasWrapper(ActivityAlias activityAlias) {
            this.myAlias = activityAlias;
        }

        @Override
        public boolean hasCategory(@NotNull String name) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/run/activity/DefaultActivityLocator$ActivityAliasWrapper", "hasCategory"));
            }
            for (IntentFilter filter : this.myAlias.getIntentFilters()) {
                if (!AndroidDomUtil.containsCategory(filter, name)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean hasAction(@NotNull String name) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/run/activity/DefaultActivityLocator$ActivityAliasWrapper", "hasAction"));
            }
            for (IntentFilter filter : this.myAlias.getIntentFilters()) {
                if (!AndroidDomUtil.containsAction(filter, name)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean isEnabled() {
            AndroidAttributeValue<String> enabled = this.myAlias.getEnabled();
            if (enabled == null) {
                return true;
            }
            String stringValue = enabled.getStringValue();
            return stringValue == null || Boolean.valueOf(stringValue) != false || stringValue.startsWith("@");
        }

        @Override
        @Nullable
        public Boolean getExported() {
            AndroidAttributeValue<String> exported = this.myAlias.getExported();
            if (exported == null || exported.getValue() == null || ((String)exported.getValue()).isEmpty()) {
                return null;
            }
            return Boolean.valueOf((String)exported.getValue());
        }

        @Override
        public boolean hasIntentFilter() {
            return !this.myAlias.getIntentFilters().isEmpty();
        }

        @Override
        @Nullable
        public String getQualifiedName() {
            return ActivityLocatorUtils.getQualifiedName(this.myAlias);
        }
    }

    private static class RealActivityWrapper
    extends ActivityWrapper {
        private final Activity myActivity;

        public RealActivityWrapper(Activity activity) {
            this.myActivity = activity;
        }

        @Override
        public boolean hasCategory(@NotNull String name) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/run/activity/DefaultActivityLocator$RealActivityWrapper", "hasCategory"));
            }
            for (IntentFilter filter : this.myActivity.getIntentFilters()) {
                if (!AndroidDomUtil.containsCategory(filter, name)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean hasAction(@NotNull String name) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/run/activity/DefaultActivityLocator$RealActivityWrapper", "hasAction"));
            }
            for (IntentFilter filter : this.myActivity.getIntentFilters()) {
                if (!AndroidDomUtil.containsAction(filter, name)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean isEnabled() {
            AndroidAttributeValue<String> enabled = this.myActivity.getEnabled();
            if (enabled == null) {
                return true;
            }
            String stringValue = enabled.getStringValue();
            return stringValue == null || Boolean.valueOf(stringValue) != false || stringValue.startsWith("@");
        }

        @Override
        @Nullable
        public Boolean getExported() {
            AndroidAttributeValue<String> exported = this.myActivity.getExported();
            if (exported == null || exported.getValue() == null || ((String)exported.getValue()).isEmpty()) {
                return null;
            }
            return Boolean.valueOf((String)exported.getValue());
        }

        @Override
        public boolean hasIntentFilter() {
            return !this.myActivity.getIntentFilters().isEmpty();
        }

        @Override
        @Nullable
        public String getQualifiedName() {
            return ActivityLocatorUtils.getQualifiedName(this.myActivity);
        }
    }

    public static abstract class ActivityWrapper {
        public abstract boolean hasCategory(@NotNull String var1);

        public abstract boolean hasAction(@NotNull String var1);

        public abstract boolean isEnabled();

        @Nullable
        public abstract Boolean getExported();

        public abstract boolean hasIntentFilter();

        @Nullable
        public abstract String getQualifiedName();

        public static ActivityWrapper get(@NotNull Activity activity) {
            if (activity == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "activity", "com/android/tools/idea/run/activity/DefaultActivityLocator$ActivityWrapper", "get"));
            }
            return new RealActivityWrapper(activity);
        }

        public static ActivityWrapper get(@NotNull ActivityAlias activityAlias) {
            if (activityAlias == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "activityAlias", "com/android/tools/idea/run/activity/DefaultActivityLocator$ActivityWrapper", "get"));
            }
            return new ActivityAliasWrapper(activityAlias);
        }

        public static ActivityWrapper get(@NotNull Element activityOrAlias) {
            if (activityOrAlias == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "activityOrAlias", "com/android/tools/idea/run/activity/DefaultActivityLocator$ActivityWrapper", "get"));
            }
            return new ElementActivityWrapper(activityOrAlias);
        }

        public static List<ActivityWrapper> get(@NotNull List<Element> activities, @NotNull List<Element> aliases) {
            if (activities == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "activities", "com/android/tools/idea/run/activity/DefaultActivityLocator$ActivityWrapper", "get"));
            }
            if (aliases == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aliases", "com/android/tools/idea/run/activity/DefaultActivityLocator$ActivityWrapper", "get"));
            }
            ArrayList list = Lists.newArrayListWithCapacity((int)(activities.size() + aliases.size()));
            for (Element element : activities) {
                list.add(new ElementActivityWrapper(element));
            }
            for (Element element : aliases) {
                list.add(new ElementActivityWrapper(element));
            }
            return list;
        }
    }
}

