/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.editor;

import com.android.ddmlib.IDevice;
import com.android.tools.idea.run.DeviceCount;
import com.android.tools.idea.run.DeviceFutures;
import com.android.tools.idea.run.DeviceSelectionUtils;
import com.android.tools.idea.run.TargetDeviceFilter;
import com.android.tools.idea.run.TargetSelectionMode;
import com.android.tools.idea.run.editor.DeployTarget;
import com.android.tools.idea.run.editor.DeployTargetConfigurable;
import com.android.tools.idea.run.editor.DeployTargetConfigurableContext;
import com.android.tools.idea.run.editor.DeployTargetProvider;
import com.android.tools.idea.run.editor.DeployTargetState;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import java.util.Collection;
import javax.swing.JComponent;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UsbDeviceTargetProvider
extends DeployTargetProvider {
    @Override
    @NotNull
    public String getId() {
        String string = TargetSelectionMode.USB_DEVICE.name();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/run/editor/UsbDeviceTargetProvider", "getId"));
        }
        return string;
    }

    @Override
    @NotNull
    public String getDisplayName() {
        if ("USB Device" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/run/editor/UsbDeviceTargetProvider", "getDisplayName"));
        }
        return "USB Device";
    }

    @NotNull
    public DeployTargetState createState() {
        State state = new State();
        if (state == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/run/editor/UsbDeviceTargetProvider", "createState"));
        }
        return state;
    }

    public DeployTargetConfigurable createConfigurable(@NotNull Project project, @NotNull Disposable parentDisposable, @NotNull DeployTargetConfigurableContext context) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/run/editor/UsbDeviceTargetProvider", "createConfigurable"));
        }
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDisposable", "com/android/tools/idea/run/editor/UsbDeviceTargetProvider", "createConfigurable"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/android/tools/idea/run/editor/UsbDeviceTargetProvider", "createConfigurable"));
        }
        return new TargetConfigurable();
    }

    public DeployTarget getDeployTarget() {
        return new DeployTarget(){

            @Override
            public boolean hasCustomRunProfileState(@NotNull Executor executor) {
                if (executor == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executor", "com/android/tools/idea/run/editor/UsbDeviceTargetProvider$1", "hasCustomRunProfileState"));
                }
                return false;
            }

            public RunProfileState getRunProfileState(@NotNull Executor executor, @NotNull ExecutionEnvironment env, @NotNull DeployTargetState state) throws ExecutionException {
                if (executor == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executor", "com/android/tools/idea/run/editor/UsbDeviceTargetProvider$1", "getRunProfileState"));
                }
                if (env == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "env", "com/android/tools/idea/run/editor/UsbDeviceTargetProvider$1", "getRunProfileState"));
                }
                if (state == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/android/tools/idea/run/editor/UsbDeviceTargetProvider$1", "getRunProfileState"));
                }
                return null;
            }

            @Nullable
            public DeviceFutures getDevices(@NotNull DeployTargetState state, @NotNull AndroidFacet facet, @NotNull DeviceCount deviceCount, boolean debug, int runConfigId) {
                if (state == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/android/tools/idea/run/editor/UsbDeviceTargetProvider$1", "getDevices"));
                }
                if (facet == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/android/tools/idea/run/editor/UsbDeviceTargetProvider$1", "getDevices"));
                }
                if (deviceCount == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "deviceCount", "com/android/tools/idea/run/editor/UsbDeviceTargetProvider$1", "getDevices"));
                }
                Collection<IDevice> runningDevices = DeviceSelectionUtils.chooseRunningDevice(facet, new TargetDeviceFilter.UsbDeviceFilter(), deviceCount);
                if (runningDevices == null) {
                    return null;
                }
                return DeviceFutures.forDevices(runningDevices);
            }
        };
    }

    private static class TargetConfigurable
    implements DeployTargetConfigurable<State> {
        private TargetConfigurable() {
        }

        @Override
        @Nullable
        public JComponent createComponent() {
            return null;
        }

        @Override
        public void resetFrom(@NotNull State state, int uniqueID) {
            if (state == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/android/tools/idea/run/editor/UsbDeviceTargetProvider$TargetConfigurable", "resetFrom"));
            }
        }

        @Override
        public void applyTo(@NotNull State state, int uniqueID) {
            if (state == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/android/tools/idea/run/editor/UsbDeviceTargetProvider$TargetConfigurable", "applyTo"));
            }
        }
    }

    public static final class State
    extends DeployTargetState {
    }
}

