/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.sdk.install.patch;

import com.android.repository.api.Downloader;
import com.android.repository.api.LocalPackage;
import com.android.repository.api.ProgressIndicator;
import com.android.repository.api.RemotePackage;
import com.android.repository.api.RepoManager;
import com.android.repository.impl.installer.AbstractInstaller;
import com.android.repository.impl.meta.Archive;
import com.android.repository.io.FileOp;
import com.android.repository.util.InstallerUtil;
import com.android.tools.idea.sdk.install.patch.PatchInstallerUtil;
import com.android.tools.idea.sdk.install.patch.PatchOperation;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class FullInstaller
extends AbstractInstaller
implements PatchOperation {
    private static final String UNZIP_DIR_FN = "unzip";
    private LocalPackage myExisting;
    private LocalPackage myPatcher;
    private File myUnzippedPackage;
    private File myGeneratedPatch;

    public FullInstaller(@Nullable LocalPackage existing, @NotNull RemotePackage p, @NotNull RepoManager mgr, @NotNull Downloader downloader, @NotNull FileOp fop) {
        if (p == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "p", "com/android/tools/idea/sdk/install/patch/FullInstaller", "<init>"));
        }
        if (mgr == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mgr", "com/android/tools/idea/sdk/install/patch/FullInstaller", "<init>"));
        }
        if (downloader == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "downloader", "com/android/tools/idea/sdk/install/patch/FullInstaller", "<init>"));
        }
        if (fop == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fop", "com/android/tools/idea/sdk/install/patch/FullInstaller", "<init>"));
        }
        super(p, mgr, downloader, fop);
        this.myExisting = existing;
        this.myPatcher = PatchInstallerUtil.getDependantPatcher(this.getPackage(), this.getRepoManager());
        if (this.myPatcher == null) {
            this.myPatcher = PatchInstallerUtil.getLatestPatcher(this.getRepoManager());
        }
    }

    protected boolean doComplete(@Nullable File installTemp, @NotNull ProgressIndicator progress) {
        if (progress == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progress", "com/android/tools/idea/sdk/install/patch/FullInstaller", "doComplete"));
        }
        if (this.myPatcher == null) {
            return false;
        }
        return PatchInstallerUtil.installPatch(this, this.myGeneratedPatch, this.mFop, progress);
    }

    protected boolean doPrepare(@NotNull File installTempPath, @NotNull ProgressIndicator progress) {
        if (installTempPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "installTempPath", "com/android/tools/idea/sdk/install/patch/FullInstaller", "doPrepare"));
        }
        if (progress == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progress", "com/android/tools/idea/sdk/install/patch/FullInstaller", "doPrepare"));
        }
        if (!this.downloadAndUnzip(installTempPath, this.getDownloader(), progress)) {
            return false;
        }
        this.myUnzippedPackage = new File(installTempPath, UNZIP_DIR_FN);
        File[] children = this.mFop.listFiles(this.myUnzippedPackage);
        if (children.length == 1) {
            this.myUnzippedPackage = children[0];
        }
        this.myGeneratedPatch = PatchInstallerUtil.generatePatch(this, installTempPath, this.mFop, progress);
        return this.myGeneratedPatch != null;
    }

    private boolean downloadAndUnzip(@NotNull File installTempPath, @NotNull Downloader downloader, @NotNull ProgressIndicator progress) {
        if (installTempPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "installTempPath", "com/android/tools/idea/sdk/install/patch/FullInstaller", "downloadAndUnzip"));
        }
        if (downloader == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "downloader", "com/android/tools/idea/sdk/install/patch/FullInstaller", "downloadAndUnzip"));
        }
        if (progress == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progress", "com/android/tools/idea/sdk/install/patch/FullInstaller", "downloadAndUnzip"));
        }
        URL url = InstallerUtil.resolveCompleteArchiveUrl((RemotePackage)this.getPackage(), (ProgressIndicator)progress);
        if (url == null) {
            progress.logWarning("No compatible archive found!");
            return false;
        }
        Archive archive = this.getPackage().getArchive();
        assert (archive != null);
        try {
            File downloadLocation = new File(installTempPath, url.getFile());
            String checksum = archive.getComplete().getChecksum();
            downloader.downloadFully(url, downloadLocation, checksum, progress);
            if (progress.isCanceled()) {
                return false;
            }
            if (!this.mFop.exists(downloadLocation)) {
                progress.logWarning("Failed to download package!");
                return false;
            }
            File unzip = new File(installTempPath, UNZIP_DIR_FN);
            this.mFop.mkdirs(unzip);
            InstallerUtil.unzip((File)downloadLocation, (File)unzip, (FileOp)this.mFop, (long)archive.getComplete().getSize(), (ProgressIndicator)progress);
            if (progress.isCanceled()) {
                return false;
            }
            this.mFop.delete(downloadLocation);
            return true;
        }
        catch (IOException e) {
            StringBuilder message = new StringBuilder("An error occurred while preparing SDK package ").append(this.getPackage().getDisplayName());
            String exceptionMessage = e.getMessage();
            if (exceptionMessage != null && !exceptionMessage.isEmpty()) {
                message.append(": ").append(exceptionMessage);
            } else {
                message.append(".");
            }
            progress.logWarning(message.toString(), (Throwable)e);
            return false;
        }
    }

    @Override
    @Nullable
    public LocalPackage getExisting() {
        return this.myExisting;
    }

    @Override
    @NotNull
    public LocalPackage getPatcher(@NotNull ProgressIndicator progressIndicator) {
        if (progressIndicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progressIndicator", "com/android/tools/idea/sdk/install/patch/FullInstaller", "getPatcher"));
        }
        LocalPackage localPackage = this.myPatcher;
        if (localPackage == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/sdk/install/patch/FullInstaller", "getPatcher"));
        }
        return localPackage;
    }

    @Override
    @NotNull
    public File getNewFilesRoot() {
        File file = this.myUnzippedPackage;
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/sdk/install/patch/FullInstaller", "getNewFilesRoot"));
        }
        return file;
    }

    @Override
    @NotNull
    public String getNewVersionName() {
        String string = this.getPackage().getDisplayName() + " Version " + this.getPackage().getVersion();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/sdk/install/patch/FullInstaller", "getNewVersionName"));
        }
        return string;
    }
}

