/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.templates;

import com.android.ide.common.repository.GradleCoordinate;
import com.android.ide.common.repository.GradleVersion;
import com.android.ide.common.repository.MavenRepositories;
import com.android.ide.common.repository.SdkMavenRepository;
import com.android.repository.Revision;
import com.android.repository.api.ProgressIndicator;
import com.android.repository.api.RemotePackage;
import com.android.repository.io.FileOp;
import com.android.repository.io.FileOpUtils;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.tools.idea.gradle.util.EmbeddedDistributionPaths;
import com.android.tools.idea.gradle.util.GradleLocalCache;
import com.android.tools.idea.lint.LintIdeClient;
import com.android.tools.idea.sdk.AndroidSdks;
import com.android.tools.idea.sdk.progress.StudioLoggerProgressIndicator;
import com.android.tools.idea.templates.SupportLibrary;
import com.android.tools.lint.checks.GradleDetector;
import com.android.tools.lint.client.api.LintClient;
import com.android.utils.FileUtils;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Ordering;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.io.IOUtils;
import org.jetbrains.android.sdk.AndroidSdkData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class RepositoryUrlManager {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.android.templates.RepositoryUrlManager");
    public static final String TAG_VERSION = "version";
    public static final String REVISION_ANY = "0.0.+";
    private static final Ordering<GradleCoordinate> GRADLE_COORDINATE_ORDERING = Ordering.from((Comparator)GradleCoordinate.COMPARE_PLUS_LOWER);
    private final boolean myForceRepositoryChecksInTests;

    public static RepositoryUrlManager get() {
        return new RepositoryUrlManager(false);
    }

    RepositoryUrlManager(boolean forceRepositoryChecks) {
        this.myForceRepositoryChecksInTests = forceRepositoryChecks;
    }

    @Nullable
    public String getLibraryStringCoordinate(SupportLibrary library, boolean preview) {
        AndroidSdkData sdk = AndroidSdks.getInstance().tryToChooseAndroidSdk();
        if (sdk == null) {
            return null;
        }
        String revision = this.getLibraryRevision(library.getGroupId(), library.getArtifactId(), null, preview, sdk.getLocation(), FileOpUtils.create());
        if (revision == null) {
            return null;
        }
        return library.getGradleCoordinate(revision).toString();
    }

    @Nullable
    public String getLibraryRevision(@NotNull String groupId, @NotNull String artifactId, @Nullable String filterPrefix, boolean includePreviews, @NotNull File sdkLocation, @NotNull FileOp fileOp) {
        GradleCoordinate versionInCombined;
        if (groupId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "groupId", "com/android/tools/idea/templates/RepositoryUrlManager", "getLibraryRevision"));
        }
        if (artifactId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifactId", "com/android/tools/idea/templates/RepositoryUrlManager", "getLibraryRevision"));
        }
        if (sdkLocation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdkLocation", "com/android/tools/idea/templates/RepositoryUrlManager", "getLibraryRevision"));
        }
        if (fileOp == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileOp", "com/android/tools/idea/templates/RepositoryUrlManager", "getLibraryRevision"));
        }
        File combinedRepo = FileUtils.join((File)sdkLocation, (String[])new String[]{"extras", "m2repository"});
        if (fileOp.isDirectory(combinedRepo) && (versionInCombined = MavenRepositories.getHighestInstalledVersion((String)groupId, (String)artifactId, (File)combinedRepo, (String)filterPrefix, (boolean)includePreviews, (FileOp)fileOp)) != null) {
            return versionInCombined.getRevision();
        }
        SdkMavenRepository repository = SdkMavenRepository.find((File)sdkLocation, (String)groupId, (String)artifactId, (FileOp)fileOp);
        if (repository == null) {
            List<File> paths = EmbeddedDistributionPaths.getInstance().findAndroidStudioLocalMavenRepoPaths();
            for (File path : paths) {
                GradleCoordinate versionInEmbedded;
                if (path == null || !path.isDirectory() || (versionInEmbedded = MavenRepositories.getHighestInstalledVersion((String)groupId, (String)artifactId, (File)path, (String)filterPrefix, (boolean)includePreviews, (FileOp)fileOp)) == null) continue;
                return versionInEmbedded.getRevision();
            }
            return null;
        }
        File repositoryLocation = repository.getRepositoryLocation(sdkLocation, true, fileOp);
        if (repositoryLocation == null) {
            return null;
        }
        File mavenMetadataFile = MavenRepositories.getMavenMetadataFile((File)repositoryLocation, (String)groupId, (String)artifactId);
        if (fileOp.isFile(mavenMetadataFile)) {
            try {
                return RepositoryUrlManager.getLatestVersionFromMavenMetadata(mavenMetadataFile, filterPrefix, includePreviews, fileOp);
            }
            catch (IOException e) {
                return null;
            }
        }
        GradleCoordinate max = repository.getHighestInstalledVersion(sdkLocation, groupId, artifactId, filterPrefix, includePreviews, fileOp);
        if (max == null) {
            return null;
        }
        return max.getRevision();
    }

    @Nullable
    public File getArchiveForCoordinate(@NotNull GradleCoordinate gradleCoordinate, @NotNull File sdkLocation, @NotNull FileOp fileOp) {
        if (gradleCoordinate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gradleCoordinate", "com/android/tools/idea/templates/RepositoryUrlManager", "getArchiveForCoordinate"));
        }
        if (sdkLocation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdkLocation", "com/android/tools/idea/templates/RepositoryUrlManager", "getArchiveForCoordinate"));
        }
        if (fileOp == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileOp", "com/android/tools/idea/templates/RepositoryUrlManager", "getArchiveForCoordinate"));
        }
        if (gradleCoordinate.getGroupId() == null || gradleCoordinate.getArtifactId() == null) {
            return null;
        }
        SdkMavenRepository repository = SdkMavenRepository.find((File)sdkLocation, (String)gradleCoordinate.getGroupId(), (String)gradleCoordinate.getArtifactId(), (FileOp)fileOp);
        if (repository == null) {
            return null;
        }
        File repositoryLocation = repository.getRepositoryLocation(sdkLocation, true, fileOp);
        if (repositoryLocation == null) {
            return null;
        }
        File artifactDirectory = MavenRepositories.getArtifactDirectory((File)repositoryLocation, (GradleCoordinate)gradleCoordinate);
        if (!fileOp.isDirectory(artifactDirectory)) {
            return null;
        }
        for (GradleCoordinate.ArtifactType artifactType : ImmutableList.of((Object)GradleCoordinate.ArtifactType.JAR, (Object)GradleCoordinate.ArtifactType.AAR)) {
            File archive = new File(artifactDirectory, String.format("%s-%s.%s", gradleCoordinate.getArtifactId(), gradleCoordinate.getRevision(), artifactType.toString()));
            if (!fileOp.isFile(archive)) continue;
            return archive;
        }
        return null;
    }

    @Nullable
    private static String getLatestVersionFromMavenMetadata(final @NotNull File metadataFile, final @Nullable String filterPrefix, final boolean includePreviews, @NotNull FileOp fileOp) throws IOException {
        if (metadataFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "metadataFile", "com/android/tools/idea/templates/RepositoryUrlManager", "getLatestVersionFromMavenMetadata"));
        }
        if (fileOp == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileOp", "com/android/tools/idea/templates/RepositoryUrlManager", "getLatestVersionFromMavenMetadata"));
        }
        String xml = fileOp.toString(metadataFile, StandardCharsets.UTF_8);
        final LinkedList versions = Lists.newLinkedList();
        try {
            SAXParserFactory.newInstance().newSAXParser().parse(IOUtils.toInputStream((String)xml), new DefaultHandler(){
                boolean inVersionTag = false;

                @Override
                public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
                    if (qName.equals(RepositoryUrlManager.TAG_VERSION)) {
                        this.inVersionTag = true;
                    }
                }

                @Override
                public void characters(char[] ch, int start, int length) throws SAXException {
                    if (this.inVersionTag) {
                        this.inVersionTag = false;
                        String revision = new String(ch, start, length);
                        if (!(!includePreviews && "5.2.08".equals(revision) && metadataFile.getPath().contains(SupportLibrary.PLAY_SERVICES.getArtifactId()) || filterPrefix != null && !revision.startsWith(filterPrefix))) {
                            versions.add(GradleCoordinate.parseVersionOnly((String)revision));
                        }
                    }
                }
            });
        }
        catch (Exception e) {
            LOG.warn((Throwable)e);
        }
        if (versions.isEmpty()) {
            return REVISION_ANY;
        }
        if (includePreviews) {
            return ((GradleCoordinate)GRADLE_COORDINATE_ORDERING.max((Iterable)versions)).getRevision();
        }
        return versions.stream().filter(v -> !v.isPreview()).max((Comparator<GradleCoordinate>)GRADLE_COORDINATE_ORDERING).map(GradleCoordinate::getRevision).orElse(null);
    }

    @Nullable
    public GradleCoordinate resolveDynamicCoordinate(@NotNull GradleCoordinate coordinate, @Nullable Project project) {
        if (coordinate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "coordinate", "com/android/tools/idea/templates/RepositoryUrlManager", "resolveDynamicCoordinate"));
        }
        return this.resolveDynamicCoordinate(coordinate, project, AndroidSdks.getInstance().tryToChooseSdkHandler());
    }

    @Nullable
    public GradleCoordinate resolveDynamicCoordinate(@NotNull GradleCoordinate coordinate, @Nullable Project project, @NotNull AndroidSdkHandler sdkHandler) {
        List revisions;
        if (coordinate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "coordinate", "com/android/tools/idea/templates/RepositoryUrlManager", "resolveDynamicCoordinate"));
        }
        if (sdkHandler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdkHandler", "com/android/tools/idea/templates/RepositoryUrlManager", "resolveDynamicCoordinate"));
        }
        String version = this.resolveDynamicCoordinateVersion(coordinate, project, sdkHandler);
        if (version != null && coordinate.getGroupId() != null && coordinate.getArtifactId() != null && !(revisions = GradleCoordinate.parseRevisionNumber((String)version)).isEmpty()) {
            return new GradleCoordinate(coordinate.getGroupId(), coordinate.getArtifactId(), revisions, coordinate.getArtifactType());
        }
        return null;
    }

    @Nullable
    public String resolveDynamicCoordinateVersion(@NotNull GradleCoordinate coordinate, @Nullable Project project) {
        if (coordinate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "coordinate", "com/android/tools/idea/templates/RepositoryUrlManager", "resolveDynamicCoordinateVersion"));
        }
        return this.resolveDynamicCoordinateVersion(coordinate, project, AndroidSdks.getInstance().tryToChooseSdkHandler());
    }

    @Nullable
    String resolveDynamicCoordinateVersion(@NotNull GradleCoordinate coordinate, @Nullable Project project, @NotNull AndroidSdkHandler sdkHandler) {
        String version;
        LintIdeClient client;
        Revision latest;
        GradleCoordinate found;
        GradleVersion versionFound;
        if (coordinate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "coordinate", "com/android/tools/idea/templates/RepositoryUrlManager", "resolveDynamicCoordinateVersion"));
        }
        if (sdkHandler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdkHandler", "com/android/tools/idea/templates/RepositoryUrlManager", "resolveDynamicCoordinateVersion"));
        }
        if (coordinate.getGroupId() == null || coordinate.getArtifactId() == null) {
            return null;
        }
        String filter = coordinate.getRevision();
        if (!filter.endsWith("+")) {
            return filter;
        }
        filter = filter.substring(0, filter.length() - 1);
        File sdkLocation = sdkHandler.getLocation();
        if (sdkLocation != null) {
            String libraryCoordinate = this.getLibraryRevision(coordinate.getGroupId(), coordinate.getArtifactId(), filter, false, sdkLocation, sdkHandler.getFileOp());
            if (libraryCoordinate != null) {
                return libraryCoordinate;
            }
            libraryCoordinate = this.getLibraryRevision(coordinate.getGroupId(), coordinate.getArtifactId(), filter, true, sdkLocation, sdkHandler.getFileOp());
            if (libraryCoordinate != null) {
                return libraryCoordinate;
            }
        }
        if ((versionFound = GradleLocalCache.getInstance().findLatestArtifactVersion(coordinate, project, filter)) != null) {
            return versionFound.toString();
        }
        RemotePackage sdkPackage = SdkMavenRepository.findLatestRemoteVersion((GradleCoordinate)coordinate, (AndroidSdkHandler)sdkHandler, (ProgressIndicator)new StudioLoggerProgressIndicator(this.getClass()));
        if (sdkPackage != null && (found = SdkMavenRepository.getCoordinateFromSdkPath((String)sdkPackage.getPath())) != null) {
            return found.getRevision();
        }
        if (project != null && (latest = GradleDetector.getLatestVersionFromRemoteRepo((LintClient)(client = new LintIdeClient(project)), (GradleCoordinate)coordinate, (boolean)coordinate.isPreview())) != null && (version = latest.toShortString()).startsWith(filter)) {
            return version;
        }
        return null;
    }

    public List<GradleCoordinate> resolveDynamicSdkDependencies(@NotNull Multimap<String, GradleCoordinate> dependencies, @Nullable String supportLibVersionFilter, @NotNull AndroidSdkData sdk, @NotNull FileOp fileOp) {
        if (dependencies == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dependencies", "com/android/tools/idea/templates/RepositoryUrlManager", "resolveDynamicSdkDependencies"));
        }
        if (sdk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdk", "com/android/tools/idea/templates/RepositoryUrlManager", "resolveDynamicSdkDependencies"));
        }
        if (fileOp == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileOp", "com/android/tools/idea/templates/RepositoryUrlManager", "resolveDynamicSdkDependencies"));
        }
        ArrayList result = Lists.newArrayListWithCapacity((int)dependencies.size());
        String supportFilter = RepositoryUrlManager.findExistingExplicitVersion(dependencies.values());
        if (supportFilter != null) {
            supportLibVersionFilter = supportFilter;
        }
        for (String key : dependencies.keySet()) {
            String filter;
            GradleCoordinate highest = (GradleCoordinate)Collections.max(dependencies.get((Object)key), GradleCoordinate.COMPARE_PLUS_LOWER);
            if (highest.getGroupId() == null || highest.getArtifactId() == null) {
                return null;
            }
            if ((this.myForceRepositoryChecksInTests || !ApplicationManager.getApplication().isUnitTestMode()) && (filter = highest.getRevision()).endsWith("+")) {
                File archiveFile;
                String libraryCoordinate;
                GradleCoordinate available;
                String version;
                filter = filter.length() > 1 ? filter.substring(0, filter.length() - 1) : null;
                boolean includePreviews = false;
                if (filter == null && "com.android.support".equals(highest.getGroupId())) {
                    filter = supportLibVersionFilter;
                    includePreviews = true;
                }
                if ((version = this.getLibraryRevision(highest.getGroupId(), highest.getArtifactId(), filter, includePreviews, sdk.getLocation(), fileOp)) == null && filter != null) {
                    version = this.getLibraryRevision(highest.getGroupId(), highest.getArtifactId(), null, includePreviews, sdk.getLocation(), fileOp);
                }
                if (version == null && !includePreviews) {
                    version = this.getLibraryRevision(highest.getGroupId(), highest.getArtifactId(), null, true, sdk.getLocation(), fileOp);
                }
                if (version != null && (available = GradleCoordinate.parseCoordinateString((String)(libraryCoordinate = highest.getId() + ":" + version))) != null && ((archiveFile = this.getArchiveForCoordinate(available, sdk.getLocation(), fileOp)) != null && fileOp.exists(archiveFile) || SupportLibrary.forGradleCoordinate(available) == null) && GradleCoordinate.COMPARE_PLUS_LOWER.compare(available, highest) >= 0) {
                    highest = available;
                }
            }
            result.add(highest);
        }
        return result;
    }

    private static String findExistingExplicitVersion(@NotNull Collection<GradleCoordinate> dependencies) {
        if (dependencies == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dependencies", "com/android/tools/idea/templates/RepositoryUrlManager", "findExistingExplicitVersion"));
        }
        Optional<GradleCoordinate> highest = dependencies.stream().filter(coordinate -> "com.android.support".equals(coordinate.getGroupId())).max(GradleCoordinate.COMPARE_PLUS_LOWER);
        if (!highest.isPresent()) {
            return null;
        }
        String version = highest.get().getRevision();
        if (version.endsWith("+")) {
            return version.length() > 1 ? version.substring(0, version.length() - 1) : null;
        }
        return version;
    }
}

