/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.testartifacts.junit;

import com.android.tools.idea.IdeInfo;
import com.android.tools.idea.testartifacts.junit.AndroidJUnitConfiguration;
import com.intellij.execution.configuration.ConfigurationFactoryEx;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.ConfigurationTypeUtil;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.junit.JUnitConfigurationType;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.project.Project;
import com.intellij.ui.LayeredIcon;
import icons.AndroidIcons;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class AndroidJUnitConfigurationType
extends JUnitConfigurationType {
    private static final Icon ANDROID_TEST_ICON;
    private static final String ANDROID_JUNIT_DESCRIPTION = "Android JUnit test configuration";
    private static final String ANDROID_JUNIT_NAME = "Android JUnit";
    private static final String ANDROID_JUNIT_ID = "AndroidJUnit";
    private final ConfigurationFactory myFactory = new ConfigurationFactoryEx((ConfigurationType)this){

        @NotNull
        public RunConfiguration createTemplateConfiguration(@NotNull Project project) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/testartifacts/junit/AndroidJUnitConfigurationType$1", "createTemplateConfiguration"));
            }
            AndroidJUnitConfiguration androidJUnitConfiguration = new AndroidJUnitConfiguration("", project, (ConfigurationFactory)this);
            if (androidJUnitConfiguration == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/testartifacts/junit/AndroidJUnitConfigurationType$1", "createTemplateConfiguration"));
            }
            return androidJUnitConfiguration;
        }

        public void onNewConfigurationCreated(@NotNull RunConfiguration configuration) {
            if (configuration == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/android/tools/idea/testartifacts/junit/AndroidJUnitConfigurationType$1", "onNewConfigurationCreated"));
            }
            ((ModuleBasedConfiguration)configuration).onNewConfigurationCreated();
        }
    };

    public String getDisplayName() {
        return ANDROID_JUNIT_NAME;
    }

    public String getConfigurationTypeDescription() {
        return ANDROID_JUNIT_DESCRIPTION;
    }

    public Icon getIcon() {
        return IdeInfo.getInstance().isAndroidStudio() ? AllIcons.RunConfigurations.Junit : ANDROID_TEST_ICON;
    }

    public ConfigurationFactory[] getConfigurationFactories() {
        return new ConfigurationFactory[]{this.myFactory};
    }

    @NotNull
    public String getId() {
        if (ANDROID_JUNIT_ID == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/testartifacts/junit/AndroidJUnitConfigurationType", "getId"));
        }
        return ANDROID_JUNIT_ID;
    }

    @NotNull
    public static AndroidJUnitConfigurationType getInstance() {
        AndroidJUnitConfigurationType androidJUnitConfigurationType = (AndroidJUnitConfigurationType)ConfigurationTypeUtil.findConfigurationType(AndroidJUnitConfigurationType.class);
        if (androidJUnitConfigurationType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/testartifacts/junit/AndroidJUnitConfigurationType", "getInstance"));
        }
        return androidJUnitConfigurationType;
    }

    static {
        LayeredIcon icon = new LayeredIcon(2);
        icon.setIcon(AndroidIcons.AndroidModule, 0);
        icon.setIcon(AllIcons.Nodes.JunitTestMark, 1);
        ANDROID_TEST_ICON = icon;
    }
}

