/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ui.resourcechooser;

import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.resources.ResourceFile;
import com.android.ide.common.resources.ResourceItem;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.resources.ResourceType;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.intellij.openapi.util.Pair;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class ResourceChooserItem {
    static final String DEFAULT_FOLDER_NAME = "Default";
    @NotNull
    protected final ResourceType myType;
    @NotNull
    protected final String myName;
    @Nullable
    private Icon myIcon;

    public ResourceChooserItem(@NotNull ResourceType type, @NotNull String name) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/android/tools/idea/ui/resourcechooser/ResourceChooserItem", "<init>"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/ui/resourcechooser/ResourceChooserItem", "<init>"));
        }
        this.myType = type;
        this.myName = name;
    }

    @NotNull
    public List<String> getQualifiers() {
        List<String> list = Collections.singletonList(DEFAULT_FOLDER_NAME);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/ui/resourcechooser/ResourceChooserItem", "getQualifiers"));
        }
        return list;
    }

    @NotNull
    public ResourceType getType() {
        ResourceType resourceType = this.myType;
        if (resourceType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/ui/resourcechooser/ResourceChooserItem", "getType"));
        }
        return resourceType;
    }

    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/ui/resourcechooser/ResourceChooserItem", "getName"));
        }
        return string;
    }

    @NotNull
    public String getQualifiedName() {
        String string = this.isFramework() ? "android:" + this.getName() : this.getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/ui/resourcechooser/ResourceChooserItem", "getQualifiedName"));
        }
        return string;
    }

    public File getFile() {
        return null;
    }

    @Nullable
    public String getPath() {
        return null;
    }

    @Nullable
    public String getFileForQualifiers(String qualifiers) {
        return null;
    }

    @NotNull
    public abstract String getResourceUrl();

    @NotNull
    public ResourceValue getResourceValue() {
        ResourceValue resourceValue = new ResourceValue(this.getType(), this.getName(), this.getResourceUrl(), this.isFramework(), null);
        if (resourceValue == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/ui/resourcechooser/ResourceChooserItem", "getResourceValue"));
        }
        return resourceValue;
    }

    public String toString() {
        return this.getName();
    }

    @Nullable
    public Icon getIcon() {
        return this.myIcon;
    }

    public void setIcon(@Nullable Icon icon) {
        this.myIcon = icon;
    }

    public abstract boolean isFramework();

    public boolean isAttr() {
        return false;
    }

    public boolean isReference() {
        String s = this.getDefaultValue();
        if (s != null) {
            return s.startsWith("@") || s.startsWith("?");
        }
        return false;
    }

    @Nullable
    public abstract String getDefaultValue();

    @NotNull
    public List<Pair<FolderConfiguration, String>> getQualifiersAndValues() {
        List<Pair<FolderConfiguration, String>> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/ui/resourcechooser/ResourceChooserItem", "getQualifiersAndValues"));
        }
        return list;
    }

    public static class AttrItem
    extends ResourceChooserItem {
        private boolean myFramework;

        public AttrItem(@NotNull ResourceType type, boolean framework, @NotNull String name) {
            if (type == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/android/tools/idea/ui/resourcechooser/ResourceChooserItem$AttrItem", "<init>"));
            }
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/ui/resourcechooser/ResourceChooserItem$AttrItem", "<init>"));
            }
            super(type, name);
            this.myFramework = framework;
        }

        @Override
        public boolean isAttr() {
            return true;
        }

        @Override
        public boolean isFramework() {
            return this.myFramework;
        }

        @Override
        @NotNull
        public String getResourceUrl() {
            if (this.isFramework()) {
                String string = "?android:" + ResourceType.ATTR.getName() + '/' + this.myName;
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/ui/resourcechooser/ResourceChooserItem$AttrItem", "getResourceUrl"));
                }
                return string;
            }
            String string = "?" + ResourceType.ATTR.getName() + '/' + this.myName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/ui/resourcechooser/ResourceChooserItem$AttrItem", "getResourceUrl"));
            }
            return string;
        }

        @Override
        public String toString() {
            return this.getQualifiedName();
        }

        @Override
        public boolean isReference() {
            return true;
        }

        @Override
        public String getDefaultValue() {
            return null;
        }
    }

    public static class ProjectItem
    extends ResourceChooserItem {
        @NotNull
        private final List<com.android.ide.common.res2.ResourceItem> myProjectItems;

        public ProjectItem(@NotNull ResourceType type, @NotNull String name, @NotNull List<com.android.ide.common.res2.ResourceItem> projectItems) {
            if (type == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/android/tools/idea/ui/resourcechooser/ResourceChooserItem$ProjectItem", "<init>"));
            }
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/ui/resourcechooser/ResourceChooserItem$ProjectItem", "<init>"));
            }
            if (projectItems == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectItems", "com/android/tools/idea/ui/resourcechooser/ResourceChooserItem$ProjectItem", "<init>"));
            }
            super(type, name);
            this.myProjectItems = projectItems;
        }

        @Override
        public boolean isFramework() {
            return false;
        }

        @Override
        public File getFile() {
            return this.myProjectItems.get(0).getFile();
        }

        @Override
        @Nullable
        public String getPath() {
            return this.myProjectItems.get(0).getFile().getPath();
        }

        @Override
        @Nullable
        public String getFileForQualifiers(String qualifiers) {
            for (com.android.ide.common.res2.ResourceItem item : this.myProjectItems) {
                if (!qualifiers.equals(item.getQualifiers())) continue;
                return item.getFile().getPath();
            }
            return null;
        }

        @Override
        @NotNull
        public String getResourceUrl() {
            String string = "@" + this.myType.getName() + '/' + this.myName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/ui/resourcechooser/ResourceChooserItem$ProjectItem", "getResourceUrl"));
            }
            return string;
        }

        @Override
        @NotNull
        public List<String> getQualifiers() {
            HashSet set = Sets.newHashSet();
            for (com.android.ide.common.res2.ResourceItem item : this.myProjectItems) {
                String q = item.getQualifiers();
                if (!q.isEmpty()) {
                    set.add(q);
                    continue;
                }
                set.add(ResourceChooserItem.DEFAULT_FOLDER_NAME);
            }
            ArrayList<String> qualifiers = new ArrayList<String>(set);
            Collections.sort(qualifiers);
            ArrayList<String> arrayList = qualifiers;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/ui/resourcechooser/ResourceChooserItem$ProjectItem", "getQualifiers"));
            }
            return arrayList;
        }

        @Override
        public String getDefaultValue() {
            com.android.ide.common.res2.ResourceItem first = this.myProjectItems.get(0);
            ResourceValue value = first.getResourceValue(false);
            if (value != null) {
                return value.getValue();
            }
            return null;
        }

        @Override
        @NotNull
        public List<Pair<FolderConfiguration, String>> getQualifiersAndValues() {
            ArrayList pairs = Lists.newArrayListWithCapacity((int)this.myProjectItems.size());
            for (com.android.ide.common.res2.ResourceItem item : this.myProjectItems) {
                ResourceValue resourceValue = item.getResourceValue(false);
                FolderConfiguration configuration = item.getConfiguration();
                pairs.add(Pair.create((Object)configuration, (Object)(resourceValue != null ? resourceValue.getValue() : null)));
            }
            ArrayList arrayList = pairs;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/ui/resourcechooser/ResourceChooserItem$ProjectItem", "getQualifiersAndValues"));
            }
            return arrayList;
        }
    }

    public static class FrameworkItem
    extends ResourceChooserItem {
        @NotNull
        private final ResourceItem myFrameworkItem;

        public FrameworkItem(@NotNull ResourceType type, @NotNull String name, @NotNull ResourceItem frameworkItem) {
            if (type == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/android/tools/idea/ui/resourcechooser/ResourceChooserItem$FrameworkItem", "<init>"));
            }
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/ui/resourcechooser/ResourceChooserItem$FrameworkItem", "<init>"));
            }
            if (frameworkItem == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "frameworkItem", "com/android/tools/idea/ui/resourcechooser/ResourceChooserItem$FrameworkItem", "<init>"));
            }
            super(type, name);
            this.myFrameworkItem = frameworkItem;
        }

        @Override
        public boolean isFramework() {
            return true;
        }

        @Override
        public File getFile() {
            return new File(((ResourceFile)this.myFrameworkItem.getSourceFileList().get(0)).getFile().getPath());
        }

        @Override
        @Nullable
        public String getPath() {
            return ((ResourceFile)this.myFrameworkItem.getSourceFileList().get(0)).getFile().getPath();
        }

        @Override
        @Nullable
        public String getFileForQualifiers(String qualifiers) {
            for (ResourceFile resourceFile : this.myFrameworkItem.getSourceFileList()) {
                String name = resourceFile.getFolder().getFolder().getName();
                if (!name.endsWith(qualifiers) || !qualifiers.equals(name.substring(name.indexOf(45) + 1))) continue;
                return resourceFile.getFile().getPath();
            }
            return null;
        }

        @Override
        @NotNull
        public String getResourceUrl() {
            String string = "@android:" + this.myType.getName() + '/' + this.myName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/ui/resourcechooser/ResourceChooserItem$FrameworkItem", "getResourceUrl"));
            }
            return string;
        }

        @Override
        @NotNull
        public List<String> getQualifiers() {
            HashSet set = Sets.newHashSet();
            for (ResourceFile resourceFile : this.myFrameworkItem.getSourceFileList()) {
                String folder = resourceFile.getFolder().getFolder().getName();
                int index = folder.indexOf(45);
                if (index == -1) {
                    set.add(ResourceChooserItem.DEFAULT_FOLDER_NAME);
                    continue;
                }
                set.add(folder.substring(index + 1));
            }
            ArrayList<String> qualifiers = new ArrayList<String>(set);
            Collections.sort(qualifiers);
            ArrayList<String> arrayList = qualifiers;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/ui/resourcechooser/ResourceChooserItem$FrameworkItem", "getQualifiers"));
            }
            return arrayList;
        }

        @Override
        public String getDefaultValue() {
            ResourceValue value;
            ResourceFile file = null;
            for (ResourceFile resourceFile : this.myFrameworkItem.getSourceFileList()) {
                FolderConfiguration configuration = resourceFile.getConfiguration();
                if (!configuration.isDefault()) continue;
                file = resourceFile;
                break;
            }
            if (file == null) {
                file = (ResourceFile)this.myFrameworkItem.getSourceFileList().get(0);
            }
            if ((value = file.getValue(this.getType(), this.getName())) != null) {
                return value.getValue();
            }
            return null;
        }

        @Override
        @NotNull
        public List<Pair<FolderConfiguration, String>> getQualifiersAndValues() {
            List sourceFileList = this.myFrameworkItem.getSourceFileList();
            ArrayList pairs = Lists.newArrayListWithCapacity((int)sourceFileList.size());
            ResourceType type = this.getType();
            String name = this.getName();
            for (ResourceFile resourceFile : sourceFileList) {
                ResourceValue resourceValue = resourceFile.getValue(type, name);
                FolderConfiguration configuration = resourceFile.getConfiguration();
                pairs.add(Pair.create((Object)configuration, (Object)(resourceValue != null ? resourceValue.getValue() : null)));
            }
            ArrayList arrayList = pairs;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/ui/resourcechooser/ResourceChooserItem$FrameworkItem", "getQualifiersAndValues"));
            }
            return arrayList;
        }
    }
}

