/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ui.validation.validators;

import com.android.repository.io.FileOp;
import com.android.repository.io.FileOpUtils;
import com.android.tools.idea.ui.validation.Validator;
import com.google.common.base.CharMatcher;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import net.jcip.annotations.Immutable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Immutable
public final class PathValidator
implements Validator<File> {
    public static final Rule IS_EMPTY = new SimpleRule(){

        @Override
        public boolean matches(@NotNull FileOp fileOp, @NotNull File file) {
            if (fileOp == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileOp", "com/android/tools/idea/ui/validation/validators/PathValidator$1", "matches"));
            }
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/ui/validation/validators/PathValidator$1", "matches"));
            }
            return file.getName().isEmpty();
        }

        @Override
        @NotNull
        public String getMessage(@NotNull File file, @NotNull String fieldName) {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/ui/validation/validators/PathValidator$1", "getMessage"));
            }
            if (fieldName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fieldName", "com/android/tools/idea/ui/validation/validators/PathValidator$1", "getMessage"));
            }
            String string = String.format("Please specify a %1$s.", fieldName);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/ui/validation/validators/PathValidator$1", "getMessage"));
            }
            return string;
        }
    };
    public static final Rule INVALID_SLASHES = new SimpleRule(){

        @Override
        public boolean matches(@NotNull FileOp fileOp, @NotNull File file) {
            if (fileOp == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileOp", "com/android/tools/idea/ui/validation/validators/PathValidator$2", "matches"));
            }
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/ui/validation/validators/PathValidator$2", "matches"));
            }
            String path = file.getPath();
            return File.separatorChar == '/' && path.contains("\\") || File.separatorChar == '\\' && path.contains("/");
        }

        @Override
        @NotNull
        public String getMessage(@NotNull File file, @NotNull String fieldName) {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/ui/validation/validators/PathValidator$2", "getMessage"));
            }
            if (fieldName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fieldName", "com/android/tools/idea/ui/validation/validators/PathValidator$2", "getMessage"));
            }
            if (File.separatorChar == '\\') {
                String string = String.format("Your %1$s contains incorrect slashes ('/').", fieldName);
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/ui/validation/validators/PathValidator$2", "getMessage"));
                }
                return string;
            }
            String string = String.format("Your %1$s contains incorrect slashes ('\\').", fieldName);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/ui/validation/validators/PathValidator$2", "getMessage"));
            }
            return string;
        }
    };
    public static final Rule WHITESPACE = new RecursiveRule(){

        @Override
        public boolean matches(@NotNull FileOp fileOp, @NotNull File file) {
            if (fileOp == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileOp", "com/android/tools/idea/ui/validation/validators/PathValidator$3", "matches"));
            }
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/ui/validation/validators/PathValidator$3", "matches"));
            }
            return CharMatcher.WHITESPACE.matchesAnyOf((CharSequence)file.getName());
        }

        @Override
        @NotNull
        public String getMessage(@NotNull File file, @NotNull String fieldName) {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/ui/validation/validators/PathValidator$3", "getMessage"));
            }
            if (fieldName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fieldName", "com/android/tools/idea/ui/validation/validators/PathValidator$3", "getMessage"));
            }
            String string = String.format("%1$s should not contain whitespace, as this can cause problems with the NDK tools.", fieldName);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/ui/validation/validators/PathValidator$3", "getMessage"));
            }
            return string;
        }
    };
    public static final Rule NON_ASCII_CHARS = new RecursiveRule(){

        @Override
        public boolean matches(@NotNull FileOp fileOp, @NotNull File file) {
            if (fileOp == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileOp", "com/android/tools/idea/ui/validation/validators/PathValidator$4", "matches"));
            }
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/ui/validation/validators/PathValidator$4", "matches"));
            }
            return !CharMatcher.ASCII.matchesAllOf((CharSequence)file.getName());
        }

        @Override
        @NotNull
        public String getMessage(@NotNull File file, @NotNull String fieldName) {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/ui/validation/validators/PathValidator$4", "getMessage"));
            }
            if (fieldName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fieldName", "com/android/tools/idea/ui/validation/validators/PathValidator$4", "getMessage"));
            }
            String string = String.format("Your %1$s contains non-ASCII characters.", fieldName);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/ui/validation/validators/PathValidator$4", "getMessage"));
            }
            return string;
        }
    };
    public static final Rule PARENT_DIRECTORY_NOT_WRITABLE = new RecursiveRule(){

        @Override
        protected boolean matches(@NotNull FileOp fileOp, @NotNull File file) {
            if (fileOp == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileOp", "com/android/tools/idea/ui/validation/validators/PathValidator$5", "matches"));
            }
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/ui/validation/validators/PathValidator$5", "matches"));
            }
            File parent = file.getParentFile();
            return !fileOp.exists(file) && parent != null && fileOp.exists(parent) && !fileOp.canWrite(parent);
        }

        @Override
        @NotNull
        public String getMessage(@NotNull File file, @NotNull String fieldName) {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/ui/validation/validators/PathValidator$5", "getMessage"));
            }
            if (fieldName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fieldName", "com/android/tools/idea/ui/validation/validators/PathValidator$5", "getMessage"));
            }
            String string = String.format("The path '%1$s' is not writable. Please choose a new location.", file.getParentFile().getPath());
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/ui/validation/validators/PathValidator$5", "getMessage"));
            }
            return string;
        }
    };
    public static final Rule LOCATION_IS_A_FILE = new SimpleRule(){

        @Override
        protected boolean matches(@NotNull FileOp fileOp, @NotNull File file) {
            if (fileOp == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileOp", "com/android/tools/idea/ui/validation/validators/PathValidator$6", "matches"));
            }
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/ui/validation/validators/PathValidator$6", "matches"));
            }
            return fileOp.isFile(file);
        }

        @Override
        @NotNull
        public String getMessage(@NotNull File file, @NotNull String fieldName) {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/ui/validation/validators/PathValidator$6", "getMessage"));
            }
            if (fieldName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fieldName", "com/android/tools/idea/ui/validation/validators/PathValidator$6", "getMessage"));
            }
            String string = String.format("The %1$s specified already exists.", fieldName);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/ui/validation/validators/PathValidator$6", "getMessage"));
            }
            return string;
        }
    };
    public static final Rule LOCATION_IS_ROOT = new SimpleRule(){

        @Override
        protected boolean matches(@NotNull FileOp fileOp, @NotNull File file) {
            if (fileOp == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileOp", "com/android/tools/idea/ui/validation/validators/PathValidator$7", "matches"));
            }
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/ui/validation/validators/PathValidator$7", "matches"));
            }
            return file.getParent() == null;
        }

        @Override
        @NotNull
        public String getMessage(@NotNull File file, @NotNull String fieldName) {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/ui/validation/validators/PathValidator$7", "getMessage"));
            }
            if (fieldName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fieldName", "com/android/tools/idea/ui/validation/validators/PathValidator$7", "getMessage"));
            }
            String string = String.format("The %1$s cannot be at the filesystem root.", fieldName);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/ui/validation/validators/PathValidator$7", "getMessage"));
            }
            return string;
        }
    };
    public static final Rule PARENT_IS_NOT_A_DIRECTORY = new SimpleRule(){

        @Override
        protected boolean matches(@NotNull FileOp fileOp, @NotNull File file) {
            if (fileOp == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileOp", "com/android/tools/idea/ui/validation/validators/PathValidator$8", "matches"));
            }
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/ui/validation/validators/PathValidator$8", "matches"));
            }
            File parent = file.getParentFile();
            return parent != null && fileOp.exists(parent) && !fileOp.isDirectory(parent);
        }

        @Override
        @NotNull
        public String getMessage(@NotNull File file, @NotNull String fieldName) {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/ui/validation/validators/PathValidator$8", "getMessage"));
            }
            if (fieldName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fieldName", "com/android/tools/idea/ui/validation/validators/PathValidator$8", "getMessage"));
            }
            String string = String.format("The %1$s's parent must be a directory, not a plain file.", fieldName);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/ui/validation/validators/PathValidator$8", "getMessage"));
            }
            return string;
        }
    };
    public static final Rule PATH_NOT_WRITABLE = new SimpleRule(){

        @Override
        protected boolean matches(@NotNull FileOp fileOp, @NotNull File file) {
            if (fileOp == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileOp", "com/android/tools/idea/ui/validation/validators/PathValidator$9", "matches"));
            }
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/ui/validation/validators/PathValidator$9", "matches"));
            }
            return fileOp.exists(file) && !fileOp.canWrite(file);
        }

        @Override
        @NotNull
        public String getMessage(@NotNull File file, @NotNull String fieldName) {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/ui/validation/validators/PathValidator$9", "getMessage"));
            }
            if (fieldName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fieldName", "com/android/tools/idea/ui/validation/validators/PathValidator$9", "getMessage"));
            }
            String string = String.format("The path '%1$s' is not writable. Please choose a new location.", file.getPath());
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/ui/validation/validators/PathValidator$9", "getMessage"));
            }
            return string;
        }
    };
    public static final Rule PATH_INSIDE_ANDROID_STUDIO = new SimpleRule(){

        @Override
        protected boolean matches(@NotNull FileOp fileOp, @NotNull File file) {
            if (fileOp == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileOp", "com/android/tools/idea/ui/validation/validators/PathValidator$10", "matches"));
            }
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/ui/validation/validators/PathValidator$10", "matches"));
            }
            String installLocation = PathManager.getHomePathFor(Application.class);
            return installLocation != null && FileUtil.isAncestor((File)new File(installLocation), (File)file, (boolean)false);
        }

        @Override
        @NotNull
        public String getMessage(@NotNull File file, @NotNull String fieldName) {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/ui/validation/validators/PathValidator$10", "getMessage"));
            }
            if (fieldName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fieldName", "com/android/tools/idea/ui/validation/validators/PathValidator$10", "getMessage"));
            }
            String applicationName = ApplicationNamesInfo.getInstance().getProductName();
            String string = String.format("The %1$s is inside %2$s's install location.", fieldName, applicationName);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/ui/validation/validators/PathValidator$10", "getMessage"));
            }
            return string;
        }
    };
    public static final Rule NON_EMPTY_DIRECTORY = new SimpleRule(){

        @Override
        protected boolean matches(@NotNull FileOp fileOp, @NotNull File file) {
            if (fileOp == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileOp", "com/android/tools/idea/ui/validation/validators/PathValidator$11", "matches"));
            }
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/ui/validation/validators/PathValidator$11", "matches"));
            }
            return fileOp.listFiles(file).length > 0;
        }

        @Override
        @NotNull
        public String getMessage(@NotNull File file, @NotNull String fieldName) {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/ui/validation/validators/PathValidator$11", "getMessage"));
            }
            if (fieldName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fieldName", "com/android/tools/idea/ui/validation/validators/PathValidator$11", "getMessage"));
            }
            String string = String.format("'%1s' already exists at the specified %2$s.", file.getName(), fieldName);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/ui/validation/validators/PathValidator$11", "getMessage"));
            }
            return string;
        }
    };
    public static final Rule ILLEGAL_WINDOWS_FILENAME = new RecursiveRule(){
        private final Set<String> RESERVED_WINDOWS_FILENAMES = ImmutableSet.of((Object)"con", (Object)"prn", (Object)"aux", (Object)"clock$", (Object)"nul", (Object)"com1", (Object[])new String[]{"com2", "com3", "com4", "com5", "com6", "com7", "com8", "com9", "lpt1", "lpt2", "lpt3", "lpt4", "lpt5", "lpt6", "lpt7", "lpt8", "lpt9", "$mft", "$mftmirr", "$logfile", "$volume", "$attrdef", "$bitmap", "$boot", "$badclus", "$secure", "$upcase", "$extend", "$quota", "$objid", "$reparse"});

        @Override
        public boolean matches(@NotNull FileOp fileOp, @NotNull File file) {
            if (fileOp == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileOp", "com/android/tools/idea/ui/validation/validators/PathValidator$12", "matches"));
            }
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/ui/validation/validators/PathValidator$12", "matches"));
            }
            return this.RESERVED_WINDOWS_FILENAMES.contains(file.getName().toLowerCase(Locale.US));
        }

        @Override
        @NotNull
        public String getMessage(@NotNull File file, @NotNull String fieldName) {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/ui/validation/validators/PathValidator$12", "getMessage"));
            }
            if (fieldName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fieldName", "com/android/tools/idea/ui/validation/validators/PathValidator$12", "getMessage"));
            }
            String string = String.format("Illegal (Windows) filename in %1$s path: %2$s.", fieldName, file.getName());
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/ui/validation/validators/PathValidator$12", "getMessage"));
            }
            return string;
        }
    };
    public static final Rule PATH_TOO_LONG = new SimpleRule(){
        private static final int WINDOWS_PATH_LENGTH_LIMIT = 100;

        @Override
        protected boolean matches(@NotNull FileOp fileOp, @NotNull File file) {
            if (fileOp == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileOp", "com/android/tools/idea/ui/validation/validators/PathValidator$13", "matches"));
            }
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/ui/validation/validators/PathValidator$13", "matches"));
            }
            return file.getAbsolutePath().length() > 100;
        }

        @Override
        @NotNull
        public String getMessage(@NotNull File file, @NotNull String fieldName) {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/ui/validation/validators/PathValidator$13", "getMessage"));
            }
            if (fieldName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fieldName", "com/android/tools/idea/ui/validation/validators/PathValidator$13", "getMessage"));
            }
            String string = String.format("The length of the %1$s exceeds the limit of %2$d characters.", fieldName, 100);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/ui/validation/validators/PathValidator$13", "getMessage"));
            }
            return string;
        }
    };
    public static final Rule ILLEGAL_CHARACTER = new RecursiveRule(){
        private final CharMatcher ILLEGAL_CHARACTER_MATCHER = CharMatcher.anyOf((CharSequence)"[/\\\\?%*:|\"<>!;]");

        @Override
        public boolean matches(@NotNull FileOp fileOp, @NotNull File file) {
            if (fileOp == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileOp", "com/android/tools/idea/ui/validation/validators/PathValidator$14", "matches"));
            }
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/ui/validation/validators/PathValidator$14", "matches"));
            }
            return this.ILLEGAL_CHARACTER_MATCHER.matchesAnyOf((CharSequence)file.getName());
        }

        @Override
        @NotNull
        public String getMessage(@NotNull File file, @NotNull String fieldName) {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/ui/validation/validators/PathValidator$14", "getMessage"));
            }
            if (fieldName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fieldName", "com/android/tools/idea/ui/validation/validators/PathValidator$14", "getMessage"));
            }
            String name = file.getName();
            char illegalChar = name.charAt(this.ILLEGAL_CHARACTER_MATCHER.indexIn((CharSequence)name));
            String string = String.format("Illegal character in %1$s path: '%2$c' in filename %3$s.", fieldName, Character.valueOf(illegalChar), name);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/ui/validation/validators/PathValidator$14", "getMessage"));
            }
            return string;
        }
    };
    @NotNull
    private final String myPathName;
    @NotNull
    private final Iterable<Rule> myErrors;
    @NotNull
    private final Iterable<Rule> myWarnings;
    @NotNull
    private final FileOp myFileOp;

    private PathValidator(@NotNull String pathName, @NotNull Iterable<Rule> errors, @NotNull Iterable<Rule> warnings, @NotNull FileOp fileOp) {
        if (pathName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pathName", "com/android/tools/idea/ui/validation/validators/PathValidator", "<init>"));
        }
        if (errors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errors", "com/android/tools/idea/ui/validation/validators/PathValidator", "<init>"));
        }
        if (warnings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "warnings", "com/android/tools/idea/ui/validation/validators/PathValidator", "<init>"));
        }
        if (fileOp == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileOp", "com/android/tools/idea/ui/validation/validators/PathValidator", "<init>"));
        }
        this.myPathName = pathName;
        this.myErrors = errors;
        this.myWarnings = warnings;
        this.myFileOp = fileOp;
    }

    public static PathValidator createDefault(@NotNull String pathName) {
        if (pathName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pathName", "com/android/tools/idea/ui/validation/validators/PathValidator", "createDefault"));
        }
        return new Builder().withAllRules(Validator.Severity.ERROR).build(pathName);
    }

    @Override
    @NotNull
    public Validator.Result validate(@NotNull File file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/ui/validation/validators/PathValidator", "validate"));
        }
        Validator.Result result = this.validate(file, Validator.Severity.ERROR);
        if (result != Validator.Result.OK) {
            Validator.Result result2 = result;
            if (result2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/ui/validation/validators/PathValidator", "validate"));
            }
            return result2;
        }
        result = this.validate(file, Validator.Severity.WARNING);
        if (result != Validator.Result.OK) {
            Validator.Result result3 = result;
            if (result3 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/ui/validation/validators/PathValidator", "validate"));
            }
            return result3;
        }
        Validator.Result result4 = Validator.Result.OK;
        if (result4 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/ui/validation/validators/PathValidator", "validate"));
        }
        return result4;
    }

    @NotNull
    private Validator.Result validate(@NotNull File projectFile, @NotNull Validator.Severity severity) {
        if (projectFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectFile", "com/android/tools/idea/ui/validation/validators/PathValidator", "validate"));
        }
        if (severity == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "severity", "com/android/tools/idea/ui/validation/validators/PathValidator", "validate"));
        }
        assert (severity != Validator.Severity.OK);
        Iterable<Rule> rules = severity == Validator.Severity.ERROR ? this.myErrors : this.myWarnings;
        for (Rule rule : rules) {
            File matchingFile = rule.getMatchingFile(this.myFileOp, projectFile);
            if (matchingFile == null) continue;
            Validator.Result result = new Validator.Result(severity, rule.getMessage(matchingFile, this.myPathName));
            if (result == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/ui/validation/validators/PathValidator", "validate"));
            }
            return result;
        }
        Validator.Result result = Validator.Result.OK;
        if (result == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/ui/validation/validators/PathValidator", "validate"));
        }
        return result;
    }

    private static abstract class RecursiveRule
    implements Rule {
        private RecursiveRule() {
        }

        @Override
        @Nullable
        public final File getMatchingFile(@NotNull FileOp fileOp, @NotNull File file) {
            if (fileOp == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileOp", "com/android/tools/idea/ui/validation/validators/PathValidator$RecursiveRule", "getMatchingFile"));
            }
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/ui/validation/validators/PathValidator$RecursiveRule", "getMatchingFile"));
            }
            for (File currFile = file; currFile != null; currFile = currFile.getParentFile()) {
                if (!this.matches(fileOp, currFile)) continue;
                return currFile;
            }
            return null;
        }

        protected abstract boolean matches(@NotNull FileOp var1, @NotNull File var2);
    }

    private static abstract class SimpleRule
    implements Rule {
        private SimpleRule() {
        }

        @Override
        @Nullable
        public final File getMatchingFile(@NotNull FileOp fileOp, @NotNull File file) {
            if (fileOp == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileOp", "com/android/tools/idea/ui/validation/validators/PathValidator$SimpleRule", "getMatchingFile"));
            }
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/ui/validation/validators/PathValidator$SimpleRule", "getMatchingFile"));
            }
            return this.matches(fileOp, file) ? file : null;
        }

        protected abstract boolean matches(@NotNull FileOp var1, @NotNull File var2);
    }

    public static class Builder {
        private final List<Rule> myErrors = Lists.newArrayList();
        private final List<Rule> myWarnings = Lists.newArrayList();

        @NotNull
        public Builder withAllRules(@NotNull Validator.Severity pathNotWritable) {
            if (pathNotWritable == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pathNotWritable", "com/android/tools/idea/ui/validation/validators/PathValidator$Builder", "withAllRules"));
            }
            this.withRule(IS_EMPTY, Validator.Severity.ERROR);
            this.withRule(PATH_NOT_WRITABLE, pathNotWritable);
            this.withRule(NON_EMPTY_DIRECTORY, Validator.Severity.WARNING);
            Builder builder = this.withCommonRules();
            if (builder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/ui/validation/validators/PathValidator$Builder", "withAllRules"));
            }
            return builder;
        }

        @NotNull
        public Builder withCommonRules() {
            this.withRule(INVALID_SLASHES, Validator.Severity.ERROR);
            this.withRule(ILLEGAL_CHARACTER, Validator.Severity.ERROR);
            this.withRule(ILLEGAL_WINDOWS_FILENAME, SystemInfo.isWindows ? Validator.Severity.ERROR : Validator.Severity.WARNING);
            this.withRule(WHITESPACE, Validator.Severity.WARNING);
            this.withRule(NON_ASCII_CHARS, SystemInfo.isWindows ? Validator.Severity.ERROR : Validator.Severity.WARNING);
            this.withRule(PARENT_DIRECTORY_NOT_WRITABLE, Validator.Severity.ERROR);
            this.withRule(PATH_TOO_LONG, Validator.Severity.ERROR);
            this.withRule(LOCATION_IS_A_FILE, Validator.Severity.ERROR);
            this.withRule(LOCATION_IS_ROOT, Validator.Severity.ERROR);
            this.withRule(PARENT_IS_NOT_A_DIRECTORY, Validator.Severity.ERROR);
            this.withRule(PATH_INSIDE_ANDROID_STUDIO, Validator.Severity.ERROR);
            Builder builder = this;
            if (builder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/ui/validation/validators/PathValidator$Builder", "withCommonRules"));
            }
            return builder;
        }

        public Builder withRule(@NotNull Rule rule, @NotNull Validator.Severity severity) {
            if (rule == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rule", "com/android/tools/idea/ui/validation/validators/PathValidator$Builder", "withRule"));
            }
            if (severity == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "severity", "com/android/tools/idea/ui/validation/validators/PathValidator$Builder", "withRule"));
            }
            switch (severity) {
                case ERROR: {
                    this.myErrors.add(rule);
                    break;
                }
                case WARNING: {
                    this.myWarnings.add(rule);
                    break;
                }
                default: {
                    throw new IllegalArgumentException(String.format("Can't create rule with invalid severity %1$s", new Object[]{severity}));
                }
            }
            return this;
        }

        @NotNull
        public PathValidator build(@NotNull String pathName) {
            if (pathName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pathName", "com/android/tools/idea/ui/validation/validators/PathValidator$Builder", "build"));
            }
            PathValidator pathValidator = this.build(pathName, FileOpUtils.create());
            if (pathValidator == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/ui/validation/validators/PathValidator$Builder", "build"));
            }
            return pathValidator;
        }

        @NotNull
        public PathValidator build(@NotNull String pathName, @NotNull FileOp fileOp) {
            if (pathName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pathName", "com/android/tools/idea/ui/validation/validators/PathValidator$Builder", "build"));
            }
            if (fileOp == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileOp", "com/android/tools/idea/ui/validation/validators/PathValidator$Builder", "build"));
            }
            PathValidator pathValidator = new PathValidator(pathName, this.myErrors, this.myWarnings, fileOp);
            if (pathValidator == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/ui/validation/validators/PathValidator$Builder", "build"));
            }
            return pathValidator;
        }
    }

    public static interface Rule {
        @Nullable
        public File getMatchingFile(@NotNull FileOp var1, @NotNull File var2);

        @NotNull
        public String getMessage(@NotNull File var1, @NotNull String var2);
    }
}

