/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.grid;

import com.android.tools.idea.uibuilder.api.DragHandler;
import com.android.tools.idea.uibuilder.api.DragType;
import com.android.tools.idea.uibuilder.api.InsertType;
import com.android.tools.idea.uibuilder.api.ViewEditor;
import com.android.tools.idea.uibuilder.api.ViewGroupHandler;
import com.android.tools.idea.uibuilder.graphics.NlDrawingStyle;
import com.android.tools.idea.uibuilder.graphics.NlGraphics;
import com.android.tools.idea.uibuilder.handlers.grid.GridInfo;
import com.android.tools.idea.uibuilder.model.Insets;
import com.android.tools.idea.uibuilder.model.NlComponent;
import com.google.common.annotations.VisibleForTesting;
import java.awt.Rectangle;
import java.util.List;
import org.jetbrains.annotations.NotNull;

final class GridDragHandler
extends DragHandler {
    private final GridInfo info;
    private int row;
    private int column;

    GridDragHandler(@NotNull ViewEditor editor, @NotNull ViewGroupHandler handler, @NotNull NlComponent layout, @NotNull List<NlComponent> components, @NotNull DragType type) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/android/tools/idea/uibuilder/handlers/grid/GridDragHandler", "<init>"));
        }
        if (handler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "com/android/tools/idea/uibuilder/handlers/grid/GridDragHandler", "<init>"));
        }
        if (layout == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "layout", "com/android/tools/idea/uibuilder/handlers/grid/GridDragHandler", "<init>"));
        }
        if (components == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "components", "com/android/tools/idea/uibuilder/handlers/grid/GridDragHandler", "<init>"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/android/tools/idea/uibuilder/handlers/grid/GridDragHandler", "<init>"));
        }
        super(editor, handler, layout, components, type);
        this.info = new GridInfo(layout);
    }

    @Override
    public void commit(int x, int y, int modifiers, @NotNull InsertType insertType) {
        if (insertType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "insertType", "com/android/tools/idea/uibuilder/handlers/grid/GridDragHandler", "commit"));
        }
        if (this.info.cellHasChild(this.row, this.column)) {
            return;
        }
        NlComponent[][] children = this.info.getChildren();
        NlComponent child = children[this.getStartRow()][this.getStartColumn()];
        int row = this.info.getRowSkippingEqualLineLocations(y);
        int column = this.info.getColumnSkippingEqualLineLocations(x);
        child.setAttribute("http://schemas.android.com/apk/res/android", "layout_row", Integer.toString(row));
        child.setAttribute("http://schemas.android.com/apk/res/android", "layout_column", Integer.toString(column));
        this.insertComponents(-1, insertType);
    }

    GridInfo getInfo() {
        return this.info;
    }

    @VisibleForTesting
    int getStartRow() {
        return this.info.getRow(this.startY);
    }

    @VisibleForTesting
    int getStartColumn() {
        return this.info.getColumn(this.startX);
    }

    @Override
    public String update(int x, int y, int modifiers) {
        String successful = super.update(x, y, modifiers);
        this.row = this.info.getRow(y);
        this.column = this.info.getColumn(x);
        return successful;
    }

    @Override
    public void paint(@NotNull NlGraphics graphics) {
        if (graphics == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "graphics", "com/android/tools/idea/uibuilder/handlers/grid/GridDragHandler", "paint"));
        }
        Insets padding = this.layout.getPadding();
        int layoutX1 = this.layout.x + padding.left;
        int layoutY1 = this.layout.y + padding.top;
        int layoutX2 = this.layout.x + padding.left + this.layout.w - padding.width() - 1;
        int layoutY2 = this.layout.y + padding.top + this.layout.h - padding.height() - 1;
        graphics.useStyle(NlDrawingStyle.DROP_ZONE);
        for (int x : this.info.getVerticalLineLocations()) {
            graphics.drawLine(x, layoutY1, x, layoutY2);
        }
        for (int y : this.info.getHorizontalLineLocations()) {
            graphics.drawLine(layoutX1, y, layoutX2, y);
        }
        graphics.useStyle(NlDrawingStyle.DROP_RECIPIENT);
        graphics.drawRect(layoutX1, layoutY1, this.layout.w - padding.width(), this.layout.h - padding.height());
        graphics.useStyle(this.info.cellHasChild(this.row, this.column) ? NlDrawingStyle.INVALID : NlDrawingStyle.DROP_ZONE_ACTIVE);
        Rectangle rectangle = this.getActiveDropZoneRectangle();
        graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    private Rectangle getActiveDropZoneRectangle() {
        int startRow;
        int startColumn = this.column;
        int endRow = this.row + 1;
        int endColumn = this.column + 1;
        if (this.info.cellHasChild(this.row, this.column)) {
            NlComponent[][] children = this.info.getChildren();
            for (startRow = this.row; startRow > 0 && children[this.row][this.column].equals(children[startRow - 1][this.column]); --startRow) {
            }
            while (startColumn > 0 && children[this.row][this.column].equals(children[this.row][startColumn - 1])) {
                --startColumn;
            }
            int rowCount = this.info.getRowCount();
            while (endRow < rowCount && children[this.row][this.column].equals(children[endRow][this.column])) {
                ++endRow;
            }
            int columnCount = this.info.getColumnCount();
            while (endColumn < columnCount && children[this.row][this.column].equals(children[this.row][endColumn])) {
                ++endColumn;
            }
        }
        int[] verticalLineLocations = this.info.getVerticalLineLocations();
        int[] horizontalLineLocations = this.info.getHorizontalLineLocations();
        int x = verticalLineLocations[startColumn];
        int y = horizontalLineLocations[startRow];
        int width = verticalLineLocations[endColumn] - x;
        int height = horizontalLineLocations[endRow] - y;
        return new Rectangle(x, y, width, height);
    }
}

