/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.preference;

import android.widget.ListView;
import com.android.ide.common.rendering.api.ViewInfo;
import com.android.tools.idea.uibuilder.api.DragHandler;
import com.android.tools.idea.uibuilder.api.DragType;
import com.android.tools.idea.uibuilder.api.InsertType;
import com.android.tools.idea.uibuilder.api.ViewEditor;
import com.android.tools.idea.uibuilder.api.ViewGroupHandler;
import com.android.tools.idea.uibuilder.graphics.NlDrawingStyle;
import com.android.tools.idea.uibuilder.graphics.NlGraphics;
import com.android.tools.idea.uibuilder.handlers.preference.ViewInfoUtils;
import com.android.tools.idea.uibuilder.model.NlComponent;
import java.awt.Rectangle;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

abstract class PreferenceGroupDragHandler
extends DragHandler {
    NlComponent myGroup;
    Map<NlComponent, Rectangle> myPreferenceToBoundsMap;
    NlComponent myActivePreference;
    private int myDividerHeight;

    PreferenceGroupDragHandler(@NotNull ViewEditor editor, @NotNull ViewGroupHandler handler, @NotNull NlComponent group, @NotNull List<NlComponent> preferences, @NotNull DragType type) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/android/tools/idea/uibuilder/handlers/preference/PreferenceGroupDragHandler", "<init>"));
        }
        if (handler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "com/android/tools/idea/uibuilder/handlers/preference/PreferenceGroupDragHandler", "<init>"));
        }
        if (group == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "group", "com/android/tools/idea/uibuilder/handlers/preference/PreferenceGroupDragHandler", "<init>"));
        }
        if (preferences == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "preferences", "com/android/tools/idea/uibuilder/handlers/preference/PreferenceGroupDragHandler", "<init>"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/android/tools/idea/uibuilder/handlers/preference/PreferenceGroupDragHandler", "<init>"));
        }
        super(editor, handler, group, preferences, type);
        this.myGroup = group;
        this.initDividerHeight();
        this.myPreferenceToBoundsMap = this.getPreferenceToBoundsMap(group);
    }

    private void initDividerHeight() {
        ViewInfo view = ViewInfoUtils.findListView(this.editor.getRootViews());
        assert (view != null);
        this.myDividerHeight = ((ListView)view.getViewObject()).getDividerHeight();
    }

    @NotNull
    final Map<NlComponent, Rectangle> getPreferenceToBoundsMap(@NotNull NlComponent group) {
        if (group == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "group", "com/android/tools/idea/uibuilder/handlers/preference/PreferenceGroupDragHandler", "getPreferenceToBoundsMap"));
        }
        Map<NlComponent, Rectangle> map = group.getChildren().stream().collect(Collectors.toMap(Function.identity(), this::getBounds));
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/handlers/preference/PreferenceGroupDragHandler", "getPreferenceToBoundsMap"));
        }
        return map;
    }

    @NotNull
    final Rectangle getBounds(@NotNull NlComponent preference) {
        if (preference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "preference", "com/android/tools/idea/uibuilder/handlers/preference/PreferenceGroupDragHandler", "getBounds"));
        }
        int height = preference.h + this.myDividerHeight;
        if (preference.getTagName().equals("PreferenceCategory")) {
            height += preference.getChildren().stream().mapToInt(child -> child.h + this.myDividerHeight).sum();
        }
        Rectangle rectangle = new Rectangle(preference.x, preference.y, preference.w, height);
        if (rectangle == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/handlers/preference/PreferenceGroupDragHandler", "getBounds"));
        }
        return rectangle;
    }

    final void updateActivePreference() {
        List<NlComponent> preferences = this.myGroup.getChildren();
        if (this.lastY < preferences.get((int)0).y) {
            this.myActivePreference = preferences.get(0);
        } else {
            Optional<NlComponent> activePreference = this.myPreferenceToBoundsMap.keySet().stream().filter(preference -> this.myPreferenceToBoundsMap.get(preference).contains(this.lastX, this.lastY)).findFirst();
            this.myActivePreference = activePreference.orElse(preferences.get(preferences.size() - 1));
        }
    }

    @Override
    public final void paint(@NotNull NlGraphics graphics) {
        if (graphics == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "graphics", "com/android/tools/idea/uibuilder/handlers/preference/PreferenceGroupDragHandler", "paint"));
        }
        this.drawDropPreviewLine(graphics);
        this.drawDropRecipientLines(graphics);
        this.drawDropZoneLines(graphics);
    }

    void drawDropPreviewLine(@NotNull NlGraphics graphics) {
        if (graphics == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "graphics", "com/android/tools/idea/uibuilder/handlers/preference/PreferenceGroupDragHandler", "drawDropPreviewLine"));
        }
        graphics.useStyle(NlDrawingStyle.DROP_PREVIEW);
        Rectangle bounds = this.myPreferenceToBoundsMap.get(this.myActivePreference);
        if (this.lastY < PreferenceGroupDragHandler.getMidpointY(bounds)) {
            graphics.drawTop(bounds);
        } else {
            graphics.drawBottom(bounds);
        }
    }

    abstract void drawDropRecipientLines(@NotNull NlGraphics var1);

    abstract void drawDropZoneLines(@NotNull NlGraphics var1);

    final void drawDropZoneLines(@NotNull NlGraphics graphics, int startingIndex) {
        if (graphics == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "graphics", "com/android/tools/idea/uibuilder/handlers/preference/PreferenceGroupDragHandler", "drawDropZoneLines"));
        }
        List<NlComponent> preferences = this.myGroup.getChildren();
        if (preferences.isEmpty()) {
            return;
        }
        graphics.useStyle(NlDrawingStyle.DROP_ZONE);
        int midpointY = this.getMidpointY(this.myActivePreference);
        int size = preferences.size();
        for (int i = startingIndex; i < size; ++i) {
            NlComponent preference = preferences.get(i);
            if (i != 0 && this.myActivePreference == preferences.get(i - 1)) {
                if (this.lastY >= midpointY) continue;
                graphics.drawTop(preference);
                continue;
            }
            if (this.myActivePreference == preference) {
                if (this.lastY < midpointY) continue;
                graphics.drawTop(preference);
                continue;
            }
            graphics.drawTop(preference);
        }
    }

    @Override
    public final void commit(int x, int y, int modifiers, @NotNull InsertType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/android/tools/idea/uibuilder/handlers/preference/PreferenceGroupDragHandler", "commit"));
        }
        List<NlComponent> preferences = this.myGroup.getChildren();
        if (preferences.isEmpty()) {
            this.insertComponents(-1, type);
            return;
        }
        int i = preferences.indexOf(this.myActivePreference);
        if (this.lastY >= this.getMidpointY(this.myActivePreference)) {
            ++i;
        }
        this.insertComponents(i == preferences.size() ? -1 : i, type);
    }

    final int getMidpointY(@NotNull NlComponent preference) {
        if (preference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "preference", "com/android/tools/idea/uibuilder/handlers/preference/PreferenceGroupDragHandler", "getMidpointY"));
        }
        return PreferenceGroupDragHandler.getMidpointY(this.myPreferenceToBoundsMap.get(preference));
    }

    static int getMidpointY(@NotNull Rectangle bounds) {
        if (bounds == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bounds", "com/android/tools/idea/uibuilder/handlers/preference/PreferenceGroupDragHandler", "getMidpointY"));
        }
        return bounds.y + bounds.height / 2;
    }
}

