/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.mockup.editor.creators;

import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.tools.idea.uibuilder.api.InsertType;
import com.android.tools.idea.uibuilder.mockup.Mockup;
import com.android.tools.idea.uibuilder.mockup.MockupFileHelper;
import com.android.tools.idea.uibuilder.mockup.editor.creators.FloatingActionButtonCreator;
import com.android.tools.idea.uibuilder.mockup.editor.creators.viewgroupattributes.ViewGroupAttributesManager;
import com.android.tools.idea.uibuilder.model.AttributesTransaction;
import com.android.tools.idea.uibuilder.model.NlComponent;
import com.android.tools.idea.uibuilder.model.NlModel;
import com.android.tools.idea.uibuilder.surface.ScreenView;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.xml.XmlTag;
import java.awt.Color;
import java.awt.Rectangle;
import java.nio.file.Path;
import java.util.Collections;
import javax.swing.JComponent;
import org.jetbrains.android.util.AndroidResourceUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class WidgetCreator {
    private static final String COLORS_XML = "colors.xml";
    private final NlModel myModel;
    private final ScreenView myScreenView;
    @NotNull
    private Mockup myMockup;
    @Nullable
    private NlComponent myComponent;
    @Nullable
    private ViewGroupAttributesManager myViewGroupAttributesManager;

    protected WidgetCreator(@NotNull Mockup mockup, @NotNull NlModel model, @NotNull ScreenView screenView) {
        if (mockup == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mockup", "com/android/tools/idea/uibuilder/mockup/editor/creators/WidgetCreator", "<init>"));
        }
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/android/tools/idea/uibuilder/mockup/editor/creators/WidgetCreator", "<init>"));
        }
        if (screenView == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "screenView", "com/android/tools/idea/uibuilder/mockup/editor/creators/WidgetCreator", "<init>"));
        }
        this.myMockup = mockup;
        this.myModel = model;
        this.myScreenView = screenView;
    }

    protected static void createColorResource(@NotNull String colorName, @NotNull Color color, @NotNull NlModel model) {
        if (colorName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "colorName", "com/android/tools/idea/uibuilder/mockup/editor/creators/WidgetCreator", "createColorResource"));
        }
        if (color == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "color", "com/android/tools/idea/uibuilder/mockup/editor/creators/WidgetCreator", "createColorResource"));
        }
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/android/tools/idea/uibuilder/mockup/editor/creators/WidgetCreator", "createColorResource"));
        }
        if (colorName.isEmpty()) {
            Logger.getInstance(FloatingActionButtonCreator.class).error("The color name can't be empty. Aborting color resource creation");
            return;
        }
        VirtualFile primaryResourceDir = model.getFacet().getPrimaryResourceDir();
        FolderConfiguration configForFolder = FolderConfiguration.getConfigForFolder((String)ResourceFolderType.VALUES.getName());
        if (primaryResourceDir != null && configForFolder != null) {
            AndroidResourceUtil.createValueResource(model.getProject(), primaryResourceDir, colorName, ResourceType.COLOR, COLORS_XML, Collections.singletonList(configForFolder.getFolderName(ResourceFolderType.VALUES)), String.format("#%06X", color.getRGB()));
        }
    }

    public void setViewGroupAttributesManager(@Nullable ViewGroupAttributesManager viewGroupAttributesManager) {
        this.myViewGroupAttributesManager = viewGroupAttributesManager;
    }

    @NotNull
    protected final Mockup getMockup() {
        Mockup mockup = this.myMockup;
        if (mockup == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/mockup/editor/creators/WidgetCreator", "getMockup"));
        }
        return mockup;
    }

    protected final NlModel getModel() {
        return this.myModel;
    }

    @NotNull
    public ScreenView getScreenView() {
        ScreenView screenView = this.myScreenView;
        if (screenView == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/mockup/editor/creators/WidgetCreator", "getScreenView"));
        }
        return screenView;
    }

    protected abstract void addAttributes(@NotNull AttributesTransaction var1);

    @Nullable
    public NlComponent addToModel() {
        this.ensureNewComponentCreated();
        assert (this.myComponent != null);
        AttributesTransaction transaction = this.myComponent.startAttributeTransaction();
        this.addAttributes(transaction);
        if (this.myViewGroupAttributesManager != null) {
            this.myViewGroupAttributesManager.addLayoutAttributes(transaction);
        }
        transaction.commit();
        this.myModel.addComponents(Collections.singletonList(this.myComponent), this.myMockup.getComponent(), null, InsertType.CREATE_PREVIEW);
        return this.myComponent;
    }

    public boolean hasOptionsComponent() {
        return false;
    }

    @Nullable
    public JComponent getOptionsComponent(@NotNull DoneCallback doneCallback) {
        if (doneCallback == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "doneCallback", "com/android/tools/idea/uibuilder/mockup/editor/creators/WidgetCreator", "getOptionsComponent"));
        }
        return null;
    }

    protected void addSizeAttributes(@NotNull AttributesTransaction transaction, @NotNull Rectangle bounds) {
        if (transaction == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "transaction", "com/android/tools/idea/uibuilder/mockup/editor/creators/WidgetCreator", "addSizeAttributes"));
        }
        if (bounds == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bounds", "com/android/tools/idea/uibuilder/mockup/editor/creators/WidgetCreator", "addSizeAttributes"));
        }
        transaction.setAttribute(null, "android:layout_width", String.format("%ddp", WidgetCreator.pxToDp(this.myModel, bounds.width)));
        transaction.setAttribute(null, "android:layout_height", String.format("%ddp", WidgetCreator.pxToDp(this.myModel, bounds.height)));
    }

    protected void addLayoutEditorPositionAttribute(@NotNull AttributesTransaction transaction, @NotNull Rectangle bounds) {
        if (transaction == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "transaction", "com/android/tools/idea/uibuilder/mockup/editor/creators/WidgetCreator", "addLayoutEditorPositionAttribute"));
        }
        if (bounds == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bounds", "com/android/tools/idea/uibuilder/mockup/editor/creators/WidgetCreator", "addLayoutEditorPositionAttribute"));
        }
        transaction.setAttribute("http://schemas.android.com/tools", "layout_editor_absoluteX", String.format("%ddp", WidgetCreator.pxToDp(this.myModel, bounds.x)));
        transaction.setAttribute("http://schemas.android.com/tools", "layout_editor_absoluteY", String.format("%ddp", WidgetCreator.pxToDp(this.myModel, bounds.y)));
    }

    protected void addMockupAttributes(@NotNull AttributesTransaction transaction, @NotNull Rectangle bounds) {
        if (transaction == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "transaction", "com/android/tools/idea/uibuilder/mockup/editor/creators/WidgetCreator", "addMockupAttributes"));
        }
        if (bounds == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bounds", "com/android/tools/idea/uibuilder/mockup/editor/creators/WidgetCreator", "addMockupAttributes"));
        }
        this.ensureNewComponentCreated();
        assert (this.myComponent != null);
        Mockup newMockup = Mockup.create(this.myComponent, true);
        if (newMockup == null) {
            return;
        }
        Rectangle cropping = this.myMockup.getComputedCropping();
        newMockup.setCropping(cropping.x + bounds.x, cropping.y + bounds.y, bounds.width, bounds.height);
        transaction.setAttribute("http://schemas.android.com/tools", "mockup_crop", MockupFileHelper.getPositionString(newMockup));
        transaction.setAttribute("http://schemas.android.com/tools", "mockup", WidgetCreator.getMockupImagePath(this.myMockup));
    }

    private void ensureNewComponentCreated() {
        if (this.myComponent == null) {
            XmlTag parentTag = this.myMockup.getComponent().getTag();
            XmlTag childTag = parentTag.createChildTag(this.getAndroidViewTag(), null, null, false);
            this.myComponent = new NlComponent(this.myModel, childTag);
        }
    }

    @NotNull
    private static String getMockupImagePath(@NotNull Mockup mockup) {
        if (mockup == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mockup", "com/android/tools/idea/uibuilder/mockup/editor/creators/WidgetCreator", "getMockupImagePath"));
        }
        Path xmlFilePath = MockupFileHelper.getXMLFilePath(mockup.getComponent().getModel().getProject(), mockup.getFilePath());
        String string = xmlFilePath != null ? xmlFilePath.toString() : "";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/mockup/editor/creators/WidgetCreator", "getMockupImagePath"));
        }
        return string;
    }

    protected static int pxToDp(@NotNull NlModel model, int px) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/android/tools/idea/uibuilder/mockup/editor/creators/WidgetCreator", "pxToDp"));
        }
        float dpiValue = model.getConfiguration().getDensity().getDpiValue();
        return Math.round((float)px * (160.0f / dpiValue));
    }

    @NotNull
    public abstract String getAndroidViewTag();

    public static class ColorResourceHolder {
        @Nullable
        public Color value;
        @Nullable
        public String name;

        public ColorResourceHolder(@Nullable Color value, @Nullable String name) {
            this.value = value;
            this.name = name;
        }
    }

    public static interface DoneCallback {
        public static final int FINISH = 1;
        public static final int CANCEL = 0;

        public void done(int var1);
    }
}

