/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.property.editors;

import com.android.sdklib.IAndroidTarget;
import com.android.tools.idea.uibuilder.property.NlProperty;
import com.android.tools.idea.uibuilder.property.editors.BrowsePanel;
import com.android.tools.idea.uibuilder.property.editors.NlBaseComponentEditor;
import com.android.tools.idea.uibuilder.property.editors.NlComponentEditor;
import com.android.tools.idea.uibuilder.property.editors.NlEditingListener;
import com.android.tools.idea.uibuilder.property.editors.NlTableCellEditor;
import com.android.tools.idea.uibuilder.property.editors.support.EnumSupport;
import com.android.tools.idea.uibuilder.property.editors.support.EnumSupportFactory;
import com.android.tools.idea.uibuilder.property.editors.support.Quantity;
import com.android.tools.idea.uibuilder.property.editors.support.ValueWithDisplayString;
import com.intellij.ide.ui.laf.darcula.ui.DarculaComboBoxUI;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.JBColor;
import com.intellij.util.ui.JBUI;
import com.sun.java.swing.plaf.windows.WindowsComboBoxUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.List;
import java.util.Objects;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.plaf.ComboBoxUI;
import org.jetbrains.android.dom.attrs.AttributeDefinition;
import org.jetbrains.android.dom.attrs.AttributeFormat;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NlEnumEditor
extends NlBaseComponentEditor
implements NlComponentEditor {
    private static final int SMALL_WIDTH = 65;
    private final JPanel myPanel;
    private final CustomComboBox myCombo;
    private final JTextField myEditor;
    private final BrowsePanel myBrowsePanel;
    private EnumSupport myEnumSupport;
    private NlProperty myProperty;
    private String myApiVersion;
    private int myAddedValueIndex;
    private boolean myPopupValueChanged;
    private boolean myDisplayRealValue;

    public static NlTableCellEditor createForTable() {
        NlTableCellEditor cellEditor = new NlTableCellEditor();
        cellEditor.init(new NlEnumEditor(cellEditor, new CustomComboBox(), new BrowsePanel(cellEditor, true), false));
        return cellEditor;
    }

    public static NlEnumEditor createForInspector(@NotNull NlEditingListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/android/tools/idea/uibuilder/property/editors/NlEnumEditor", "createForInspector"));
        }
        return new NlEnumEditor(listener, new CustomComboBox(), null, true);
    }

    public static NlEnumEditor createForInspectorWithBrowseButton(@NotNull NlEditingListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/android/tools/idea/uibuilder/property/editors/NlEnumEditor", "createForInspectorWithBrowseButton"));
        }
        BrowsePanel.ContextDelegate delegate = new BrowsePanel.ContextDelegate();
        NlEnumEditor editor = new NlEnumEditor(listener, new CustomComboBox(), new BrowsePanel(delegate, false), true);
        delegate.setEditor(editor);
        return editor;
    }

    public static NlEnumEditor createForTest(@NotNull NlEditingListener listener, CustomComboBox comboBox) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/android/tools/idea/uibuilder/property/editors/NlEnumEditor", "createForTest"));
        }
        return new NlEnumEditor(listener, comboBox, null, false);
    }

    private NlEnumEditor(@NotNull NlEditingListener listener, @NotNull CustomComboBox comboBox, @Nullable BrowsePanel browsePanel, boolean includeBorder) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/android/tools/idea/uibuilder/property/editors/NlEnumEditor", "<init>"));
        }
        if (comboBox == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "comboBox", "com/android/tools/idea/uibuilder/property/editors/NlEnumEditor", "<init>"));
        }
        super(listener);
        this.myAddedValueIndex = -1;
        this.myPanel = new JPanel(new BorderLayout(HORIZONTAL_COMPONENT_GAP, 0));
        this.myBrowsePanel = browsePanel;
        this.myCombo = comboBox;
        this.myCombo.setEditable(true);
        this.myCombo.addPopupMenuListener(new PopupMenuHandler());
        this.myCombo.addActionListener(this::comboValuePicked);
        if (includeBorder) {
            this.myCombo.setBorderPanel(this.myPanel);
        }
        this.myPanel.add((Component)((Object)this.myCombo), "Center");
        if (browsePanel != null) {
            this.myPanel.add((Component)browsePanel, "After");
        }
        this.myEditor = (JTextField)this.myCombo.getEditor().getEditorComponent();
        this.myEditor.registerKeyboardAction(event -> this.enter(), KeyStroke.getKeyStroke(10, 0), 0);
        this.myEditor.registerKeyboardAction(event -> this.cancel(), KeyStroke.getKeyStroke(27, 0), 0);
        this.myEditor.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                NlEnumEditor.this.myDisplayRealValue = true;
                ValueWithDisplayString value = NlEnumEditor.this.myCombo.getSelectedItem();
                value.setUseValueForToString(NlEnumEditor.this.myDisplayRealValue);
                NlEnumEditor.this.myEditor.setText(value.toString());
                NlEnumEditor.this.myEditor.selectAll();
                NlEnumEditor.this.myEditor.setForeground((Color)NlBaseComponentEditor.CHANGED_VALUE_TEXT_COLOR);
            }

            @Override
            public void focusLost(FocusEvent event) {
                NlEnumEditor.this.myDisplayRealValue = false;
                ValueWithDisplayString value = NlEnumEditor.this.createFromEditorValue(NlEnumEditor.this.myEditor.getText());
                if (!Objects.equals(value.getValue(), NlEnumEditor.this.myProperty.getValue())) {
                    NlEnumEditor.this.stopEditing(value.getValue());
                }
                value.setUseValueForToString(NlEnumEditor.this.myDisplayRealValue);
                NlEnumEditor.this.myEditor.setText(value.toString());
                NlEnumEditor.this.myEditor.setForeground((Color)(value.getValue() != null ? NlBaseComponentEditor.CHANGED_VALUE_TEXT_COLOR : NlBaseComponentEditor.DEFAULT_VALUE_TEXT_COLOR));
                NlEnumEditor.this.myEditor.select(0, 0);
            }
        });
        this.myCombo.setRenderer((ListCellRenderer)((Object)new EnumRenderer()));
    }

    @Override
    public void setEnabled(boolean en) {
        this.myCombo.setEnabled(en);
    }

    @Override
    public void setProperty(@NotNull NlProperty property) {
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "com/android/tools/idea/uibuilder/property/editors/NlEnumEditor", "setProperty"));
        }
        if (property != this.myProperty || !NlEnumEditor.getApiVersion(property).equals(this.myApiVersion)) {
            this.setModel(property);
        }
        if (this.myBrowsePanel != null) {
            this.myBrowsePanel.setProperty(property);
        }
        this.selectItem(this.createFromEditorValue(property.getValue()));
    }

    @Override
    public void requestFocus() {
        this.myCombo.requestFocus();
    }

    private void setModel(@NotNull NlProperty property) {
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "com/android/tools/idea/uibuilder/property/editors/NlEnumEditor", "setModel"));
        }
        assert (EnumSupportFactory.supportsProperty(property)) : this.getClass().getName() + property;
        this.myEnumSupport = EnumSupportFactory.create(property);
        this.myProperty = property;
        this.myApiVersion = NlEnumEditor.getApiVersion(property);
        List<ValueWithDisplayString> values = this.myEnumSupport.getAllValues();
        ValueWithDisplayString[] valueArray = values.toArray(new ValueWithDisplayString[0]);
        DefaultComboBoxModel<ValueWithDisplayString> newModel = new DefaultComboBoxModel<ValueWithDisplayString>(valueArray){

            @Override
            public void setSelectedItem(Object object) {
                if (object instanceof String) {
                    object = NlEnumEditor.this.createFromEditorValue((String)object);
                }
                if (object instanceof ValueWithDisplayString) {
                    ValueWithDisplayString value = (ValueWithDisplayString)object;
                    value.setUseValueForToString(NlEnumEditor.this.myDisplayRealValue);
                }
                super.setSelectedItem(object);
            }
        };
        ValueWithDisplayString defaultValue = this.createFromEditorValue(null);
        newModel.insertElementAt(defaultValue, 0);
        this.myCombo.setModel(newModel);
        this.myAddedValueIndex = -1;
    }

    @Override
    @Nullable
    public NlProperty getProperty() {
        return this.myProperty;
    }

    @NotNull
    private static String getApiVersion(@NotNull NlProperty property) {
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "com/android/tools/idea/uibuilder/property/editors/NlEnumEditor", "getApiVersion"));
        }
        IAndroidTarget target = property.getModel().getConfiguration().getTarget();
        String string = target == null ? "25U" : target.getVersion().getApiString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/property/editors/NlEnumEditor", "getApiVersion"));
        }
        return string;
    }

    private void selectItem(@NotNull ValueWithDisplayString value) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/android/tools/idea/uibuilder/property/editors/NlEnumEditor", "selectItem"));
        }
        DefaultComboBoxModel model = (DefaultComboBoxModel)this.myCombo.getModel();
        int index = model.getIndexOf(value);
        if (index == -1) {
            if (this.myAddedValueIndex >= 0) {
                model.removeElementAt(this.myAddedValueIndex);
            }
            this.myAddedValueIndex = this.findBestInsertionPoint(value);
            model.insertElementAt(value, this.myAddedValueIndex);
        }
        if (!value.equals(model.getSelectedItem())) {
            value.setUseValueForToString(this.myDisplayRealValue);
            model.setSelectedItem(value);
            this.myEditor.setText(value.toString());
        }
        this.myEditor.setForeground((Color)(value.getValue() != null ? CHANGED_VALUE_TEXT_COLOR : DEFAULT_VALUE_TEXT_COLOR));
    }

    private int findBestInsertionPoint(@NotNull ValueWithDisplayString newValue) {
        if (newValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newValue", "com/android/tools/idea/uibuilder/property/editors/NlEnumEditor", "findBestInsertionPoint"));
        }
        AttributeDefinition definition = this.myProperty.getDefinition();
        boolean isDimension = definition != null && definition.getFormats().contains((Object)AttributeFormat.Dimension);
        int startIndex = 1;
        if (!isDimension) {
            return startIndex;
        }
        String newTextValue = newValue.getDisplayString();
        if (StringUtil.isEmpty((String)newTextValue)) {
            return startIndex;
        }
        Quantity newQuantity = Quantity.parse(newTextValue);
        if (newQuantity == null) {
            return startIndex;
        }
        ComboBoxModel<ValueWithDisplayString> model = this.myCombo.getModel();
        int size = model.getSize();
        for (int index = startIndex; index < size; ++index) {
            Quantity quantity;
            String textValue = ((ValueWithDisplayString)model.getElementAt(index)).getValue();
            if (textValue == null || newQuantity.compareTo(quantity = Quantity.parse(textValue)) > 0) continue;
            return index;
        }
        return model.getSize();
    }

    @Override
    @Nullable
    public Object getValue() {
        ValueWithDisplayString value = this.myCombo.getSelectedItem();
        if (value == null) {
            return null;
        }
        return value.getValue();
    }

    @Override
    @NotNull
    public JComponent getComponent() {
        JPanel jPanel = this.myPanel;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/property/editors/NlEnumEditor", "getComponent"));
        }
        return jPanel;
    }

    @NotNull
    public Component getKeySource() {
        JTextField jTextField = this.myEditor;
        if (jTextField == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/property/editors/NlEnumEditor", "getKeySource"));
        }
        return jTextField;
    }

    private void enter() {
        if (!this.myCombo.isPopupVisible()) {
            ValueWithDisplayString value = this.createFromEditorValue(this.myEditor.getText());
            this.selectItem(value);
            this.stopEditing(value.getValue());
            this.myCombo.getEditor().selectAll();
        }
        this.myCombo.hidePopup();
    }

    private void cancel() {
        String text = this.myProperty.getValue();
        this.myCombo.getEditor().setItem(text);
        ValueWithDisplayString value = this.createFromEditorValue(this.myProperty.getValue());
        this.selectItem(value);
        this.myPopupValueChanged = false;
        this.cancelEditing();
        this.myCombo.getEditor().selectAll();
        this.myCombo.hidePopup();
    }

    @NotNull
    private ValueWithDisplayString createFromEditorValue(@Nullable String editorValue) {
        assert (this.myEnumSupport != null) : "EnumSupport should have been setup by setModel";
        ValueWithDisplayString valueWithDisplayString = this.myEnumSupport.createValue(StringUtil.notNullize((String)editorValue));
        if (valueWithDisplayString == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/property/editors/NlEnumEditor", "createFromEditorValue"));
        }
        return valueWithDisplayString;
    }

    private void comboValuePicked(@NotNull ActionEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/android/tools/idea/uibuilder/property/editors/NlEnumEditor", "comboValuePicked"));
        }
        if ("comboBoxChanged".equals(event.getActionCommand())) {
            this.myPopupValueChanged = true;
        }
    }

    private class PopupMenuHandler
    implements PopupMenuListener {
        private PopupMenuHandler() {
        }

        @Override
        public void popupMenuWillBecomeVisible(PopupMenuEvent event) {
            NlEnumEditor.this.myPopupValueChanged = false;
        }

        @Override
        public void popupMenuWillBecomeInvisible(PopupMenuEvent event) {
            if (NlEnumEditor.this.myPopupValueChanged) {
                NlEnumEditor.this.myPopupValueChanged = false;
                ValueWithDisplayString value = (ValueWithDisplayString)NlEnumEditor.this.myCombo.getModel().getSelectedItem();
                value.setUseValueForToString(NlEnumEditor.this.myDisplayRealValue);
                NlEnumEditor.this.stopEditing(value.getValue());
            }
        }

        @Override
        public void popupMenuCanceled(PopupMenuEvent event) {
            NlEnumEditor.this.myPopupValueChanged = false;
        }
    }

    private class EnumRenderer
    extends ColoredListCellRenderer<ValueWithDisplayString> {
        private EnumRenderer() {
        }

        public Component getListCellRendererComponent(JList<? extends ValueWithDisplayString> list, ValueWithDisplayString value, int index, boolean selected, boolean hasFocus) {
            if (value == ValueWithDisplayString.SEPARATOR) {
                return new JSeparator();
            }
            return super.getListCellRendererComponent(list, (Object)value, index, selected, hasFocus);
        }

        protected void customizeCellRenderer(@NotNull JList list, ValueWithDisplayString value, int index, boolean selected, boolean hasFocus) {
            if (list == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/android/tools/idea/uibuilder/property/editors/NlEnumEditor$EnumRenderer", "customizeCellRenderer"));
            }
            if (value != null) {
                String displayString = value.getDisplayString();
                String actualValue = value.getValue();
                String hint = value.getHint();
                boolean isDefaultValue = NlEnumEditor.this.myProperty.isDefaultValue(actualValue);
                if (!selected && !isDefaultValue && Objects.equals(actualValue, NlEnumEditor.this.getValue())) {
                    this.myForeground = NlBaseComponentEditor.CHANGED_VALUE_TEXT_COLOR;
                } else if (index == 0 || isDefaultValue) {
                    this.myForeground = NlBaseComponentEditor.DEFAULT_VALUE_TEXT_COLOR;
                }
                if (!StringUtil.isEmpty((String)displayString)) {
                    this.append(displayString);
                    if (!StringUtil.isEmpty((String)hint)) {
                        this.myForeground = NlBaseComponentEditor.DEFAULT_VALUE_TEXT_COLOR;
                        this.append(" [");
                        this.append(hint);
                        this.append("]");
                    }
                } else if (actualValue != null) {
                    this.append(actualValue);
                }
            }
        }
    }

    private static class CustomDarculaComboBoxUI
    extends DarculaComboBoxUI {
        public CustomDarculaComboBoxUI(@NotNull JComboBox comboBox) {
            if (comboBox == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "comboBox", "com/android/tools/idea/uibuilder/property/editors/NlEnumEditor$CustomDarculaComboBoxUI", "<init>"));
            }
            super(comboBox);
        }

        protected Insets getInsets() {
            return JBUI.insets((int)2, (int)7, (int)2, (int)4).asUIResource();
        }

        @NotNull
        protected Color getArrowButtonFillColor(@NotNull Color defaultColor) {
            if (defaultColor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "defaultColor", "com/android/tools/idea/uibuilder/property/editors/NlEnumEditor$CustomDarculaComboBoxUI", "getArrowButtonFillColor"));
            }
            JBColor jBColor = JBColor.LIGHT_GRAY;
            if (jBColor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/property/editors/NlEnumEditor$CustomDarculaComboBoxUI", "getArrowButtonFillColor"));
            }
            return jBColor;
        }
    }

    public static class CustomComboBox
    extends ComboBox {
        private JPanel myBorderPanel;
        private boolean myUseDarculaUI;

        public CustomComboBox() {
            super(65);
            this.setBorders();
        }

        public void setBorderPanel(@NotNull JPanel borderPanel) {
            if (borderPanel == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "borderPanel", "com/android/tools/idea/uibuilder/property/editors/NlEnumEditor$CustomComboBox", "setBorderPanel"));
            }
            this.myBorderPanel = borderPanel;
            this.setBorders();
        }

        public ComboBoxModel<ValueWithDisplayString> getModel() {
            return super.getModel();
        }

        public ValueWithDisplayString getSelectedItem() {
            return (ValueWithDisplayString)super.getSelectedItem();
        }

        private void setBorders() {
            int horizontalSpacing;
            int n = horizontalSpacing = this.myUseDarculaUI ? 0 : 1;
            if (this.myBorderPanel != null) {
                this.myBorderPanel.setBorder(BorderFactory.createEmptyBorder(2, horizontalSpacing, 2, 0));
            }
            this.setBorder(this.myUseDarculaUI && this.myBorderPanel != null ? null : BorderFactory.createEmptyBorder(1, 4, 1, 4));
        }

        public void setUI(ComboBoxUI ui) {
            boolean bl = this.myUseDarculaUI = !(ui instanceof WindowsComboBoxUI) && !ApplicationManager.getApplication().isUnitTestMode();
            if (this.myUseDarculaUI) {
                ui = new CustomDarculaComboBoxUI((JComboBox)((Object)this));
            }
            super.setUI(ui);
            this.setBorders();
        }
    }
}

