/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.property.editors.support;

import com.android.tools.idea.uibuilder.property.NlProperty;
import java.util.Comparator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.android.dom.attrs.AttributeDefinition;
import org.jetbrains.android.dom.attrs.AttributeFormat;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Quantity
implements Comparable<Quantity> {
    private static final Pattern QUANTITY_PATTERN = Pattern.compile("^(-?\\d+(\\.\\d+)?)(.*)$");
    private final int myValue;
    private final String myUnit;

    @Nullable
    public static Quantity parse(@NotNull String value) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/android/tools/idea/uibuilder/property/editors/support/Quantity", "parse"));
        }
        Matcher matcher = QUANTITY_PATTERN.matcher(value);
        if (!matcher.matches()) {
            return null;
        }
        try {
            return new Quantity(Integer.parseInt(matcher.group(1)), matcher.group(3).trim());
        }
        catch (NumberFormatException ignore) {
            return null;
        }
    }

    @NotNull
    public static String addUnit(@NotNull NlProperty property, @NotNull String value) {
        boolean isDimension;
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "com/android/tools/idea/uibuilder/property/editors/support/Quantity", "addUnit"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/android/tools/idea/uibuilder/property/editors/support/Quantity", "addUnit"));
        }
        AttributeDefinition definition = property.getDefinition();
        boolean bl = isDimension = definition != null && definition.getFormats().contains((Object)AttributeFormat.Dimension);
        if (!isDimension) {
            String string = value;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/property/editors/support/Quantity", "addUnit"));
            }
            return string;
        }
        Quantity quantity = Quantity.parse(value);
        if (quantity == null || !quantity.myUnit.isEmpty()) {
            String string = value;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/property/editors/support/Quantity", "addUnit"));
            }
            return string;
        }
        switch (property.getName()) {
            case "textSize": 
            case "lineSpacingExtra": {
                String string = quantity.myValue + "sp";
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/property/editors/support/Quantity", "addUnit"));
                }
                return string;
            }
        }
        String string = quantity.myValue + "dp";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/property/editors/support/Quantity", "addUnit"));
        }
        return string;
    }

    private Quantity(int value, @NotNull String unit) {
        if (unit == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "unit", "com/android/tools/idea/uibuilder/property/editors/support/Quantity", "<init>"));
        }
        this.myValue = value;
        this.myUnit = unit;
    }

    public int getValue() {
        return this.myValue;
    }

    @NotNull
    public String getUnit() {
        String string = this.myUnit;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/property/editors/support/Quantity", "getUnit"));
        }
        return string;
    }

    @Override
    public int compareTo(@Nullable Quantity other) {
        if (other == null) {
            return -1;
        }
        return Comparator.comparing(Quantity::getUnit).thenComparing(Quantity::getValue).compare(this, other);
    }
}

