/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.property.editors.support;

import com.android.ide.common.rendering.api.StyleResourceValue;
import com.android.ide.common.resources.ResourceResolver;
import com.android.tools.idea.uibuilder.property.NlProperty;
import com.android.tools.idea.uibuilder.property.editors.support.EnumSupport;
import com.android.tools.idea.uibuilder.property.editors.support.StyleFilter;
import com.android.tools.idea.uibuilder.property.editors.support.ValueWithDisplayString;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StyleEnumSupport
extends EnumSupport {
    protected final StyleFilter myStyleFilter;

    public StyleEnumSupport(@NotNull NlProperty property) {
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "com/android/tools/idea/uibuilder/property/editors/support/StyleEnumSupport", "<init>"));
        }
        this(property, new StyleFilter(property.getModel().getProject(), property.getResolver()));
    }

    StyleEnumSupport(@NotNull NlProperty property, @NotNull StyleFilter styleFilter) {
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "com/android/tools/idea/uibuilder/property/editors/support/StyleEnumSupport", "<init>"));
        }
        if (styleFilter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "styleFilter", "com/android/tools/idea/uibuilder/property/editors/support/StyleEnumSupport", "<init>"));
        }
        super(property);
        this.myStyleFilter = styleFilter;
    }

    @Override
    @NotNull
    public List<ValueWithDisplayString> getAllValues() {
        String tagName = this.myProperty.getTagName();
        assert (tagName != null);
        List<ValueWithDisplayString> list = this.convertStylesToDisplayValues(this.myStyleFilter.getWidgetStyles(tagName));
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/property/editors/support/StyleEnumSupport", "getAllValues"));
        }
        return list;
    }

    @Override
    @NotNull
    protected ValueWithDisplayString createFromResolvedValue(@NotNull String resolvedValue, @Nullable String value, @Nullable String hint) {
        if (resolvedValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolvedValue", "com/android/tools/idea/uibuilder/property/editors/support/StyleEnumSupport", "createFromResolvedValue"));
        }
        if (!(value == null || value.startsWith("@style/") || value.startsWith("@android:style/") || value.startsWith("?attr/"))) {
            ResourceResolver resolver = this.myProperty.getResolver();
            StyleResourceValue resource = resolver.getStyle(value, true);
            String prefix = resource != null ? "@android:style/" : "@style/";
            value = prefix + value;
        }
        String display = resolvedValue;
        display = StringUtil.trimStart((String)display, (String)"@android:style/");
        display = StringUtil.trimStart((String)display, (String)"@style/");
        ValueWithDisplayString valueWithDisplayString = new ValueWithDisplayString(display, value, this.generateHint(display, value));
        if (valueWithDisplayString == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/property/editors/support/StyleEnumSupport", "createFromResolvedValue"));
        }
        return valueWithDisplayString;
    }

    @Nullable
    protected String generateHint(@NotNull String display, @Nullable String value) {
        if (display == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "display", "com/android/tools/idea/uibuilder/property/editors/support/StyleEnumSupport", "generateHint"));
        }
        if (value == null) {
            return "default";
        }
        if (value.endsWith(display)) {
            return null;
        }
        return value;
    }

    @NotNull
    protected List<ValueWithDisplayString> convertStylesToDisplayValues(@NotNull List<StyleResourceValue> styles) {
        if (styles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "styles", "com/android/tools/idea/uibuilder/property/editors/support/StyleEnumSupport", "convertStylesToDisplayValues"));
        }
        ArrayList<ValueWithDisplayString> values = new ArrayList<ValueWithDisplayString>();
        StyleResourceValue previousStyle = null;
        for (StyleResourceValue style : styles) {
            if (previousStyle != null && (previousStyle.isFramework() != style.isFramework() || previousStyle.isUserDefined() != style.isUserDefined())) {
                values.add(ValueWithDisplayString.SEPARATOR);
            }
            previousStyle = style;
            String prefix = style.isFramework() ? "@android:style/" : "@style/";
            values.add(this.createFromResolvedValue(style.getName(), prefix + style.getName(), null));
        }
        ArrayList<ValueWithDisplayString> arrayList = values;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/property/editors/support/StyleEnumSupport", "convertStylesToDisplayValues"));
        }
        return arrayList;
    }
}

