/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.property.inspector;

import com.android.tools.idea.uibuilder.model.NlComponent;
import com.android.tools.idea.uibuilder.property.NlProperties;
import com.android.tools.idea.uibuilder.property.NlPropertiesManager;
import com.android.tools.idea.uibuilder.property.NlProperty;
import com.android.tools.idea.uibuilder.property.editors.NlComponentEditor;
import com.android.tools.idea.uibuilder.property.inspector.InspectorComponent;
import com.android.tools.idea.uibuilder.property.inspector.InspectorPanel;
import com.android.tools.idea.uibuilder.property.inspector.InspectorProvider;
import icons.AndroidIcons;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.swing.JLabel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FavoritesInspectorProvider
implements InspectorProvider {
    private final List<String> myStarredPropertyNames = new ArrayList<String>();
    private FavoritesInspectorComponent myInspectorComponent;
    private String myLastStarredPropertyListValue;

    @Override
    public boolean isApplicable(@NotNull List<NlComponent> components, @NotNull Map<String, NlProperty> properties, @NotNull NlPropertiesManager propertiesManager) {
        if (components == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "components", "com/android/tools/idea/uibuilder/property/inspector/FavoritesInspectorProvider", "isApplicable"));
        }
        if (properties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "com/android/tools/idea/uibuilder/property/inspector/FavoritesInspectorProvider", "isApplicable"));
        }
        if (propertiesManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertiesManager", "com/android/tools/idea/uibuilder/property/inspector/FavoritesInspectorProvider", "isApplicable"));
        }
        this.loadStarredPropertiesIfNeeded();
        for (String propertyName : this.myStarredPropertyNames) {
            if (!properties.containsKey(FavoritesInspectorProvider.removePropertyPrefix(propertyName))) continue;
            return true;
        }
        return false;
    }

    @Override
    @NotNull
    public InspectorComponent createCustomInspector(@NotNull List<NlComponent> components, @NotNull Map<String, NlProperty> properties, @NotNull NlPropertiesManager propertiesManager) {
        if (components == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "components", "com/android/tools/idea/uibuilder/property/inspector/FavoritesInspectorProvider", "createCustomInspector"));
        }
        if (properties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "com/android/tools/idea/uibuilder/property/inspector/FavoritesInspectorProvider", "createCustomInspector"));
        }
        if (propertiesManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertiesManager", "com/android/tools/idea/uibuilder/property/inspector/FavoritesInspectorProvider", "createCustomInspector"));
        }
        if (this.myInspectorComponent == null) {
            this.myInspectorComponent = new FavoritesInspectorComponent(this.myStarredPropertyNames);
        }
        this.myInspectorComponent.updateProperties(components, properties, propertiesManager);
        FavoritesInspectorComponent favoritesInspectorComponent = this.myInspectorComponent;
        if (favoritesInspectorComponent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/property/inspector/FavoritesInspectorProvider", "createCustomInspector"));
        }
        return favoritesInspectorComponent;
    }

    @Override
    public void resetCache() {
        this.myLastStarredPropertyListValue = null;
        this.myStarredPropertyNames.clear();
        this.myInspectorComponent = null;
    }

    private void loadStarredPropertiesIfNeeded() {
        if (!Objects.equals(this.myLastStarredPropertyListValue, NlProperties.getStarredPropertiesAsString())) {
            this.loadStarredProperties();
        }
    }

    private void loadStarredProperties() {
        this.myLastStarredPropertyListValue = NlProperties.getStarredPropertiesAsString();
        this.myStarredPropertyNames.clear();
        for (String propertyName : NlProperties.getStarredProperties()) {
            if (!propertyName.startsWith("tools:")) {
                propertyName = FavoritesInspectorProvider.removePropertyPrefix(propertyName);
            }
            this.myStarredPropertyNames.add(propertyName);
        }
        Collections.sort(this.myStarredPropertyNames);
    }

    @NotNull
    private static String removePropertyPrefix(@NotNull String propertyName) {
        if (propertyName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyName", "com/android/tools/idea/uibuilder/property/inspector/FavoritesInspectorProvider", "removePropertyPrefix"));
        }
        String string = propertyName.substring(propertyName.indexOf(58) + 1);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/property/inspector/FavoritesInspectorProvider", "removePropertyPrefix"));
        }
        return string;
    }

    private static class FavoritesInspectorComponent
    implements InspectorComponent {
        private final List<String> myStarredPropertyNames;
        private final Map<String, NlComponentEditor> myEditorMap;

        private FavoritesInspectorComponent(@NotNull List<String> starredPropertyNames) {
            if (starredPropertyNames == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "starredPropertyNames", "com/android/tools/idea/uibuilder/property/inspector/FavoritesInspectorProvider$FavoritesInspectorComponent", "<init>"));
            }
            this.myStarredPropertyNames = starredPropertyNames;
            this.myEditorMap = new HashMap<String, NlComponentEditor>(starredPropertyNames.size());
        }

        @Override
        public void updateProperties(@NotNull List<NlComponent> components, @NotNull Map<String, NlProperty> properties, @NotNull NlPropertiesManager propertiesManager) {
            if (components == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "components", "com/android/tools/idea/uibuilder/property/inspector/FavoritesInspectorProvider$FavoritesInspectorComponent", "updateProperties"));
            }
            if (properties == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "com/android/tools/idea/uibuilder/property/inspector/FavoritesInspectorProvider$FavoritesInspectorComponent", "updateProperties"));
            }
            if (propertiesManager == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertiesManager", "com/android/tools/idea/uibuilder/property/inspector/FavoritesInspectorProvider$FavoritesInspectorComponent", "updateProperties"));
            }
            this.myEditorMap.clear();
            for (String propertyName : this.myStarredPropertyNames) {
                NlComponentEditor editor = this.myEditorMap.get(propertyName);
                if (editor != null) {
                    editor.refresh();
                    continue;
                }
                editor = FavoritesInspectorComponent.createEditor(propertyName, properties, propertiesManager);
                if (editor == null) continue;
                this.myEditorMap.put(propertyName, editor);
            }
        }

        @Nullable
        private static NlComponentEditor createEditor(@NotNull String propertyName, @NotNull Map<String, NlProperty> properties, @NotNull NlPropertiesManager propertiesManager) {
            if (propertyName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyName", "com/android/tools/idea/uibuilder/property/inspector/FavoritesInspectorProvider$FavoritesInspectorComponent", "createEditor"));
            }
            if (properties == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "com/android/tools/idea/uibuilder/property/inspector/FavoritesInspectorProvider$FavoritesInspectorComponent", "createEditor"));
            }
            if (propertiesManager == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertiesManager", "com/android/tools/idea/uibuilder/property/inspector/FavoritesInspectorProvider$FavoritesInspectorComponent", "createEditor"));
            }
            boolean designPropertyRequired = propertyName.startsWith("tools:");
            NlProperty property = properties.get(propertyName = FavoritesInspectorProvider.removePropertyPrefix(propertyName));
            if (property == null) {
                return null;
            }
            if (designPropertyRequired) {
                property = property.getDesignTimeProperty();
            }
            NlComponentEditor editor = propertiesManager.getPropertyEditors().create(property);
            editor.setProperty(property);
            return editor;
        }

        @Override
        public int getMaxNumberOfRows() {
            return 1 + this.myStarredPropertyNames.size();
        }

        @Override
        public void attachToInspector(@NotNull InspectorPanel inspector) {
            if (inspector == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inspector", "com/android/tools/idea/uibuilder/property/inspector/FavoritesInspectorProvider$FavoritesInspectorComponent", "attachToInspector"));
            }
            inspector.addTitle("Favorite Attributes");
            for (String propertyName : this.myStarredPropertyNames) {
                NlProperty property;
                NlComponentEditor editor = this.myEditorMap.get(propertyName);
                if (editor == null || (property = editor.getProperty()) == null) continue;
                JLabel label = inspector.addComponent(property.getName(), property.getTooltipText(), editor.getComponent());
                if ("http://schemas.android.com/tools".equals(property.getNamespace())) {
                    label.setIcon(AndroidIcons.NeleIcons.DesignProperty);
                }
                editor.setLabel(label);
            }
        }

        @Override
        public void refresh() {
            for (String propertyName : this.myStarredPropertyNames) {
                NlComponentEditor editor = this.myEditorMap.get(propertyName);
                if (editor == null) continue;
                editor.refresh();
            }
        }

        @Override
        @NotNull
        public List<NlComponentEditor> getEditors() {
            ArrayList<NlComponentEditor> editors = new ArrayList<NlComponentEditor>(this.myStarredPropertyNames.size());
            for (String propertyName : this.myStarredPropertyNames) {
                NlComponentEditor editor = this.myEditorMap.get(propertyName);
                if (editor == null) continue;
                editors.add(editor);
            }
            ArrayList<NlComponentEditor> arrayList = editors;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/property/inspector/FavoritesInspectorProvider$FavoritesInspectorComponent", "getEditors"));
            }
            return arrayList;
        }
    }
}

