/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.property.inspector;

import com.android.tools.idea.uibuilder.mockup.editor.FileChooserActionListener;
import com.android.tools.idea.uibuilder.model.NlComponent;
import com.android.tools.idea.uibuilder.property.NlPropertiesManager;
import com.android.tools.idea.uibuilder.property.NlProperty;
import com.android.tools.idea.uibuilder.property.editors.NlComponentEditor;
import com.android.tools.idea.uibuilder.property.editors.NlEditingListener;
import com.android.tools.idea.uibuilder.property.editors.NlReferenceEditor;
import com.android.tools.idea.uibuilder.property.inspector.InspectorComponent;
import com.android.tools.idea.uibuilder.property.inspector.InspectorPanel;
import com.android.tools.idea.uibuilder.property.inspector.InspectorProvider;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import java.awt.Component;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.BorderFactory;
import org.jetbrains.annotations.NotNull;

public class MockupInspectorProvider
implements InspectorProvider {
    private static final Set<String> MOCKUP_PROPERTIES = ImmutableSet.of((Object)"mockup");
    private MockupInspectorComponent myInspector;

    @Override
    public boolean isApplicable(@NotNull List<NlComponent> components, @NotNull Map<String, NlProperty> properties, @NotNull NlPropertiesManager propertiesManager) {
        if (components == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "components", "com/android/tools/idea/uibuilder/property/inspector/MockupInspectorProvider", "isApplicable"));
        }
        if (properties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "com/android/tools/idea/uibuilder/property/inspector/MockupInspectorProvider", "isApplicable"));
        }
        if (propertiesManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertiesManager", "com/android/tools/idea/uibuilder/property/inspector/MockupInspectorProvider", "isApplicable"));
        }
        return false;
    }

    @Override
    @NotNull
    public InspectorComponent createCustomInspector(@NotNull List<NlComponent> components, @NotNull Map<String, NlProperty> properties, @NotNull NlPropertiesManager propertiesManager) {
        if (components == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "components", "com/android/tools/idea/uibuilder/property/inspector/MockupInspectorProvider", "createCustomInspector"));
        }
        if (properties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "com/android/tools/idea/uibuilder/property/inspector/MockupInspectorProvider", "createCustomInspector"));
        }
        if (propertiesManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertiesManager", "com/android/tools/idea/uibuilder/property/inspector/MockupInspectorProvider", "createCustomInspector"));
        }
        if (this.myInspector == null) {
            this.myInspector = new MockupInspectorComponent(propertiesManager.getProject());
        }
        this.myInspector.updateProperties(components, properties, propertiesManager);
        MockupInspectorComponent mockupInspectorComponent = this.myInspector;
        if (mockupInspectorComponent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/property/inspector/MockupInspectorProvider", "createCustomInspector"));
        }
        return mockupInspectorComponent;
    }

    @Override
    public void resetCache() {
        this.myInspector = null;
    }

    private static class MockupInspectorComponent
    implements InspectorComponent {
        public static final String TITLE = "View Mockup";
        private final NlReferenceEditor myOpacityEditor;
        private final FileChooserActionListener myFileChooserListener;
        private NlProperty myMockupPath;
        private NlProperty myOpacityProperty;
        private TextFieldWithBrowseButton myFileChooser;

        public MockupInspectorComponent(@NotNull Project project) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/uibuilder/property/inspector/MockupInspectorProvider$MockupInspectorComponent", "<init>"));
            }
            this.myOpacityEditor = NlReferenceEditor.createForInspector(project, NlEditingListener.DEFAULT_LISTENER);
            this.myFileChooserListener = new FileChooserActionListener();
            this.myFileChooser = MockupInspectorComponent.createFileChooser(this.myFileChooserListener);
        }

        @Override
        public void updateProperties(@NotNull List<NlComponent> components, @NotNull Map<String, NlProperty> properties, @NotNull NlPropertiesManager propertiesManager) {
            if (components == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "components", "com/android/tools/idea/uibuilder/property/inspector/MockupInspectorProvider$MockupInspectorComponent", "updateProperties"));
            }
            if (properties == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "com/android/tools/idea/uibuilder/property/inspector/MockupInspectorProvider$MockupInspectorComponent", "updateProperties"));
            }
            if (propertiesManager == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertiesManager", "com/android/tools/idea/uibuilder/property/inspector/MockupInspectorProvider$MockupInspectorComponent", "updateProperties"));
            }
            this.myMockupPath = properties.get("mockup");
            this.myOpacityProperty = properties.get("mockup_opacity");
        }

        @Override
        public int getMaxNumberOfRows() {
            return 3;
        }

        @Override
        public void attachToInspector(@NotNull InspectorPanel inspector) {
            if (inspector == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inspector", "com/android/tools/idea/uibuilder/property/inspector/MockupInspectorProvider$MockupInspectorComponent", "attachToInspector"));
            }
            this.refresh();
            inspector.addTitle(TITLE);
            inspector.addComponent("mockup", this.myMockupPath.getTooltipText(), (Component)this.myFileChooser);
            inspector.addComponent("mockup_opacity", null, this.myOpacityEditor.getComponent());
        }

        private static TextFieldWithBrowseButton createFileChooser(@NotNull FileChooserActionListener listener) {
            if (listener == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/android/tools/idea/uibuilder/property/inspector/MockupInspectorProvider$MockupInspectorComponent", "createFileChooser"));
            }
            TextFieldWithBrowseButton fileChooser = new TextFieldWithBrowseButton();
            fileChooser.setEditable(false);
            fileChooser.setBorder(BorderFactory.createEmptyBorder(2, 0, 2, 0));
            fileChooser.addActionListener((ActionListener)listener);
            return fileChooser;
        }

        @Override
        public void refresh() {
            if (this.myFileChooser != null && !this.myFileChooser.getText().equals(this.myMockupPath.getValue())) {
                this.myFileChooser.setText(this.myMockupPath.getValue());
            }
            this.myOpacityEditor.setProperty(this.myOpacityProperty);
            this.myFileChooserListener.setFilePathProperty(this.myMockupPath);
        }

        @Override
        @NotNull
        public List<NlComponentEditor> getEditors() {
            ImmutableList immutableList = ImmutableList.of((Object)this.myOpacityEditor);
            if (immutableList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/property/inspector/MockupInspectorProvider$MockupInspectorComponent", "getEditors"));
            }
            return immutableList;
        }
    }
}

