/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.property.inspector;

import com.android.tools.idea.uibuilder.model.NlComponent;
import com.android.tools.idea.uibuilder.property.NlPropertiesManager;
import com.android.tools.idea.uibuilder.property.NlProperty;
import com.android.tools.idea.uibuilder.property.inspector.FavoritesInspectorProvider;
import com.android.tools.idea.uibuilder.property.inspector.IdInspectorProvider;
import com.android.tools.idea.uibuilder.property.inspector.InspectorComponent;
import com.android.tools.idea.uibuilder.property.inspector.InspectorProvider;
import com.android.tools.idea.uibuilder.property.inspector.MockupInspectorProvider;
import com.android.tools.idea.uibuilder.property.inspector.ProgressBarInspectorProvider;
import com.android.tools.idea.uibuilder.property.inspector.TextInspectorProvider;
import com.android.tools.idea.uibuilder.property.inspector.ViewInspectorProvider;
import com.google.common.collect.ImmutableList;
import com.intellij.ide.ui.LafManager;
import com.intellij.ide.ui.LafManagerListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class NlInspectorProviders
implements LafManagerListener,
Disposable {
    private final NlPropertiesManager myPropertiesManager;
    private final IdInspectorProvider myIdInspectorProvider;
    private final List<InspectorProvider> myProviders;

    public NlInspectorProviders(@NotNull NlPropertiesManager propertiesManager, @NotNull Disposable parentDisposable) {
        if (propertiesManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertiesManager", "com/android/tools/idea/uibuilder/property/inspector/NlInspectorProviders", "<init>"));
        }
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDisposable", "com/android/tools/idea/uibuilder/property/inspector/NlInspectorProviders", "<init>"));
        }
        this.myPropertiesManager = propertiesManager;
        this.myIdInspectorProvider = new IdInspectorProvider();
        this.myProviders = ImmutableList.of((Object)this.myIdInspectorProvider, (Object)new ViewInspectorProvider(this.myPropertiesManager.getProject()), (Object)new ProgressBarInspectorProvider(), (Object)new TextInspectorProvider(), (Object)new MockupInspectorProvider(), (Object)new FavoritesInspectorProvider());
        Disposer.register((Disposable)parentDisposable, (Disposable)this);
        LafManager.getInstance().addLafManagerListener((LafManagerListener)this);
    }

    @NotNull
    public List<InspectorComponent> createInspectorComponents(@NotNull List<NlComponent> components, @NotNull Map<String, NlProperty> properties, @NotNull NlPropertiesManager propertiesManager) {
        if (components == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "components", "com/android/tools/idea/uibuilder/property/inspector/NlInspectorProviders", "createInspectorComponents"));
        }
        if (properties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "com/android/tools/idea/uibuilder/property/inspector/NlInspectorProviders", "createInspectorComponents"));
        }
        if (propertiesManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertiesManager", "com/android/tools/idea/uibuilder/property/inspector/NlInspectorProviders", "createInspectorComponents"));
        }
        ArrayList<InspectorComponent> inspectors = new ArrayList<InspectorComponent>(this.myProviders.size());
        if (components.isEmpty()) {
            ImmutableList immutableList = ImmutableList.of((Object)this.myIdInspectorProvider.createCustomInspector((List)components, (Map)properties, propertiesManager));
            if (immutableList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/property/inspector/NlInspectorProviders", "createInspectorComponents"));
            }
            return immutableList;
        }
        for (InspectorProvider provider : this.myProviders) {
            if (!provider.isApplicable(components, properties, propertiesManager)) continue;
            inspectors.add(provider.createCustomInspector(components, properties, propertiesManager));
        }
        ArrayList<InspectorComponent> arrayList = inspectors;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/property/inspector/NlInspectorProviders", "createInspectorComponents"));
        }
        return arrayList;
    }

    public void lookAndFeelChanged(LafManager source) {
        this.myProviders.forEach(InspectorProvider::resetCache);
        this.myPropertiesManager.updateSelection();
    }

    public void dispose() {
        LafManager.getInstance().removeLafManagerListener((LafManagerListener)this);
    }
}

