/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.property.inspector;

import com.android.tools.idea.uibuilder.api.ViewHandler;
import com.android.tools.idea.uibuilder.handlers.ViewHandlerManager;
import com.android.tools.idea.uibuilder.model.NlComponent;
import com.android.tools.idea.uibuilder.property.NlPropertiesManager;
import com.android.tools.idea.uibuilder.property.NlProperty;
import com.android.tools.idea.uibuilder.property.editors.NlComponentEditor;
import com.android.tools.idea.uibuilder.property.inspector.InspectorComponent;
import com.android.tools.idea.uibuilder.property.inspector.InspectorPanel;
import com.android.tools.idea.uibuilder.property.inspector.InspectorProvider;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import icons.AndroidIcons;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JLabel;
import org.jetbrains.annotations.NotNull;

public class ViewInspectorProvider
implements InspectorProvider {
    private static final Set<String> TAG_EXCEPTIONS = ImmutableSet.of((Object)"TextView", (Object)"ProgressBar");
    private final ViewHandlerManager myViewHandlerManager;
    private final Map<String, InspectorComponent> myInspectors;

    public ViewInspectorProvider(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/uibuilder/property/inspector/ViewInspectorProvider", "<init>"));
        }
        this.myViewHandlerManager = ViewHandlerManager.get(project);
        this.myInspectors = new HashMap<String, InspectorComponent>();
    }

    @Override
    public boolean isApplicable(@NotNull List<NlComponent> components, @NotNull Map<String, NlProperty> properties, @NotNull NlPropertiesManager propertiesManager) {
        if (components == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "components", "com/android/tools/idea/uibuilder/property/inspector/ViewInspectorProvider", "isApplicable"));
        }
        if (properties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "com/android/tools/idea/uibuilder/property/inspector/ViewInspectorProvider", "isApplicable"));
        }
        if (propertiesManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertiesManager", "com/android/tools/idea/uibuilder/property/inspector/ViewInspectorProvider", "isApplicable"));
        }
        if (components.size() != 1) {
            return false;
        }
        String tagName = components.get(0).getTagName();
        if (TAG_EXCEPTIONS.contains(tagName)) {
            return false;
        }
        if (this.myInspectors.containsKey(tagName)) {
            return true;
        }
        ViewHandler handler = this.myViewHandlerManager.getHandler(tagName);
        if (handler == null || handler.getInspectorProperties().isEmpty()) {
            return false;
        }
        this.myInspectors.put(tagName, new ViewInspectorComponent(tagName, properties, propertiesManager, handler.getInspectorProperties()));
        return true;
    }

    @Override
    @NotNull
    public InspectorComponent createCustomInspector(@NotNull List<NlComponent> components, @NotNull Map<String, NlProperty> properties, @NotNull NlPropertiesManager propertiesManager) {
        if (components == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "components", "com/android/tools/idea/uibuilder/property/inspector/ViewInspectorProvider", "createCustomInspector"));
        }
        if (properties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "com/android/tools/idea/uibuilder/property/inspector/ViewInspectorProvider", "createCustomInspector"));
        }
        if (propertiesManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertiesManager", "com/android/tools/idea/uibuilder/property/inspector/ViewInspectorProvider", "createCustomInspector"));
        }
        assert (components.size() == 1);
        String tagName = components.get(0).getTagName();
        InspectorComponent inspector = this.myInspectors.get(tagName);
        assert (inspector != null);
        inspector.updateProperties(components, properties, propertiesManager);
        InspectorComponent inspectorComponent = inspector;
        if (inspectorComponent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/property/inspector/ViewInspectorProvider", "createCustomInspector"));
        }
        return inspectorComponent;
    }

    @Override
    public void resetCache() {
        this.myInspectors.clear();
    }

    private static class ViewInspectorComponent
    implements InspectorComponent {
        private static final List<String> LAYOUT_PROPERTIES = ImmutableList.of((Object)"layout_scrollFlags", (Object)"layout_collapseMode", (Object)"layout_collapseParallaxMultiplier", (Object)"layout_behavior");
        private final String myComponentName;
        private final List<String> myPropertyNames;
        private final List<NlComponentEditor> myEditors;
        private final int mySrcPropertyIndex;

        public ViewInspectorComponent(@NotNull String tagName, @NotNull Map<String, NlProperty> properties, @NotNull NlPropertiesManager propertiesManager, @NotNull List<String> propertyNames) {
            if (tagName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tagName", "com/android/tools/idea/uibuilder/property/inspector/ViewInspectorProvider$ViewInspectorComponent", "<init>"));
            }
            if (properties == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "com/android/tools/idea/uibuilder/property/inspector/ViewInspectorProvider$ViewInspectorComponent", "<init>"));
            }
            if (propertiesManager == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertiesManager", "com/android/tools/idea/uibuilder/property/inspector/ViewInspectorProvider$ViewInspectorComponent", "<init>"));
            }
            if (propertyNames == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyNames", "com/android/tools/idea/uibuilder/property/inspector/ViewInspectorProvider$ViewInspectorComponent", "<init>"));
            }
            this.myComponentName = tagName.substring(tagName.lastIndexOf(46) + 1);
            this.myPropertyNames = ViewInspectorComponent.combineLists(propertyNames, LAYOUT_PROPERTIES);
            this.mySrcPropertyIndex = this.myPropertyNames.indexOf("src");
            this.myEditors = new ArrayList<NlComponentEditor>(this.myPropertyNames.size());
            this.createEditors(properties, propertiesManager);
        }

        private void createEditors(@NotNull Map<String, NlProperty> properties, @NotNull NlPropertiesManager propertiesManager) {
            if (properties == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "com/android/tools/idea/uibuilder/property/inspector/ViewInspectorProvider$ViewInspectorComponent", "createEditors"));
            }
            if (propertiesManager == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertiesManager", "com/android/tools/idea/uibuilder/property/inspector/ViewInspectorProvider$ViewInspectorComponent", "createEditors"));
            }
            for (String propertyName : this.myPropertyNames) {
                boolean designPropertyRequired = propertyName.startsWith("tools:");
                NlProperty property = properties.get(propertyName = StringUtil.trimStart((String)propertyName, (String)"tools:"));
                if (property == null) continue;
                if (designPropertyRequired) {
                    property = property.getDesignTimeProperty();
                }
                NlComponentEditor editor = propertiesManager.getPropertyEditors().create(property);
                editor.setProperty(property);
                this.myEditors.add(editor);
            }
        }

        @Override
        public void updateProperties(@NotNull List<NlComponent> components, @NotNull Map<String, NlProperty> properties, @NotNull NlPropertiesManager propertiesManager) {
            if (components == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "components", "com/android/tools/idea/uibuilder/property/inspector/ViewInspectorProvider$ViewInspectorComponent", "updateProperties"));
            }
            if (properties == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "com/android/tools/idea/uibuilder/property/inspector/ViewInspectorProvider$ViewInspectorComponent", "updateProperties"));
            }
            if (propertiesManager == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertiesManager", "com/android/tools/idea/uibuilder/property/inspector/ViewInspectorProvider$ViewInspectorComponent", "updateProperties"));
            }
            this.useSrcCompatIfExist(properties);
            this.myEditors.clear();
            this.createEditors(properties, propertiesManager);
        }

        @Override
        @NotNull
        public List<NlComponentEditor> getEditors() {
            List<NlComponentEditor> list = this.myEditors;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/property/inspector/ViewInspectorProvider$ViewInspectorComponent", "getEditors"));
            }
            return list;
        }

        @Override
        public int getMaxNumberOfRows() {
            return 1 + this.myEditors.size();
        }

        @Override
        public void attachToInspector(@NotNull InspectorPanel inspector) {
            if (inspector == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inspector", "com/android/tools/idea/uibuilder/property/inspector/ViewInspectorProvider$ViewInspectorComponent", "attachToInspector"));
            }
            this.refresh();
            inspector.addTitle(this.myComponentName);
            for (NlComponentEditor editor : this.myEditors) {
                NlProperty property = editor.getProperty();
                if (property == null) continue;
                String propertyName = property.getName();
                JLabel label = inspector.addComponent(propertyName, property.getTooltipText(), editor.getComponent());
                if ("http://schemas.android.com/tools".equals(property.getNamespace())) {
                    label.setIcon(AndroidIcons.NeleIcons.DesignProperty);
                }
                editor.setLabel(label);
            }
        }

        @Override
        public void refresh() {
            this.myEditors.forEach(NlComponentEditor::refresh);
        }

        @NotNull
        private static List<String> combineLists(@NotNull List<String> list1, @NotNull List<String> list2) {
            if (list1 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list1", "com/android/tools/idea/uibuilder/property/inspector/ViewInspectorProvider$ViewInspectorComponent", "combineLists"));
            }
            if (list2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list2", "com/android/tools/idea/uibuilder/property/inspector/ViewInspectorProvider$ViewInspectorComponent", "combineLists"));
            }
            ArrayList<String> combined = new ArrayList<String>(list1.size() + list2.size());
            combined.addAll(list1);
            combined.addAll(list2);
            ArrayList<String> arrayList = combined;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/property/inspector/ViewInspectorProvider$ViewInspectorComponent", "combineLists"));
            }
            return arrayList;
        }

        private void useSrcCompatIfExist(@NotNull Map<String, NlProperty> properties) {
            if (properties == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "com/android/tools/idea/uibuilder/property/inspector/ViewInspectorProvider$ViewInspectorComponent", "useSrcCompatIfExist"));
            }
            if (this.mySrcPropertyIndex < 0) {
                return;
            }
            this.myPropertyNames.set(this.mySrcPropertyIndex, properties.containsKey("srcCompat") ? "srcCompat" : "src");
        }
    }
}

