/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.scene;

import com.android.tools.idea.uibuilder.model.Coordinates;
import com.android.tools.idea.uibuilder.surface.DesignSurface;
import com.android.tools.idea.uibuilder.surface.ScreenView;
import com.android.tools.sherpa.drawing.AndroidColorSet;
import com.android.tools.sherpa.drawing.BlueprintColorSet;
import com.android.tools.sherpa.drawing.ColorSet;
import java.util.WeakHashMap;

public class SceneContext {
    ColorSet myColorSet;
    Long myTime = System.currentTimeMillis();
    private static SceneContext lazySingleton;
    private static WeakHashMap<ScreenView, ScreenViewTransform> cache;

    private SceneContext() {
    }

    public long getTime() {
        return this.myTime;
    }

    public void setTime(long time) {
        this.myTime = time;
    }

    public void repaint() {
    }

    public int getSwingX(float x) {
        return (int)x;
    }

    public int getSwingY(float y) {
        return (int)y;
    }

    public int getSwingDimension(float x) {
        return (int)x;
    }

    public ColorSet getColorSet() {
        return this.myColorSet;
    }

    public double getScale() {
        return 1.0;
    }

    public static SceneContext get() {
        if (lazySingleton == null) {
            lazySingleton = new SceneContext();
            SceneContext.lazySingleton.myColorSet = new BlueprintColorSet();
        }
        return lazySingleton;
    }

    public static SceneContext get(ScreenView screenView) {
        if (cache.containsKey(screenView)) {
            return cache.get(screenView);
        }
        ScreenViewTransform screenViewTransform = new ScreenViewTransform(screenView);
        screenViewTransform.myColorSet = screenView.getScreenViewType() == ScreenView.ScreenViewType.BLUEPRINT ? new BlueprintColorSet() : new AndroidColorSet();
        cache.put(screenView, screenViewTransform);
        return screenViewTransform;
    }

    public DesignSurface getSurface() {
        return null;
    }

    static {
        cache = new WeakHashMap();
    }

    private static class ScreenViewTransform
    extends SceneContext {
        ScreenView myScreenView;

        public ScreenViewTransform(ScreenView screenView) {
            this.myScreenView = screenView;
        }

        @Override
        public DesignSurface getSurface() {
            return this.myScreenView.getSurface();
        }

        @Override
        public double getScale() {
            return this.myScreenView.getScale();
        }

        @Override
        public int getSwingX(float x) {
            return Coordinates.getSwingX(this.myScreenView, Coordinates.dpToPx(this.myScreenView, x));
        }

        @Override
        public int getSwingY(float y) {
            return Coordinates.getSwingY(this.myScreenView, Coordinates.dpToPx(this.myScreenView, y));
        }

        @Override
        public void repaint() {
            this.myScreenView.getSurface().repaint();
        }

        @Override
        public int getSwingDimension(float v) {
            return Coordinates.getSwingDimension(this.myScreenView, Coordinates.dpToPx(this.myScreenView, v));
        }
    }
}

